/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

public enum FatType {
    FAT12(4080, 4095L, 1.5f, "FAT12   "){

        @Override
        long readEntry(byte[] data, int index) {
            int idx = (int)((double)index * 1.5);
            int b1 = data[idx] & 0xFF;
            int b2 = data[idx + 1] & 0xFF;
            int v = b2 << 8 | b1;
            if (index % 2 == 0) {
                return v & 0xFFF;
            }
            return v >> 4;
        }

        @Override
        void writeEntry(byte[] data, int index, long entry) {
            int idx = (int)((double)index * 1.5);
            if (index % 2 == 0) {
                data[idx] = (byte)(entry & 0xFFL);
                data[idx + 1] = (byte)(entry >> 8 & 0xFL);
            } else {
                int n = idx;
                data[n] = (byte)(data[n] | (byte)((entry & 0xFL) << 4));
                data[idx + 1] = (byte)(entry >> 4 & 0xFFL);
            }
        }
    }
    ,
    FAT16(65520, 65535L, 2.0f, "FAT16   "){

        @Override
        long readEntry(byte[] data, int index) {
            int idx = index << 1;
            int b1 = data[idx] & 0xFF;
            int b2 = data[idx + 1] & 0xFF;
            return b2 << 8 | b1;
        }

        @Override
        void writeEntry(byte[] data, int index, long entry) {
            int idx = index << 1;
            data[idx] = (byte)(entry & 0xFFL);
            data[idx + 1] = (byte)(entry >> 8 & 0xFFL);
        }
    }
    ,
    FAT32(0xFFFFFF0, 0xFFFFFFFFL, 4.0f, "FAT32   "){

        @Override
        long readEntry(byte[] data, int index) {
            int idx = index * 4;
            long l1 = data[idx] & 0xFF;
            long l2 = data[idx + 1] & 0xFF;
            long l3 = data[idx + 2] & 0xFF;
            long l4 = data[idx + 3] & 0xFF;
            return l4 << 24 | l3 << 16 | l2 << 8 | l1;
        }

        @Override
        void writeEntry(byte[] data, int index, long entry) {
            int idx = index << 2;
            data[idx] = (byte)(entry & 0xFFL);
            data[idx + 1] = (byte)(entry >> 8 & 0xFFL);
            data[idx + 2] = (byte)(entry >> 16 & 0xFFL);
            data[idx + 3] = (byte)(entry >> 24 & 0xFFL);
        }
    };

    private final long minReservedEntry;
    private final long maxReservedEntry;
    private final long eofCluster;
    private final long eofMarker;
    private final long bitMask;
    private final int maxClusters;
    private final String label;
    private final float entrySize;

    private FatType(int maxClusters, long bitMask, float entrySize, String label) {
        this.minReservedEntry = 0xFFFFFF0L & bitMask;
        this.maxReservedEntry = 0xFFFFFF6L & bitMask;
        this.eofCluster = 0xFFFFFF8L & bitMask;
        this.eofMarker = 0xFFFFFFFL & bitMask;
        this.entrySize = entrySize;
        this.label = label;
        this.maxClusters = maxClusters;
        this.bitMask = bitMask;
    }

    abstract long readEntry(byte[] var1, int var2);

    abstract void writeEntry(byte[] var1, int var2, long var3);

    long maxClusters() {
        return this.maxClusters;
    }

    String getLabel() {
        return this.label;
    }

    boolean isReservedCluster(long entry) {
        return entry >= this.minReservedEntry && entry <= this.maxReservedEntry;
    }

    boolean isEofCluster(long entry) {
        return entry >= this.eofCluster;
    }

    long getEofMarker() {
        return this.eofMarker;
    }

    float getEntrySize() {
        return this.entrySize;
    }

    long getBitMask() {
        return this.bitMask;
    }
}

