/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.GuardedBy;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.BatteryFetcher;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.PropertyFetcher;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.log.LogReceiver;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Device
implements IDevice {
    static final String RE_EMULATOR_SN = "emulator-(\\d+)";
    private final String mSerialNumber;
    private String mAvdName = null;
    private IDevice.DeviceState mState = null;
    private final PropertyFetcher mPropFetcher = new PropertyFetcher(this);
    private final Map<String, String> mMountPoints = new HashMap<String, String>();
    private final BatteryFetcher mBatteryFetcher = new BatteryFetcher(this);
    @GuardedBy(value="mClients")
    private final List<Client> mClients = new ArrayList<Client>();
    private final Map<Integer, String> mClientInfo = new ConcurrentHashMap<Integer, String>();
    private DeviceMonitor mMonitor;
    private static final String LOG_TAG = "Device";
    private static final char SEPARATOR = '-';
    private static final String UNKNOWN_PACKAGE = "";
    private static final long INSTALL_TIMEOUT_MINUTES;
    private SocketChannel mSocketChannel;
    private Integer mLastBatteryLevel = null;
    private long mLastBatteryCheckTime = 0L;
    private static final String SCREEN_RECORDER_DEVICE_PATH = "/system/bin/screenrecord";
    private static final long LS_TIMEOUT_SEC = 2L;
    private Boolean mHasScreenRecorder;
    private Set<String> mHardwareCharacteristics;
    private int mApiLevel;
    private String mName;

    @Override
    @NonNull
    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    @Override
    public String getAvdName() {
        return this.mAvdName;
    }

    void setAvdName(String avdName) {
        if (!this.isEmulator()) {
            throw new IllegalArgumentException("Cannot set the AVD name of the device is not an emulator");
        }
        this.mAvdName = avdName;
    }

    @Override
    public String getName() {
        if (this.mName != null) {
            return this.mName;
        }
        if (this.isOnline()) {
            this.mName = this.constructName();
            return this.mName;
        }
        return this.constructName();
    }

    private String constructName() {
        if (this.isEmulator()) {
            String avdName = this.getAvdName();
            if (avdName != null) {
                return String.format("%s [%s]", avdName, this.getSerialNumber());
            }
            return this.getSerialNumber();
        }
        String manufacturer = null;
        String model = null;
        try {
            manufacturer = this.cleanupStringForDisplay(this.getSystemProperty("ro.product.manufacturer").get());
            model = this.cleanupStringForDisplay(this.getSystemProperty("ro.product.model").get());
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder(20);
        if (manufacturer != null) {
            sb.append(manufacturer);
            sb.append('-');
        }
        if (model != null) {
            sb.append(model);
            sb.append('-');
        }
        sb.append(this.getSerialNumber());
        return sb.toString();
    }

    private String cleanupStringForDisplay(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    @Override
    public IDevice.DeviceState getState() {
        return this.mState;
    }

    void setState(IDevice.DeviceState state) {
        this.mState = state;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.mPropFetcher.getProperties());
    }

    @Override
    public int getPropertyCount() {
        return this.mPropFetcher.getProperties().size();
    }

    @Override
    public String getProperty(String name) {
        Future<String> future = this.mPropFetcher.getProperty(name);
        try {
            return future.get(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
        }
        catch (java.util.concurrent.TimeoutException timeoutException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean arePropertiesSet() {
        return this.mPropFetcher.arePropertiesSet();
    }

    @Override
    public String getPropertyCacheOrSync(String name) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Future<String> future = this.mPropFetcher.getProperty(name);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getPropertySync(String name) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Future<String> future = this.mPropFetcher.getProperty(name);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @NonNull
    public Future<String> getSystemProperty(@NonNull String name) {
        return this.mPropFetcher.getProperty(name);
    }

    @Override
    public boolean supportsFeature(@NonNull IDevice.Feature feature) {
        switch (feature) {
            case SCREEN_RECORD: {
                if (this.getApiLevel() < 19) {
                    return false;
                }
                if (this.mHasScreenRecorder == null) {
                    this.mHasScreenRecorder = this.hasBinary(SCREEN_RECORDER_DEVICE_PATH);
                }
                return this.mHasScreenRecorder;
            }
            case PROCSTATS: {
                return this.getApiLevel() >= 19;
            }
        }
        return false;
    }

    @Override
    public boolean supportsFeature(@NonNull IDevice.HardwareFeature feature) {
        if (this.mHardwareCharacteristics == null) {
            try {
                String characteristics = this.getSystemProperty("ro.build.characteristics").get();
                this.mHardwareCharacteristics = Sets.newHashSet(Splitter.on(',').split(characteristics));
            }
            catch (Exception e) {
                this.mHardwareCharacteristics = Collections.emptySet();
            }
        }
        return this.mHardwareCharacteristics.contains(feature.getCharacteristic());
    }

    private int getApiLevel() {
        if (this.mApiLevel > 0) {
            return this.mApiLevel;
        }
        try {
            this.mApiLevel = Integer.parseInt(this.getSystemProperty("ro.build.version.sdk").get());
            return this.mApiLevel;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private boolean hasBinary(String path) {
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        try {
            this.executeShellCommand("ls " + path, receiver);
        }
        catch (Exception e) {
            return false;
        }
        try {
            latch.await(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
        String value = receiver.getOutput().trim();
        return !value.endsWith("No such file or directory");
    }

    @Override
    public String getMountPoint(String name) {
        return this.mMountPoints.get(name);
    }

    public String toString() {
        return this.mSerialNumber;
    }

    @Override
    public boolean isOnline() {
        return this.mState == IDevice.DeviceState.ONLINE;
    }

    @Override
    public boolean isEmulator() {
        return this.mSerialNumber.matches(RE_EMULATOR_SN);
    }

    @Override
    public boolean isOffline() {
        return this.mState == IDevice.DeviceState.OFFLINE;
    }

    @Override
    public boolean isBootLoader() {
        return this.mState == IDevice.DeviceState.BOOTLOADER;
    }

    @Override
    public SyncService getSyncService() throws TimeoutException, AdbCommandRejectedException, IOException {
        SyncService syncService = new SyncService(AndroidDebugBridge.getSocketAddress(), this);
        if (syncService.openSync()) {
            return syncService;
        }
        return null;
    }

    @Override
    public FileListingService getFileListingService() {
        return new FileListingService(this);
    }

    @Override
    public RawImage getScreenshot() throws TimeoutException, AdbCommandRejectedException, IOException {
        return AdbHelper.getFrameBuffer(AndroidDebugBridge.getSocketAddress(), this);
    }

    @Override
    public void startScreenRecorder(String remoteFilePath, ScreenRecorderOptions options, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        this.executeShellCommand(Device.getScreenRecorderCommand(remoteFilePath, options), receiver, 0L, null);
    }

    static String getScreenRecorderCommand(@NonNull String remoteFilePath, @NonNull ScreenRecorderOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("screenrecord");
        sb.append(' ');
        if (options.width > 0 && options.height > 0) {
            sb.append("--size ");
            sb.append(options.width);
            sb.append('x');
            sb.append(options.height);
            sb.append(' ');
        }
        if (options.bitrateMbps > 0) {
            sb.append("--bit-rate ");
            sb.append(options.bitrateMbps * 1000000);
            sb.append(' ');
        }
        if (options.timeLimit > 0L) {
            sb.append("--time-limit ");
            long seconds = TimeUnit.SECONDS.convert(options.timeLimit, options.timeLimitUnits);
            if (seconds > 180L) {
                seconds = 180L;
            }
            sb.append(seconds);
            sb.append(' ');
        }
        sb.append(remoteFilePath);
        return sb.toString();
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), command, this, receiver, DdmPreferences.getTimeOut());
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, int maxTimeToOutputResponse) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), command, this, receiver, maxTimeToOutputResponse);
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), command, this, receiver, maxTimeToOutputResponse, maxTimeUnits);
    }

    @Override
    public void runEventLogService(LogReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runEventLogService(AndroidDebugBridge.getSocketAddress(), this, receiver);
    }

    @Override
    public void runLogService(String logname, LogReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runLogService(AndroidDebugBridge.getSocketAddress(), this, logname, receiver);
    }

    @Override
    public void createForward(int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.createForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", localPort), String.format("tcp:%d", remotePort));
    }

    @Override
    public void createForward(int localPort, String remoteSocketName, IDevice.DeviceUnixSocketNamespace namespace) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.createForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", localPort), String.format("%s:%s", namespace.getType(), remoteSocketName));
    }

    @Override
    public void removeForward(int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.removeForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", localPort), String.format("tcp:%d", remotePort));
    }

    @Override
    public void removeForward(int localPort, String remoteSocketName, IDevice.DeviceUnixSocketNamespace namespace) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.removeForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", localPort), String.format("%s:%s", namespace.getType(), remoteSocketName));
    }

    Device(DeviceMonitor monitor, String serialNumber, IDevice.DeviceState deviceState) {
        this.mMonitor = monitor;
        this.mSerialNumber = serialNumber;
        this.mState = deviceState;
    }

    DeviceMonitor getMonitor() {
        return this.mMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasClients() {
        List<Client> list = this.mClients;
        synchronized (list) {
            return !this.mClients.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client[] getClients() {
        List<Client> list = this.mClients;
        synchronized (list) {
            return this.mClients.toArray(new Client[this.mClients.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient(String applicationName) {
        List<Client> list = this.mClients;
        synchronized (list) {
            for (Client c : this.mClients) {
                if (!applicationName.equals(c.getClientData().getClientDescription())) continue;
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClient(Client client) {
        List<Client> list = this.mClients;
        synchronized (list) {
            this.mClients.add(client);
        }
        this.addClientInfo(client);
    }

    List<Client> getClientList() {
        return this.mClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearClientList() {
        List<Client> list = this.mClients;
        synchronized (list) {
            this.mClients.clear();
        }
        this.clearClientInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClient(Client client, boolean notify) {
        this.mMonitor.addPortToAvailableList(client.getDebuggerListenPort());
        List<Client> list = this.mClients;
        synchronized (list) {
            this.mClients.remove(client);
        }
        if (notify) {
            this.mMonitor.getServer().deviceChanged(this, 2);
        }
        this.removeClientInfo(client);
    }

    void setClientMonitoringSocket(SocketChannel socketChannel) {
        this.mSocketChannel = socketChannel;
    }

    SocketChannel getClientMonitoringSocket() {
        return this.mSocketChannel;
    }

    void update(int changeMask) {
        this.mMonitor.getServer().deviceChanged(this, changeMask);
    }

    void update(Client client, int changeMask) {
        this.mMonitor.getServer().clientChanged(client, changeMask);
        this.updateClientInfo(client, changeMask);
    }

    void setMountingPoint(String name, String value) {
        this.mMountPoints.put(name, value);
    }

    private void addClientInfo(Client client) {
        ClientData cd = client.getClientData();
        this.setClientInfo(cd.getPid(), cd.getClientDescription());
    }

    private void updateClientInfo(Client client, int changeMask) {
        if ((changeMask & 1) == 1) {
            this.addClientInfo(client);
        }
    }

    private void removeClientInfo(Client client) {
        int pid = client.getClientData().getPid();
        this.mClientInfo.remove(pid);
    }

    private void clearClientInfo() {
        this.mClientInfo.clear();
    }

    private void setClientInfo(int pid, String pkgName) {
        if (pkgName == null) {
            pkgName = UNKNOWN_PACKAGE;
        }
        this.mClientInfo.put(pid, pkgName);
    }

    @Override
    public String getClientName(int pid) {
        String pkgName = this.mClientInfo.get(pid);
        return pkgName == null ? UNKNOWN_PACKAGE : pkgName;
    }

    @Override
    public void pushFile(String local, String remote) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        block9: {
            SyncService sync = null;
            try {
                String targetFileName = Device.getFileName(local);
                Log.d(targetFileName, String.format("Uploading %1$s onto device '%2$s'", targetFileName, this.getSerialNumber()));
                sync = this.getSyncService();
                if (sync != null) {
                    String message = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
                    Log.d(LOG_TAG, message);
                    sync.pushFile(local, remote, SyncService.getNullProgressMonitor());
                    break block9;
                }
                throw new IOException("Unable to open sync connection!");
            }
            catch (TimeoutException e) {
                Log.e(LOG_TAG, "Error during Sync: timeout.");
                throw e;
            }
            catch (SyncException e) {
                Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                throw e;
            }
            catch (IOException e) {
                Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                throw e;
            }
            finally {
                if (sync != null) {
                    sync.close();
                }
            }
        }
    }

    @Override
    public void pullFile(String remote, String local) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        block9: {
            SyncService sync = null;
            try {
                String targetFileName = Device.getFileName(remote);
                Log.d(targetFileName, String.format("Downloading %1$s from device '%2$s'", targetFileName, this.getSerialNumber()));
                sync = this.getSyncService();
                if (sync != null) {
                    String message = String.format("Downloading file from device '%1$s'", this.getSerialNumber());
                    Log.d(LOG_TAG, message);
                    sync.pullFile(remote, local, SyncService.getNullProgressMonitor());
                    break block9;
                }
                throw new IOException("Unable to open sync connection!");
            }
            catch (TimeoutException e) {
                Log.e(LOG_TAG, "Error during Sync: timeout.");
                throw e;
            }
            catch (SyncException e) {
                Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                throw e;
            }
            catch (IOException e) {
                Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                throw e;
            }
            finally {
                if (sync != null) {
                    sync.close();
                }
            }
        }
    }

    @Override
    public String installPackage(String packageFilePath, boolean reinstall, String ... extraArgs) throws InstallException {
        try {
            String remoteFilePath = this.syncPackageToDevice(packageFilePath);
            String result = this.installRemotePackage(remoteFilePath, reinstall, extraArgs);
            this.removeRemotePackage(remoteFilePath);
            return result;
        }
        catch (IOException e) {
            throw new InstallException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new InstallException(e);
        }
        catch (TimeoutException e) {
            throw new InstallException(e);
        }
        catch (SyncException e) {
            throw new InstallException(e);
        }
    }

    @Override
    public void installPackages(List<String> apkFilePaths, int timeOut, boolean reinstall, String ... extraArgs) throws InstallException {
        assert (!apkFilePaths.isEmpty());
        if (this.getApiLevel() < 21) {
            throw new InstallException("This multi-apk application requires a device with API level 21+");
        }
        String mainPackageFilePath = apkFilePaths.get(0);
        Log.d(mainPackageFilePath, String.format("Uploading main %1$s and %2$s split APKs onto device '%3$s'", mainPackageFilePath, Joiner.on(',').join(apkFilePaths), this.getSerialNumber()));
        try {
            String sessionId = this.createMultiInstallSession(apkFilePaths, reinstall);
            if (sessionId == null) {
                Log.d(mainPackageFilePath, "Failed to establish session, quit installation");
                throw new InstallException("Failed to establish session");
            }
            Log.d(mainPackageFilePath, String.format("Established session id=%1$s", sessionId));
            int index = 0;
            boolean allUploadSucceeded = true;
            while (allUploadSucceeded && index < apkFilePaths.size()) {
                allUploadSucceeded = this.uploadAPK(sessionId, apkFilePaths.get(index), index++);
            }
            String command = allUploadSucceeded ? "pm install-commit " + sessionId : "pm install-abandon " + sessionId;
            InstallReceiver receiver = new InstallReceiver();
            this.executeShellCommand(command, receiver, timeOut);
            String errorMessage = receiver.getErrorMessage();
            if (errorMessage != null) {
                String message = String.format("Failed to finalize session : %1$s", errorMessage);
                Log.e(mainPackageFilePath, message);
                throw new InstallException(message);
            }
            if (!allUploadSucceeded) {
                throw new InstallException("Unable to upload some APKs");
            }
        }
        catch (TimeoutException e) {
            Log.e(LOG_TAG, "Error during Sync: timeout.");
            throw new InstallException(e);
        }
        catch (IOException e) {
            Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
            throw new InstallException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new InstallException(e);
        }
        catch (ShellCommandUnresponsiveException e) {
            Log.e(LOG_TAG, String.format("Error during shell execution: %1$s", e.getMessage()));
            throw new InstallException(e);
        }
    }

    @Nullable
    private String createMultiInstallSession(List<String> apkFileNames, boolean reinstall) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        List<File> apkFiles = Lists.transform(apkFileNames, new Function<String, File>(){

            @Override
            public File apply(String input) {
                return new File(input);
            }
        });
        long totalFileSize = 0L;
        for (File apkFile : apkFiles) {
            if (apkFile.exists() && apkFile.isFile()) {
                totalFileSize += apkFile.length();
                continue;
            }
            throw new IllegalArgumentException(apkFile.getAbsolutePath() + " is not a file");
        }
        MultiInstallReceiver receiver = new MultiInstallReceiver();
        String cmd = String.format("pm install-create %1$s -S %2$d", reinstall ? "-r" : UNKNOWN_PACKAGE, totalFileSize);
        this.executeShellCommand(cmd, receiver, DdmPreferences.getTimeOut());
        return receiver.getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadAPK(String sessionId, String apkFilePath, int uniqueId) {
        Log.d(sessionId, String.format("Uploading APK %1$s ", apkFilePath));
        File fileToUpload = new File(apkFilePath);
        if (!fileToUpload.exists()) {
            Log.e(sessionId, String.format("File not found: %1$s", apkFilePath));
            return false;
        }
        if (fileToUpload.isDirectory()) {
            Log.e(sessionId, String.format("Directory upload not supported: %1$s", apkFilePath));
            return false;
        }
        String baseName = fileToUpload.getName().lastIndexOf(46) != -1 ? fileToUpload.getName().substring(0, fileToUpload.getName().lastIndexOf(46)) : fileToUpload.getName();
        String command = String.format("pm install-write -S %d %s %d_%s -", fileToUpload.length(), sessionId, uniqueId, baseName);
        Log.d(sessionId, String.format("Executing : %1$s", command));
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(fileToUpload));
            InstallReceiver receiver = new InstallReceiver();
            AdbHelper.executeRemoteCommand(AndroidDebugBridge.getSocketAddress(), AdbHelper.AdbService.EXEC, command, this, receiver, DdmPreferences.getTimeOut(), TimeUnit.MILLISECONDS, inputStream);
            if (receiver.getErrorMessage() != null) {
                Log.e(sessionId, String.format("Error while uploading %1$s : %2$s", fileToUpload.getName(), receiver.getErrorMessage()));
            } else {
                Log.d(sessionId, String.format("Successfully uploaded %1$s", fileToUpload.getName()));
            }
            boolean bl = receiver.getErrorMessage() == null;
            return bl;
        }
        catch (Exception e) {
            Log.e(sessionId, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Log.e(sessionId, e);
                }
            }
        }
    }

    @Override
    public String syncPackageToDevice(String localFilePath) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        SyncService sync = null;
        try {
            String packageFileName = Device.getFileName(localFilePath);
            String remoteFilePath = String.format("/data/local/tmp/%1$s", packageFileName);
            Log.d(packageFileName, String.format("Uploading %1$s onto device '%2$s'", packageFileName, this.getSerialNumber()));
            sync = this.getSyncService();
            if (sync == null) {
                throw new IOException("Unable to open sync connection!");
            }
            String message = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
            Log.d(LOG_TAG, message);
            sync.pushFile(localFilePath, remoteFilePath, SyncService.getNullProgressMonitor());
            String string = remoteFilePath;
            return string;
        }
        catch (TimeoutException e) {
            Log.e(LOG_TAG, "Error during Sync: timeout.");
            throw e;
        }
        catch (SyncException e) {
            Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
            throw e;
        }
        catch (IOException e) {
            Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
            throw e;
        }
        finally {
            if (sync != null) {
                sync.close();
            }
        }
    }

    private static String getFileName(String filePath) {
        return new File(filePath).getName();
    }

    @Override
    public String installRemotePackage(String remoteFilePath, boolean reinstall, String ... extraArgs) throws InstallException {
        try {
            InstallReceiver receiver = new InstallReceiver();
            StringBuilder optionString = new StringBuilder();
            if (reinstall) {
                optionString.append("-r ");
            }
            for (String arg : extraArgs) {
                optionString.append(arg);
                optionString.append(' ');
            }
            String cmd = String.format("pm install %1$s \"%2$s\"", optionString.toString(), remoteFilePath);
            this.executeShellCommand(cmd, receiver, INSTALL_TIMEOUT_MINUTES, TimeUnit.MINUTES);
            return receiver.getErrorMessage();
        }
        catch (TimeoutException e) {
            throw new InstallException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new InstallException(e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new InstallException(e);
        }
        catch (IOException e) {
            throw new InstallException(e);
        }
    }

    @Override
    public void removeRemotePackage(String remoteFilePath) throws InstallException {
        try {
            this.executeShellCommand(String.format("rm \"%1$s\"", remoteFilePath), new NullOutputReceiver(), INSTALL_TIMEOUT_MINUTES, TimeUnit.MINUTES);
        }
        catch (IOException e) {
            throw new InstallException(e);
        }
        catch (TimeoutException e) {
            throw new InstallException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new InstallException(e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new InstallException(e);
        }
    }

    @Override
    public String uninstallPackage(String packageName) throws InstallException {
        try {
            InstallReceiver receiver = new InstallReceiver();
            this.executeShellCommand("pm uninstall " + packageName, receiver, INSTALL_TIMEOUT_MINUTES, TimeUnit.MINUTES);
            return receiver.getErrorMessage();
        }
        catch (TimeoutException e) {
            throw new InstallException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new InstallException(e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new InstallException(e);
        }
        catch (IOException e) {
            throw new InstallException(e);
        }
    }

    @Override
    public void reboot(String into) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.reboot(into, AndroidDebugBridge.getSocketAddress(), this);
    }

    @Override
    public Integer getBatteryLevel() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        return this.getBatteryLevel(300000L);
    }

    @Override
    public Integer getBatteryLevel(long freshnessMs) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        Future<Integer> futureBattery = this.getBattery(freshnessMs, TimeUnit.MILLISECONDS);
        try {
            return futureBattery.get();
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    @NonNull
    public Future<Integer> getBattery() {
        return this.getBattery(5L, TimeUnit.MINUTES);
    }

    @Override
    @NonNull
    public Future<Integer> getBattery(long freshnessTime, @NonNull TimeUnit timeUnit) {
        return this.mBatteryFetcher.getBattery(freshnessTime, timeUnit);
    }

    @Override
    @NonNull
    public List<String> getAbis() {
        String abiList = this.getProperty("ro.product.cpu.abilist");
        if (abiList != null) {
            return Lists.newArrayList(abiList.split(","));
        }
        ArrayList<String> abis = Lists.newArrayListWithExpectedSize(2);
        String abi = this.getProperty("ro.product.cpu.abi");
        if (abi != null) {
            abis.add(abi);
        }
        if ((abi = this.getProperty("ro.product.cpu.abi2")) != null) {
            abis.add(abi);
        }
        return abis;
    }

    @Override
    public int getDensity() {
        String densityValue = this.getProperty("ro.sf.lcd_density");
        if (densityValue != null) {
            return Integer.parseInt(densityValue);
        }
        return 0;
    }

    static {
        String installTimeout = System.getenv("ADB_INSTALL_TIMEOUT");
        long time = 4L;
        if (installTimeout != null) {
            try {
                time = Long.parseLong(installTimeout);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        INSTALL_TIMEOUT_MINUTES = time;
    }

    private static class MultiInstallReceiver
    extends MultiLineReceiver {
        private static final Pattern successPattern = Pattern.compile("Success: .*\\[(\\d*)\\]");
        @Nullable
        String sessionId = null;

        private MultiInstallReceiver() {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void processNewLines(String[] lines) {
            for (String line : lines) {
                Matcher matcher = successPattern.matcher(line);
                if (!matcher.matches()) continue;
                this.sessionId = matcher.group(1);
            }
        }

        @Nullable
        public String getSessionId() {
            return this.sessionId;
        }
    }

    private static final class InstallReceiver
    extends MultiLineReceiver {
        private static final String SUCCESS_OUTPUT = "Success";
        private static final Pattern FAILURE_PATTERN = Pattern.compile("Failure\\s+\\[(.*)\\]");
        private String mErrorMessage = null;

        @Override
        public void processNewLines(String[] lines) {
            for (String line : lines) {
                Matcher m;
                if (line.isEmpty()) continue;
                this.mErrorMessage = line.startsWith(SUCCESS_OUTPUT) ? null : ((m = FAILURE_PATTERN.matcher(line)).matches() ? m.group(1) : "Unknown failure");
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }
    }
}

