/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.utils.ILogger;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildToolInfo {
    private static final String FN_RUNTIME_PROPS = "runtime.properties";
    private static final String PROP_RUNTIME_JVM = "Runtime.Jvm";
    @NonNull
    private final FullRevision mRevision;
    @NonNull
    private final File mPath;
    private final Map<PathId, String> mPaths = Maps.newEnumMap(PathId.class);

    public BuildToolInfo(@NonNull FullRevision revision, @NonNull File path) {
        this.mRevision = revision;
        this.mPath = path;
        this.add(PathId.AAPT, SdkConstants.FN_AAPT);
        this.add(PathId.AIDL, SdkConstants.FN_AIDL);
        this.add(PathId.DX, SdkConstants.FN_DX);
        this.add(PathId.DX_JAR, "lib" + File.separator + "dx.jar");
        this.add(PathId.LLVM_RS_CC, SdkConstants.FN_RENDERSCRIPT);
        this.add(PathId.ANDROID_RS, SdkConstants.OS_FRAMEWORK_RS);
        this.add(PathId.ANDROID_RS_CLANG, SdkConstants.OS_FRAMEWORK_RS_CLANG);
        this.add(PathId.BCC_COMPAT, SdkConstants.FN_BCC_COMPAT);
        this.add(PathId.LD_ARM, SdkConstants.FN_LD_ARM);
        this.add(PathId.LD_X86, SdkConstants.FN_LD_X86);
        this.add(PathId.LD_MIPS, SdkConstants.FN_LD_MIPS);
        this.add(PathId.ZIP_ALIGN, SdkConstants.FN_ZIPALIGN);
        this.add(PathId.JACK, "jack.jar");
        this.add(PathId.JILL, "jill.jar");
    }

    public BuildToolInfo(@NonNull FullRevision revision, @NonNull File mainPath, @NonNull File aapt, @NonNull File aidl, @NonNull File dx, @NonNull File dxJar, @NonNull File llmvRsCc, @NonNull File androidRs, @NonNull File androidRsClang, @Nullable File bccCompat, @Nullable File ldArm, @Nullable File ldX86, @Nullable File ldMips, @NonNull File zipAlign) {
        this.mRevision = revision;
        this.mPath = mainPath;
        this.add(PathId.AAPT, aapt);
        this.add(PathId.AIDL, aidl);
        this.add(PathId.DX, dx);
        this.add(PathId.DX_JAR, dxJar);
        this.add(PathId.LLVM_RS_CC, llmvRsCc);
        this.add(PathId.ANDROID_RS, androidRs);
        this.add(PathId.ANDROID_RS_CLANG, androidRsClang);
        this.add(PathId.ZIP_ALIGN, zipAlign);
        if (bccCompat != null) {
            this.add(PathId.BCC_COMPAT, bccCompat);
        } else if (PathId.BCC_COMPAT.isPresentIn(revision)) {
            throw new IllegalArgumentException("BCC_COMPAT required in " + revision.toString());
        }
        if (ldArm != null) {
            this.add(PathId.LD_ARM, ldArm);
        } else if (PathId.LD_ARM.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_ARM required in " + revision.toString());
        }
        if (ldX86 != null) {
            this.add(PathId.LD_X86, ldX86);
        } else if (PathId.LD_X86.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_X86 required in " + revision.toString());
        }
        if (ldMips != null) {
            this.add(PathId.LD_MIPS, ldMips);
        } else if (PathId.LD_MIPS.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_MIPS required in " + revision.toString());
        }
    }

    private void add(PathId id, String leaf) {
        this.add(id, new File(this.mPath, leaf));
    }

    private void add(PathId id, File path) {
        String str = path.getAbsolutePath();
        if (path.isDirectory() && str.charAt(str.length() - 1) != File.separatorChar) {
            str = str + File.separatorChar;
        }
        this.mPaths.put(id, str);
    }

    @NonNull
    public FullRevision getRevision() {
        return this.mRevision;
    }

    @NonNull
    public File getLocation() {
        return this.mPath;
    }

    public String getPath(PathId pathId) {
        assert (pathId.isPresentIn(this.mRevision));
        return this.mPaths.get((Object)pathId);
    }

    public boolean isValid(@Nullable ILogger log) {
        for (Map.Entry<PathId, String> entry : this.mPaths.entrySet()) {
            File f = new File(entry.getValue());
            if (f.exists() || !entry.getKey().isPresentIn(this.mRevision)) continue;
            if (log != null) {
                log.warning("Build-tool %1$s is missing %2$s at %3$s", new Object[]{this.mRevision.toString(), entry.getKey(), f.getAbsolutePath()});
            }
            return false;
        }
        return true;
    }

    @NonNull
    public Properties getRuntimeProps() {
        FileOp fop = new FileOp();
        return fop.loadProperties(new File(this.mPath, FN_RUNTIME_PROPS));
    }

    public boolean canRunOnJvm() {
        Properties props = this.getRuntimeProps();
        String required = props.getProperty(PROP_RUNTIME_JVM);
        if (required == null) {
            return true;
        }
        try {
            NoPreviewRevision requiredVersion = NoPreviewRevision.parseRevision(required);
            NoPreviewRevision currentVersion = this.getCurrentJvmVersion();
            return currentVersion.compareTo(requiredVersion) >= 0;
        }
        catch (NumberFormatException ignore) {
            return true;
        }
    }

    @Nullable
    protected NoPreviewRevision getCurrentJvmVersion() throws NumberFormatException {
        String javav = System.getProperty("java.version");
        Pattern p = Pattern.compile("((\\d+)(\\.\\d+)?(\\.\\d+)?).*");
        Matcher m = p.matcher(javav);
        if (m.matches()) {
            return NoPreviewRevision.parseRevision(m.group(1));
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<BuildToolInfo rev=").append(this.mRevision);
        builder.append(", mPath=").append(this.mPath);
        builder.append(", mPaths=").append(this.getPathString());
        builder.append(">");
        return builder.toString();
    }

    private String getPathString() {
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<PathId, String> entry : this.mPaths.entrySet()) {
            if (!entry.getKey().isPresentIn(this.mRevision)) continue;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append((Object)entry.getKey()).append('=').append(entry.getValue());
        }
        sb.append('}');
        return sb.toString();
    }

    public static enum PathId {
        AAPT("1.0.0"),
        AIDL("1.0.0"),
        DX("1.0.0"),
        DX_JAR("1.0.0"),
        LLVM_RS_CC("1.0.0"),
        ANDROID_RS("1.0.0"),
        ANDROID_RS_CLANG("1.0.0"),
        BCC_COMPAT("18.1.0"),
        LD_ARM("18.1.0"),
        LD_X86("18.1.0"),
        LD_MIPS("18.1.0"),
        ZIP_ALIGN("19.1.0"),
        JACK("21.1.0"),
        JILL("21.1.0");

        private final FullRevision mMinRevision;

        private PathId(String minRevision) {
            this.mMinRevision = FullRevision.parseRevision(minRevision);
        }

        boolean isPresentIn(@NonNull FullRevision fullRevision) {
            return fullRevision.compareTo(this.mMinRevision) >= 0;
        }
    }
}

