/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.ClassLoadContext;
import com.vladium.util.IClassLoadStrategy;

public abstract class ClassLoaderResolver {
    private static IClassLoadStrategy s_strategy;
    private static final int CALL_CONTEXT_OFFSET = 2;
    private static final CallerResolver CALLER_RESOLVER;

    public static synchronized ClassLoader getClassLoader(Class caller) {
        ClassLoadContext ctx = new ClassLoadContext(caller);
        return s_strategy.getClassLoader(ctx);
    }

    public static synchronized ClassLoader getClassLoader() {
        Class caller = ClassLoaderResolver.getCallerClass(1);
        ClassLoadContext ctx = new ClassLoadContext(caller);
        return s_strategy.getClassLoader(ctx);
    }

    public static Class getCallerClass(int callerOffset) {
        if (CALLER_RESOLVER == null) {
            return null;
        }
        return CALLER_RESOLVER.getClassContext()[2 + callerOffset];
    }

    public static boolean isChild(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 == loader2) {
            return true;
        }
        if (loader2 == null) {
            return false;
        }
        if (loader1 == null) {
            return true;
        }
        while (loader2 != null) {
            if (loader2 == loader1) {
                return true;
            }
            loader2 = loader2.getParent();
        }
        return false;
    }

    public static synchronized IClassLoadStrategy getStrategy() {
        return s_strategy;
    }

    public static synchronized IClassLoadStrategy setStrategy(IClassLoadStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("null input: strategy");
        }
        IClassLoadStrategy old = s_strategy;
        s_strategy = strategy;
        return old;
    }

    private ClassLoaderResolver() {
    }

    static {
        CallerResolver temp = null;
        try {
            temp = new CallerResolver();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CALLER_RESOLVER = temp;
        s_strategy = new DefaultClassLoadStrategy();
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }

    private static final class DefaultClassLoadStrategy
    implements IClassLoadStrategy {
        private DefaultClassLoadStrategy() {
        }

        @Override
        public ClassLoader getClassLoader(ClassLoadContext ctx) {
            ClassLoader systemLoader;
            ClassLoader callerLoader;
            if (ctx == null) {
                throw new IllegalArgumentException("null input: ctx");
            }
            Class caller = ctx.getCallerClass();
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader result = caller == null ? contextLoader : (ClassLoaderResolver.isChild(callerLoader = caller.getClassLoader(), contextLoader) ? contextLoader : callerLoader);
            if (ClassLoaderResolver.isChild(result, systemLoader = ClassLoader.getSystemClassLoader())) {
                result = systemLoader;
            }
            return result;
        }
    }
}

