/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.ByteArrayIStream;
import java.io.IOException;
import java.io.OutputStream;

public final class ByteArrayOStream
extends OutputStream {
    private byte[] m_buf;
    private int m_pos;
    private static final int NATIVE_COPY_THRESHOLD = 9;

    public ByteArrayOStream(int initialCapacity) {
        this.m_buf = new byte[initialCapacity];
    }

    public final ByteArrayIStream toByteIStream() {
        return new ByteArrayIStream(this.m_buf, this.m_pos);
    }

    public final void write2(int b1, int b2) {
        byte[] mbuf = this.m_buf;
        int mbuflen = mbuf.length;
        int pos = this.m_pos;
        int capacity = pos + 2;
        if (mbuflen < capacity) {
            byte[] newbuf = new byte[Math.max(mbuflen << 1, capacity)];
            if (pos < 9) {
                for (int i = 0; i < pos; ++i) {
                    newbuf[i] = mbuf[i];
                }
            } else {
                System.arraycopy(mbuf, 0, newbuf, 0, pos);
            }
            mbuf = newbuf;
            this.m_buf = newbuf;
        }
        mbuf[pos] = (byte)b1;
        mbuf[pos + 1] = (byte)b2;
        this.m_pos = capacity;
    }

    public final void write3(int b1, int b2, int b3) {
        byte[] mbuf = this.m_buf;
        int mbuflen = mbuf.length;
        int pos = this.m_pos;
        int capacity = pos + 3;
        if (mbuflen < capacity) {
            byte[] newbuf = new byte[Math.max(mbuflen << 1, capacity)];
            if (pos < 9) {
                for (int i = 0; i < pos; ++i) {
                    newbuf[i] = mbuf[i];
                }
            } else {
                System.arraycopy(mbuf, 0, newbuf, 0, pos);
            }
            mbuf = newbuf;
            this.m_buf = newbuf;
        }
        mbuf[pos] = (byte)b1;
        mbuf[pos + 1] = (byte)b2;
        mbuf[pos + 2] = (byte)b3;
        this.m_pos = capacity;
    }

    public final void write4(int b1, int b2, int b3, int b4) {
        byte[] mbuf = this.m_buf;
        int mbuflen = mbuf.length;
        int pos = this.m_pos;
        int capacity = pos + 4;
        if (mbuflen < capacity) {
            byte[] newbuf = new byte[Math.max(mbuflen << 1, capacity)];
            if (pos < 9) {
                for (int i = 0; i < pos; ++i) {
                    newbuf[i] = mbuf[i];
                }
            } else {
                System.arraycopy(mbuf, 0, newbuf, 0, pos);
            }
            mbuf = newbuf;
            this.m_buf = newbuf;
        }
        mbuf[pos] = (byte)b1;
        mbuf[pos + 1] = (byte)b2;
        mbuf[pos + 2] = (byte)b3;
        mbuf[pos + 3] = (byte)b4;
        this.m_pos = capacity;
    }

    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.m_buf, 0, this.m_pos);
    }

    public final byte[] getByteArray() {
        return this.m_buf;
    }

    public final byte[] copyByteArray() {
        int pos = this.m_pos;
        byte[] result = new byte[pos];
        byte[] mbuf = this.m_buf;
        if (pos < 9) {
            for (int i = 0; i < pos; ++i) {
                result[i] = mbuf[i];
            }
        } else {
            System.arraycopy(mbuf, 0, result, 0, pos);
        }
        return result;
    }

    public final int size() {
        return this.m_pos;
    }

    public final int capacity() {
        return this.m_buf.length;
    }

    public final void reset() {
        this.m_pos = 0;
    }

    @Override
    public final void write(int b) {
        byte[] mbuf = this.m_buf;
        int mbuflen = mbuf.length;
        int pos = this.m_pos;
        int capacity = pos + 1;
        if (mbuflen < capacity) {
            byte[] newbuf = new byte[Math.max(mbuflen << 1, capacity)];
            if (pos < 9) {
                for (int i = 0; i < pos; ++i) {
                    newbuf[i] = mbuf[i];
                }
            } else {
                System.arraycopy(mbuf, 0, newbuf, 0, pos);
            }
            mbuf = newbuf;
            this.m_buf = newbuf;
        }
        mbuf[pos] = (byte)b;
        this.m_pos = capacity;
    }

    @Override
    public final void write(byte[] buf, int offset, int length) {
        byte[] mbuf = this.m_buf;
        int mbuflen = mbuf.length;
        int pos = this.m_pos;
        int capacity = pos + length;
        if (mbuflen < capacity) {
            byte[] newbuf = new byte[Math.max(mbuflen << 1, capacity)];
            if (pos < 9) {
                for (int i = 0; i < pos; ++i) {
                    newbuf[i] = mbuf[i];
                }
            } else {
                System.arraycopy(mbuf, 0, newbuf, 0, pos);
            }
            mbuf = newbuf;
            this.m_buf = newbuf;
        }
        if (length < 9) {
            for (int i = 0; i < length; ++i) {
                mbuf[pos + i] = buf[offset + i];
            }
        } else {
            System.arraycopy(buf, offset, mbuf, pos, length);
        }
        this.m_pos = capacity;
    }

    @Override
    public final void close() {
        this.reset();
    }
}

