/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.IDeclaredExceptionTable;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.IntVector;
import java.io.IOException;

final class DeclaredExceptionTable
implements IDeclaredExceptionTable {
    private IntVector m_exceptions;

    @Override
    public int get(int offset) {
        return this.m_exceptions.get(offset);
    }

    @Override
    public int size() {
        return this.m_exceptions.size();
    }

    @Override
    public long length() {
        return 1 + this.m_exceptions.size() << 1;
    }

    @Override
    public Object clone() {
        try {
            DeclaredExceptionTable _clone = (DeclaredExceptionTable)super.clone();
            _clone.m_exceptions = (IntVector)this.m_exceptions.clone();
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        int number_of_exceptions = this.m_exceptions.size();
        out.writeU2(number_of_exceptions);
        for (int i = 0; i < number_of_exceptions; ++i) {
            out.writeU2(this.get(i));
        }
    }

    @Override
    public int add(int exception_index) {
        int newoffset = this.m_exceptions.size();
        this.m_exceptions.add(exception_index);
        return newoffset;
    }

    @Override
    public int set(int offset, int exception_index) {
        return this.m_exceptions.set(offset, exception_index);
    }

    DeclaredExceptionTable(int capacity) {
        this.m_exceptions = capacity < 0 ? new IntVector() : new IntVector(capacity);
    }
}

