/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IMethodCollection;
import com.vladium.jcd.cls.Method_info;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.IntVector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class MethodCollection
implements IMethodCollection {
    private List m_methods;

    @Override
    public Method_info get(int offset) {
        return (Method_info)this.m_methods.get(offset);
    }

    @Override
    public int[] get(ClassDef cls, String name) {
        if (cls == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        int count = this.m_methods.size();
        IntVector result = new IntVector(count);
        for (int m = 0; m < count; ++m) {
            Method_info method = (Method_info)this.m_methods.get(m);
            if (!method.getName(cls).equals(name)) continue;
            result.add(m);
        }
        return result.values();
    }

    @Override
    public int size() {
        return this.m_methods.size();
    }

    @Override
    public Object clone() {
        try {
            MethodCollection _clone = (MethodCollection)super.clone();
            int methods_count = this.m_methods.size();
            _clone.m_methods = new ArrayList(methods_count);
            for (int m = 0; m < methods_count; ++m) {
                _clone.m_methods.add(((Method_info)this.m_methods.get(m)).clone());
            }
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        int methods_count = this.m_methods.size();
        out.writeU2(methods_count);
        for (int i = 0; i < methods_count; ++i) {
            this.get(i).writeInClassFormat(out);
        }
    }

    @Override
    public void accept(IClassDefVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    @Override
    public int add(Method_info method) {
        int newoffset = this.m_methods.size();
        this.m_methods.add(method);
        return newoffset;
    }

    @Override
    public Method_info set(int offset, Method_info method) {
        return this.m_methods.set(offset, method);
    }

    @Override
    public Method_info remove(int offset) {
        return (Method_info)this.m_methods.remove(offset);
    }

    MethodCollection(int capacity) {
        this.m_methods = capacity < 0 ? new ArrayList() : new ArrayList(capacity);
    }
}

