/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.ElementFactory;
import com.vladium.jcd.cls.Field_info;
import com.vladium.jcd.cls.IAccessFlags;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.IFieldCollection;
import com.vladium.jcd.cls.IInterfaceCollection;
import com.vladium.jcd.cls.IMethodCollection;
import com.vladium.jcd.cls.Method_info;
import com.vladium.jcd.cls.attribute.AttributeElementFactory;
import com.vladium.jcd.cls.attribute.CodeAttribute_info;
import com.vladium.jcd.cls.attribute.InnerClassesAttribute_info;
import com.vladium.jcd.cls.constant.CONSTANT_Class_info;
import com.vladium.jcd.cls.constant.CONSTANT_Fieldref_info;
import com.vladium.jcd.cls.constant.CONSTANT_NameAndType_info;
import com.vladium.jcd.cls.constant.CONSTANT_String_info;
import com.vladium.jcd.cls.constant.CONSTANT_Utf8_info;
import com.vladium.jcd.compiler.IClassFormatOutput;
import com.vladium.jcd.lib.Types;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.ByteArrayOStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class ClassDef
implements Cloneable,
IAccessFlags,
IClassFormatOutput {
    private long m_magic;
    private int[] m_version = new int[2];
    private int m_access_flags;
    private int m_this_class_index;
    private int m_super_class_index;
    private IConstantCollection m_constants = ElementFactory.newConstantCollection(-1);
    private IInterfaceCollection m_interfaces = ElementFactory.newInterfaceCollection(-1);
    private IFieldCollection m_fields = ElementFactory.newFieldCollection(-1);
    private IMethodCollection m_methods = ElementFactory.newMethodCollection(-1);
    private IAttributeCollection m_attributes = ElementFactory.newAttributeCollection(-1);
    private long m_declaredSUID;
    private static final boolean DEBUG_SUID = false;

    public void accept(IClassDefVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    public long getMagic() {
        return this.m_magic;
    }

    public void setMagic(long magic) {
        this.m_magic = magic;
    }

    public int[] getVersion() {
        return this.m_version;
    }

    public void setVersion(int[] version) {
        this.m_version[0] = version[0];
        this.m_version[1] = version[1];
    }

    public final void setDeclaredSUID(long suid) {
        this.m_declaredSUID = suid;
    }

    public int getThisClassIndex() {
        return this.m_this_class_index;
    }

    public void setThisClassIndex(int this_class_index) {
        this.m_this_class_index = this_class_index;
    }

    public CONSTANT_Class_info getThisClass() {
        return (CONSTANT_Class_info)this.m_constants.get(this.m_this_class_index);
    }

    public CONSTANT_Class_info getSuperClass() {
        return (CONSTANT_Class_info)this.m_constants.get(this.m_super_class_index);
    }

    public String getName() {
        return this.getThisClass().getName(this);
    }

    public int getSuperClassIndex() {
        return this.m_super_class_index;
    }

    public void setSuperClassIndex(int super_class_index) {
        this.m_super_class_index = super_class_index;
    }

    @Override
    public final int getAccessFlags() {
        return this.m_access_flags;
    }

    @Override
    public final void setAccessFlags(int flags) {
        this.m_access_flags = flags;
    }

    public boolean isInterface() {
        return (this.m_access_flags & 0x200) != 0;
    }

    public boolean isSynthetic() {
        return this.m_attributes.hasSynthetic();
    }

    public boolean isNested(int[] nestedAccessFlags) {
        InnerClassesAttribute_info innerClassesAttribute = this.m_attributes.getInnerClassesAttribute();
        if (innerClassesAttribute == null) {
            return false;
        }
        return innerClassesAttribute.makesClassNested(this.m_this_class_index, nestedAccessFlags);
    }

    public IConstantCollection getConstants() {
        return this.m_constants;
    }

    public IInterfaceCollection getInterfaces() {
        return this.m_interfaces;
    }

    public IFieldCollection getFields() {
        return this.m_fields;
    }

    public IMethodCollection getMethods() {
        return this.m_methods;
    }

    public IAttributeCollection getAttributes() {
        return this.m_attributes;
    }

    public int[] getFields(String name) {
        return this.m_fields.get(this, name);
    }

    public int[] getMethods(String name) {
        return this.m_methods.get(this, name);
    }

    public Object clone() {
        try {
            ClassDef _clone = (ClassDef)super.clone();
            _clone.m_version = (int[])this.m_version.clone();
            _clone.m_constants = (IConstantCollection)this.m_constants.clone();
            _clone.m_interfaces = (IInterfaceCollection)this.m_interfaces.clone();
            _clone.m_fields = (IFieldCollection)this.m_fields.clone();
            _clone.m_methods = (IMethodCollection)this.m_methods.clone();
            _clone.m_attributes = (IAttributeCollection)this.m_attributes.clone();
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    @Override
    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("null input: out");
        }
        out.writeU4(this.m_magic);
        out.writeU2(this.m_version[1]);
        out.writeU2(this.m_version[0]);
        this.m_constants.writeInClassFormat(out);
        out.writeU2(this.m_access_flags);
        out.writeU2(this.m_this_class_index);
        out.writeU2(this.m_super_class_index);
        this.m_interfaces.writeInClassFormat(out);
        this.m_fields.writeInClassFormat(out);
        this.m_methods.writeInClassFormat(out);
        this.m_attributes.writeInClassFormat(out);
    }

    public final long getDeclaredSUID() {
        return this.m_declaredSUID;
    }

    public final long computeSUID(boolean skipCLINIT) {
        long result = this.m_declaredSUID;
        if (result != 0L) {
            return result;
        }
        try {
            int i;
            int i2;
            ByteArrayOStream bout = new ByteArrayOStream(1024);
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(Types.vmNameToJavaName(this.getName()));
            int[] nestedAccessFlags = new int[1];
            int modifiers = (this.isNested(nestedAccessFlags) ? nestedAccessFlags[0] : this.getAccessFlags()) & 0x611;
            dout.writeInt(modifiers);
            IInterfaceCollection interfaces = this.getInterfaces();
            Object[] ifcs = new String[interfaces.size()];
            int iLimit = ifcs.length;
            for (i2 = 0; i2 < iLimit; ++i2) {
                ifcs[i2] = Types.vmNameToJavaName(((CONSTANT_Class_info)this.m_constants.get(interfaces.get(i2))).getName(this));
            }
            Arrays.sort(ifcs);
            for (i2 = 0; i2 < iLimit; ++i2) {
                dout.writeUTF((String)ifcs[i2]);
            }
            IFieldCollection fields = this.getFields();
            Object[] fds = new FieldDescriptor[fields.size()];
            int fcount = 0;
            int fLimit = fds.length;
            for (int f = 0; f < fLimit; ++f) {
                Field_info field = fields.get(f);
                int modifiers2 = field.getAccessFlags();
                if ((modifiers2 & 2) != 0 && (modifiers2 & 0x88) != 0) continue;
                fds[fcount++] = new FieldDescriptor(field.getName(this), modifiers2, field.getDescriptor(this));
            }
            if (fcount > 0) {
                Arrays.sort(fds, 0, fcount);
                for (i2 = 0; i2 < fcount; ++i2) {
                    Object fd = fds[i2];
                    dout.writeUTF(((FieldDescriptor)fd).m_name);
                    dout.writeInt(((FieldDescriptor)fd).m_modifiers);
                    dout.writeUTF(((FieldDescriptor)fd).m_descriptor);
                }
            }
            IMethodCollection methods = this.getMethods();
            boolean hasCLINIT = false;
            Object[] cds = new ConstructorDescriptor[methods.size()];
            Object[] mds = new MethodDescriptor[cds.length];
            int ccount = 0;
            int mcount = 0;
            int iLimit2 = cds.length;
            for (i = 0; i < iLimit2; ++i) {
                Method_info method = methods.get(i);
                String name = method.getName(this);
                if (!hasCLINIT && "<clinit>".equals(name)) {
                    hasCLINIT = true;
                    continue;
                }
                int modifiers3 = method.getAccessFlags();
                if ((modifiers3 & 2) != 0) continue;
                if ("<init>".equals(name)) {
                    cds[ccount++] = new ConstructorDescriptor(modifiers3, method.getDescriptor(this));
                    continue;
                }
                mds[mcount++] = new MethodDescriptor(name, modifiers3, method.getDescriptor(this));
            }
            if (hasCLINIT && !skipCLINIT) {
                dout.writeUTF("<clinit>");
                dout.writeInt(8);
                dout.writeUTF("()V");
            }
            if (ccount > 0) {
                Arrays.sort(cds, 0, ccount);
                for (i = 0; i < ccount; ++i) {
                    Object cd = cds[i];
                    dout.writeUTF("<init>");
                    dout.writeInt(((ConstructorDescriptor)cd).m_modifiers);
                    dout.writeUTF(((ConstructorDescriptor)cd).m_descriptor.replace('/', '.'));
                }
            }
            if (mcount > 0) {
                Arrays.sort(mds, 0, mcount);
                for (i = 0; i < mcount; ++i) {
                    Object md = mds[i];
                    dout.writeUTF(((MethodDescriptor)md).m_name);
                    dout.writeInt(((MethodDescriptor)md).m_modifiers);
                    dout.writeUTF(((MethodDescriptor)md).m_descriptor.replace('/', '.'));
                }
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(bout.getByteArray(), 0, bout.size());
            byte[] hash = md.digest();
            for (int i3 = Math.min(hash.length, 8) - 1; i3 >= 0; --i3) {
                result = result << 8 | (long)(hash[i3] & 0xFF);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new Error(ioe.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SecurityException(nsae.getMessage());
        }
    }

    public int addCONSTANT_Utf8(String value, boolean keepUnique) {
        int existing;
        if (keepUnique && (existing = this.m_constants.findCONSTANT_Utf8(value)) > 0) {
            return existing;
        }
        return this.m_constants.add(new CONSTANT_Utf8_info(value));
    }

    public int addStringConstant(String value) {
        int value_index = this.addCONSTANT_Utf8(value, true);
        return this.m_constants.add(new CONSTANT_String_info(value_index));
    }

    public int addNameType(String name, String typeDescriptor) {
        int name_index = this.addCONSTANT_Utf8(name, true);
        int descriptor_index = this.addCONSTANT_Utf8(typeDescriptor, true);
        return this.m_constants.add(new CONSTANT_NameAndType_info(name_index, descriptor_index));
    }

    public int addClassref(String classJVMName) {
        int name_index = this.addCONSTANT_Utf8(classJVMName, true);
        return this.m_constants.add(new CONSTANT_Class_info(name_index));
    }

    public int addField(String name, String descriptor, int access_flags) {
        int name_index = this.addCONSTANT_Utf8(name, true);
        int descriptor_index = this.addCONSTANT_Utf8(descriptor, true);
        Field_info field = new Field_info(access_flags, name_index, descriptor_index, ElementFactory.newAttributeCollection(0));
        return this.m_fields.add(field);
    }

    public int addField(String name, String descriptor, int access_flags, IAttributeCollection attributes) {
        int name_index = this.addCONSTANT_Utf8(name, true);
        int descriptor_index = this.addCONSTANT_Utf8(descriptor, true);
        Field_info field = new Field_info(access_flags, name_index, descriptor_index, attributes);
        return this.m_fields.add(field);
    }

    public Method_info newEmptyMethod(String name, String descriptor, int access_flags) {
        int attribute_name_index = this.addCONSTANT_Utf8("Code", true);
        int name_index = this.addCONSTANT_Utf8(name, true);
        int descriptor_index = this.addCONSTANT_Utf8(descriptor, true);
        IAttributeCollection attributes = ElementFactory.newAttributeCollection(0);
        CodeAttribute_info code = new CodeAttribute_info(attribute_name_index, 0, 0, CodeAttribute_info.EMPTY_BYTE_ARRAY, AttributeElementFactory.newExceptionHandlerTable(0), ElementFactory.newAttributeCollection(0));
        attributes.add(code);
        Method_info method = new Method_info(access_flags, name_index, descriptor_index, attributes);
        return method;
    }

    public int addMethod(Method_info method) {
        return this.m_methods.add(method);
    }

    public int addFieldref(Field_info field) {
        CONSTANT_NameAndType_info nametype = new CONSTANT_NameAndType_info(field.m_name_index, field.m_descriptor_index);
        int nametype_index = this.m_constants.add(nametype);
        return this.m_constants.add(new CONSTANT_Fieldref_info(this.m_this_class_index, nametype_index));
    }

    public int addFieldref(int offset) {
        Field_info field = this.m_fields.get(offset);
        CONSTANT_NameAndType_info nametype = new CONSTANT_NameAndType_info(field.m_name_index, field.m_descriptor_index);
        int nametype_index = this.m_constants.add(nametype);
        return this.m_constants.add(new CONSTANT_Fieldref_info(this.m_this_class_index, nametype_index));
    }

    private static final class MethodDescriptor
    implements Comparable {
        final String m_name;
        final int m_modifiers;
        final String m_descriptor;

        public final int compareTo(Object obj) {
            MethodDescriptor rhs = (MethodDescriptor)obj;
            int result = this.m_name.compareTo(rhs.m_name);
            if (result == 0) {
                result = this.m_descriptor.compareTo(rhs.m_descriptor);
            }
            return result;
        }

        MethodDescriptor(String name, int modifiers, String descriptor) {
            this.m_name = name;
            this.m_modifiers = modifiers;
            this.m_descriptor = descriptor;
        }
    }

    private static final class ConstructorDescriptor
    implements Comparable {
        final int m_modifiers;
        final String m_descriptor;

        public final int compareTo(Object obj) {
            return this.m_descriptor.compareTo(((ConstructorDescriptor)obj).m_descriptor);
        }

        ConstructorDescriptor(int modifiers, String descriptor) {
            this.m_modifiers = modifiers;
            this.m_descriptor = descriptor;
        }
    }

    private static final class FieldDescriptor
    implements Comparable {
        final String m_name;
        final int m_modifiers;
        final String m_descriptor;

        public final int compareTo(Object obj) {
            return this.m_name.compareTo(((FieldDescriptor)obj).m_name);
        }

        FieldDescriptor(String name, int modifiers, String descriptor) {
            this.m_name = name;
            this.m_modifiers = modifiers;
            this.m_descriptor = descriptor;
        }
    }
}

