/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.instr.InstrVisitor;
import com.vladium.emma.rt.IClassLoadHook;
import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.compiler.ClassWriter;
import com.vladium.jcd.parser.ClassDefParser;
import com.vladium.util.ByteArrayOStream;
import com.vladium.util.Descriptors;
import java.io.IOException;

public final class InstrClassLoadHook
implements IClassLoadHook {
    private final IInclExclFilter m_filter;
    private final IMetaData m_metadata;
    private final InstrVisitor m_classDefProcessor;
    private final InstrVisitor.InstrResult m_instrResult;

    public InstrClassLoadHook(IInclExclFilter filter, IMetaData mdata) {
        if (mdata == null) {
            throw new IllegalArgumentException("null input: mdata");
        }
        this.m_filter = filter;
        this.m_metadata = mdata;
        CoverageOptions options = mdata.getOptions();
        this.m_classDefProcessor = new InstrVisitor(options);
        this.m_instrResult = new InstrVisitor.InstrResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processClassDef(String className, byte[] bytes, int length, ByteArrayOStream out) throws IOException {
        IInclExclFilter filter = this.m_filter;
        if (filter == null || filter.included(className)) {
            boolean metadataExists;
            Object lock;
            ClassDef clsDef = ClassDefParser.parseClass(bytes, length);
            String classVMName = Descriptors.javaNameToVMName(className);
            Object object = lock = this.m_metadata.lock();
            synchronized (object) {
                metadataExists = this.m_metadata.hasDescriptor(classVMName);
            }
            this.m_classDefProcessor.process(clsDef, false, true, !metadataExists, this.m_instrResult);
            boolean useOurs = this.m_instrResult.m_instrumented;
            if (this.m_instrResult.m_descriptor != null) {
                Object object2 = lock;
                synchronized (object2) {
                    if (!this.m_metadata.add(this.m_instrResult.m_descriptor, false)) {
                        useOurs = false;
                    }
                }
            }
            if (useOurs) {
                ClassWriter.writeClassTable(clsDef, out);
                return true;
            }
        }
        return false;
    }
}

