/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.filter;

import com.vladium.util.WCMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public interface IInclExclFilter {
    public static final char INCLUSION_PREFIX = '+';
    public static final String INCLUSION_PREFIX_STRING = "+";
    public static final char EXCLUSION_PREFIX = '-';
    public static final String EXCLUSION_PREFIX_STRING = "-";

    public boolean included(String var1);

    public static abstract class Factory {
        public static IInclExclFilter create(String specs1, String separators, String[] specs2) {
            if (specs1 == null || specs1.trim().length() == 0) {
                return Factory.create(specs2);
            }
            ArrayList<String> _specs = new ArrayList<String>();
            if (specs2 != null) {
                for (int s = 0; s < specs2.length; ++s) {
                    _specs.add(specs2[s]);
                }
            }
            StringTokenizer tokenizer = new StringTokenizer(specs1, separators);
            while (tokenizer.hasMoreTokens()) {
                _specs.add(tokenizer.nextToken());
            }
            String[] specs = new String[_specs.size()];
            _specs.toArray(specs);
            return Factory.create(specs);
        }

        public static IInclExclFilter create(String[] specs) {
            if (specs == null || specs.length == 0) {
                return new WCInclExclFilter((String[])null, (String[])null);
            }
            ArrayList<String> inclusions = new ArrayList<String>();
            ArrayList<String> exclusions = new ArrayList<String>();
            for (String spec : specs) {
                if (spec.length() <= 0) continue;
                if (spec.charAt(0) == '-') {
                    exclusions.add(spec.substring(1));
                    continue;
                }
                if (spec.charAt(0) == '+') {
                    inclusions.add(spec.substring(1));
                    continue;
                }
                inclusions.add(spec);
            }
            return new WCInclExclFilter(inclusions, exclusions);
        }

        public static IInclExclFilter create(String[] inclusions, String[] exclusions) {
            return new WCInclExclFilter(inclusions, exclusions);
        }

        public static IInclExclFilter create(List inclusions, List exclusions) {
            return new WCInclExclFilter(inclusions, exclusions);
        }

        private static final class WCInclExclFilter
        implements IInclExclFilter {
            private final WCMatcher[] m_inclusions;
            private final WCMatcher[] m_exclusions;

            @Override
            public boolean included(String s) {
                if (s == null) {
                    return false;
                }
                char[] chars = s.toCharArray();
                WCMatcher[] inclusions = this.m_inclusions;
                WCMatcher[] exclusions = this.m_exclusions;
                if (inclusions != null) {
                    boolean included = false;
                    int iLimit = inclusions.length;
                    for (int i = 0; i < iLimit; ++i) {
                        if (!inclusions[i].matches(chars)) continue;
                        included = true;
                        break;
                    }
                    if (!included) {
                        return false;
                    }
                }
                if (exclusions != null) {
                    int xLimit = exclusions.length;
                    for (int x = 0; x < xLimit; ++x) {
                        if (!exclusions[x].matches(chars)) continue;
                        return false;
                    }
                }
                return true;
            }

            WCInclExclFilter(String[] inclusions, String[] exclusions) {
                int i;
                if (inclusions == null || inclusions.length == 0) {
                    this.m_inclusions = null;
                } else {
                    this.m_inclusions = new WCMatcher[inclusions.length];
                    for (i = 0; i < inclusions.length; ++i) {
                        this.m_inclusions[i] = WCMatcher.compile(inclusions[i]);
                    }
                }
                if (exclusions == null || exclusions.length == 0) {
                    this.m_exclusions = null;
                } else {
                    this.m_exclusions = new WCMatcher[exclusions.length];
                    for (i = 0; i < exclusions.length; ++i) {
                        this.m_exclusions[i] = WCMatcher.compile(exclusions[i]);
                    }
                }
            }

            WCInclExclFilter(List inclusions, List exclusions) {
                int ii;
                if (inclusions == null || inclusions.isEmpty()) {
                    this.m_inclusions = null;
                } else {
                    this.m_inclusions = new WCMatcher[inclusions.size()];
                    ii = 0;
                    for (String pattern : inclusions) {
                        this.m_inclusions[ii] = WCMatcher.compile(pattern);
                        ++ii;
                    }
                }
                if (exclusions == null || exclusions.isEmpty()) {
                    this.m_exclusions = null;
                } else {
                    this.m_exclusions = new WCMatcher[exclusions.size()];
                    ii = 0;
                    for (String pattern : exclusions) {
                        this.m_exclusions[ii] = WCMatcher.compile(pattern);
                        ++ii;
                    }
                }
            }
        }
    }
}

