/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.logging.Logger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

final class MetaData
implements IMetaData,
Cloneable {
    private final CoverageOptions m_options;
    private boolean m_hasSrcFileInfo;
    private boolean m_hasLineNumberInfo;
    private HashMap m_classMap;
    private transient HashSet m_packagesWarned;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMetaData shallowCopy() {
        HashMap _classMap;
        MetaData _clone;
        try {
            _clone = (MetaData)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error(cnse.toString());
        }
        Object object = this.lock();
        synchronized (object) {
            _classMap = (HashMap)this.m_classMap.clone();
        }
        _clone.m_classMap = _classMap;
        return _clone;
    }

    @Override
    public CoverageOptions getOptions() {
        return this.m_options;
    }

    @Override
    public int size() {
        return this.m_classMap.size();
    }

    @Override
    public boolean hasSrcFileData() {
        return this.m_hasSrcFileInfo;
    }

    @Override
    public boolean hasLineNumberData() {
        return this.m_hasLineNumberInfo;
    }

    @Override
    public Iterator iterator() {
        return this.m_classMap.values().iterator();
    }

    @Override
    public boolean hasDescriptor(String classVMName) {
        return this.m_classMap.containsKey(classVMName);
    }

    @Override
    public Object lock() {
        return this.m_classMap;
    }

    @Override
    public boolean add(ClassDescriptor cls, boolean overwrite) {
        String classVMName = cls.getClassVMName();
        if (overwrite || !this.m_classMap.containsKey(classVMName)) {
            String packageVMName;
            Logger log;
            this.m_classMap.put(classVMName, cls);
            boolean incompleteDebugInfo = false;
            if (!cls.hasSrcFileInfo()) {
                this.m_hasSrcFileInfo = false;
                incompleteDebugInfo = true;
            }
            if (!cls.hasCompleteLineNumberInfo()) {
                this.m_hasLineNumberInfo = false;
                incompleteDebugInfo = true;
            }
            if (incompleteDebugInfo && (log = Logger.getLogger()).atINFO() && this.m_packagesWarned.add(packageVMName = cls.getPackageVMName())) {
                log.info("package [" + packageVMName + "] contains classes [" + cls.getName() + "] without full debug info");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.m_classMap.isEmpty();
    }

    @Override
    public IMergeable merge(IMergeable rhs) {
        if (rhs == null || rhs.isEmpty() || rhs == this) {
            return this;
        }
        MetaData rhsmdata = (MetaData)rhs;
        HashMap rhsclasses = rhsmdata.m_classMap;
        for (Map.Entry entry : rhsclasses.entrySet()) {
            String classVMName = (String)entry.getKey();
            Object rhsdescriptor = entry.getValue();
            this.m_classMap.put(classVMName, rhsdescriptor);
        }
        if (!rhsmdata.hasSrcFileData()) {
            this.m_hasSrcFileInfo = false;
        }
        if (!rhsmdata.hasLineNumberData()) {
            this.m_hasLineNumberInfo = false;
        }
        return this;
    }

    MetaData(CoverageOptions options) {
        this.m_options = options;
        this.m_hasSrcFileInfo = true;
        this.m_hasLineNumberInfo = true;
        this.m_classMap = new HashMap();
        this.m_packagesWarned = new HashSet();
    }

    static MetaData readExternal(DataInput in) throws IOException {
        CoverageOptions options = CoverageOptions.readExternal(in);
        boolean hasSrcFileInfo = in.readBoolean();
        boolean hasLineNumberInfo = in.readBoolean();
        int size = in.readInt();
        HashMap<String, ClassDescriptor> classMap = new HashMap<String, ClassDescriptor>(size);
        for (int i = 0; i < size; ++i) {
            String classVMName = in.readUTF();
            ClassDescriptor cls = ClassDescriptor.readExternal(in);
            classMap.put(classVMName, cls);
        }
        return new MetaData(options, classMap, hasSrcFileInfo, hasLineNumberInfo);
    }

    static void writeExternal(MetaData mdata, DataOutput out) throws IOException {
        CoverageOptions.writeExternal(mdata.m_options, out);
        out.writeBoolean(mdata.m_hasSrcFileInfo);
        out.writeBoolean(mdata.m_hasLineNumberInfo);
        HashMap classMap = mdata.m_classMap;
        int size = classMap.size();
        out.writeInt(size);
        Iterator entries = classMap.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = entries.next();
            String classVMName = (String)entry.getKey();
            ClassDescriptor cls = (ClassDescriptor)entry.getValue();
            out.writeUTF(classVMName);
            ClassDescriptor.writeExternal(cls, out);
        }
    }

    private MetaData(CoverageOptions options, HashMap classMap, boolean hasSrcFileInfo, boolean hasLineNumberInfo) {
        this.m_options = options;
        this.m_hasSrcFileInfo = hasSrcFileInfo;
        this.m_hasLineNumberInfo = hasLineNumberInfo;
        this.m_classMap = classMap;
    }
}

