/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.Processor;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.SessionData;
import com.vladium.logging.Logger;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.asserts.$assert;
import com.vladium.util.exception.Exceptions;
import java.io.File;
import java.io.IOException;

public final class MergeProcessor
extends Processor
implements IAppErrorCodes {
    private File[] m_dataPath = IConstants.EMPTY_FILE_ARRAY;
    private File m_sdataOutFile;
    private int m_dataFileCount;
    private static final Class[] EXPECTED_FAILURES = new Class[]{EMMARuntimeException.class, IllegalArgumentException.class, IllegalStateException.class};

    public static MergeProcessor create() {
        return new MergeProcessor();
    }

    public final synchronized void setDataPath(String[] path) {
        this.m_dataPath = path == null || path.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(path, true);
    }

    public final synchronized void setSessionOutFile(String fileName) {
        if (fileName == null) {
            this.m_sdataOutFile = null;
        } else {
            File _file = new File(fileName);
            if (_file.exists() && !_file.isFile()) {
                throw new IllegalArgumentException("not a file: [" + _file.getAbsolutePath() + "]");
            }
            this.m_sdataOutFile = _file;
        }
    }

    @Override
    protected void validateState() {
        super.validateState();
        if (this.m_dataPath == null) {
            throw new IllegalStateException("data path not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _run(IProperties toolProperties) {
        Logger log = this.m_log;
        boolean verbose = this.m_log.atVERBOSE();
        if (verbose) {
            log.verbose("[EMMA v0.0, build 0 (unsupported private build) (unknown)]");
            log.verbose("input data path:");
            log.verbose("{");
            for (int p = 0; p < this.m_dataPath.length; ++p) {
                File f = this.m_dataPath[p];
                String nonexistent = f.exists() ? "" : "{nonexistent} ";
                log.verbose("  " + nonexistent + f.getAbsolutePath());
            }
            log.verbose("}");
        } else {
            log.info("processing input files ...");
        }
        File sdataOutFile = this.m_sdataOutFile;
        if (sdataOutFile == null) {
            sdataOutFile = new File(toolProperties.getProperty("session.out.file", "coverage.es"));
        }
        RuntimeException failure = null;
        try {
            IMetaData mdata = null;
            ICoverageData cdata = null;
            try {
                long start = log.atINFO() ? System.currentTimeMillis() : 0L;
                for (int f = 0; f < this.m_dataPath.length; ++f) {
                    ICoverageData _cdata;
                    IMergeable[] fileData;
                    IMetaData _mdata;
                    File dataFile = this.m_dataPath[f];
                    if (verbose) {
                        log.verbose("processing input file [" + dataFile.getAbsolutePath() + "] ...");
                    }
                    if ((_mdata = (IMetaData)(fileData = DataFactory.load(dataFile))[0]) != null) {
                        if (verbose) {
                            log.verbose("  loaded " + _mdata.size() + " metadata entries");
                        }
                        mdata = mdata == null ? _mdata : (IMetaData)mdata.merge(_mdata);
                    }
                    if ((_cdata = (ICoverageData)fileData[1]) != null) {
                        if (verbose) {
                            log.verbose("  loaded " + _cdata.size() + " coverage data entries");
                        }
                        cdata = cdata == null ? _cdata : (ICoverageData)cdata.merge(_cdata);
                    }
                    ++this.m_dataFileCount;
                }
                if (log.atINFO()) {
                    long end = System.currentTimeMillis();
                    log.info(this.m_dataFileCount + " file(s) read and merged in " + (end - start) + " ms");
                }
                if ((mdata == null || mdata.isEmpty()) && (cdata == null || cdata.isEmpty())) {
                    log.warning("nothing to do: no metadata or coverage data found in any of the input files");
                    return;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.out);
            }
            if (verbose) {
                if (mdata != null) {
                    log.verbose("  merged metadata contains " + mdata.size() + " entries");
                }
                if (cdata != null) {
                    log.verbose("  merged coverage data contains " + cdata.size() + " entries");
                }
            }
            $assert.ASSERT(sdataOutFile != null, "sdataOutFile not null");
            boolean rename = false;
            File tempDataOutFile = null;
            File canonicalDataOutFile = Files.canonicalizeFile(sdataOutFile);
            for (int f = 0; f < this.m_dataPath.length; ++f) {
                File canonicalDataFile = Files.canonicalizeFile(this.m_dataPath[f]);
                if (!canonicalDataOutFile.equals(canonicalDataFile)) continue;
                rename = true;
                break;
            }
            if (rename) {
                File tempFileDir = canonicalDataOutFile.getParentFile();
                if (tempFileDir == null) {
                    tempFileDir = new File("");
                }
                String tempFileName = Files.getFileName(canonicalDataOutFile) + "emma";
                String tempFileExt = ".et";
                try {
                    tempDataOutFile = Files.createTempFile(tempFileDir, tempFileName, ".et");
                }
                catch (IOException ioe) {
                    throw new EMMARuntimeException(ioe);
                }
                log.warning("the specified output file is one of the input files [" + canonicalDataOutFile + "]");
                log.warning("all merged data will be written to a temp file first [" + tempDataOutFile.getAbsolutePath() + "]");
            }
            long start = log.atINFO() ? System.currentTimeMillis() : 0L;
            File persistFile = null;
            try {
                File file = persistFile = tempDataOutFile != null ? tempDataOutFile : canonicalDataOutFile;
                if (mdata == null || mdata.isEmpty()) {
                    DataFactory.persist(cdata, persistFile, false);
                } else if (cdata == null || cdata.isEmpty()) {
                    DataFactory.persist(mdata, persistFile, false);
                } else {
                    DataFactory.persist(new SessionData(mdata, cdata), persistFile, false);
                }
            }
            catch (IOException ioe) {
                if (persistFile != null) {
                    persistFile.delete();
                }
                throw new EMMARuntimeException(ioe);
            }
            catch (Error e) {
                if (persistFile != null) {
                    persistFile.delete();
                }
                throw e;
            }
            if (rename && !Files.renameFile(tempDataOutFile, canonicalDataOutFile, true)) {
                throw new EMMARuntimeException("could not rename temporary file [" + tempDataOutFile.getAbsolutePath() + "] to [" + canonicalDataOutFile + "]: make sure the original file is not locked and can be deleted");
            }
            if (log.atINFO()) {
                long end = System.currentTimeMillis();
                log.info("merged/compacted data written to [" + canonicalDataOutFile + "] {in " + (end - start) + " ms}");
            }
        }
        catch (SecurityException se) {
            failure = new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, se);
        }
        catch (RuntimeException re) {
            failure = re;
        }
        finally {
            this.reset();
        }
        if (failure != null) {
            if (Exceptions.unexpectedFailure(failure, EXPECTED_FAILURES)) {
                throw new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{failure.toString(), "this private build is unsupported"}, failure);
            }
            throw failure;
        }
    }

    private MergeProcessor() {
    }

    private void reset() {
        this.m_dataFileCount = 0;
    }
}

