/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.resources.Density;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SplitOutputMatcher {
    @NonNull
    public static List<OutputFile> computeBestOutput(@NonNull List<? extends VariantOutput> outputs, @Nullable Set<String> variantAbiFilters, int deviceDensity, @NonNull List<String> deviceAbis) {
        Optional<OutputFile> densityCompatibleSplitApk;
        Density densityEnum = Density.getEnum(deviceDensity);
        String densityValue = densityEnum == null ? null : densityEnum.getResourceValue();
        HashSet<VariantOutput> matches = new HashSet<VariantOutput>();
        for (VariantOutput variantOutput : outputs) {
            for (OutputFile output : variantOutput.getOutputs()) {
                String densityFilter = SplitOutputMatcher.getFilter(output, OutputFile.DENSITY);
                String abiFilter = SplitOutputMatcher.getFilter(output, OutputFile.ABI);
                if (densityFilter != null && !densityFilter.equals(densityValue) || abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
                matches.add(variantOutput);
            }
        }
        if (matches.isEmpty()) {
            return ImmutableList.of();
        }
        VariantOutput match = Collections.max(matches, new Comparator<VariantOutput>(){

            @Override
            public int compare(VariantOutput splitOutput, VariantOutput splitOutput2) {
                return splitOutput.getVersionCode() - splitOutput2.getVersionCode();
            }
        });
        OutputFile outputFile = match.getMainOutputFile();
        if (match.getOutputs().size() == 1) {
            return SplitOutputMatcher.isMainApkCompatibleWithDevice(outputFile, variantAbiFilters, deviceAbis) ? ImmutableList.of((Object)outputFile) : ImmutableList.of();
        }
        ImmutableList.Builder apks = ImmutableList.builder();
        apks.add((Object)outputFile);
        Optional<OutputFile> abiCompatibleSplitApk = SplitOutputMatcher.findAbiCompatibleSplitApk(match, deviceAbis);
        if (abiCompatibleSplitApk.isPresent()) {
            apks.add(abiCompatibleSplitApk.get());
        }
        if ((densityCompatibleSplitApk = SplitOutputMatcher.findDensityCompatibleSplitApk(match, densityValue)).isPresent()) {
            apks.add(densityCompatibleSplitApk.get());
        }
        return apks.build();
    }

    private static boolean isMainApkCompatibleWithDevice(OutputFile mainOutputFile, Set<String> variantAbiFilters, List<String> deviceAbis) {
        if (SplitOutputMatcher.getFilter(mainOutputFile, OutputFile.ABI) == null && variantAbiFilters != null) {
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static Optional<OutputFile> findAbiCompatibleSplitApk(VariantOutput variantOutput, List<String> deviceAbis) {
        for (String deviceAbi : deviceAbis) {
            for (OutputFile outputFile : variantOutput.getOutputs()) {
                if (!outputFile.getOutputType().equals(OutputFile.SPLIT) || !deviceAbi.equals(SplitOutputMatcher.getFilter(outputFile, OutputFile.ABI))) continue;
                return Optional.of((Object)outputFile);
            }
        }
        return Optional.absent();
    }

    private static Optional<OutputFile> findDensityCompatibleSplitApk(VariantOutput variantOutput, String densityValue) {
        for (OutputFile outputFile : variantOutput.getOutputs()) {
            if (!outputFile.getOutputType().equals(OutputFile.SPLIT) || !densityValue.equals(SplitOutputMatcher.getFilter(outputFile, OutputFile.DENSITY))) continue;
            return Optional.of((Object)outputFile);
        }
        return Optional.absent();
    }

    @Nullable
    private static String getFilter(@NonNull OutputFile outputFile, @NonNull String filterType) {
        for (FilterData filterData : outputFile.getFilters()) {
            if (!filterData.getFilterType().equals(filterType)) continue;
            return filterData.getIdentifier();
        }
        return null;
    }
}

