/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.annotations.NonNull;
import com.android.hierarchyviewerlib.models.ThemeModel;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DumpThemeDisplay {
    private static final int DEFAULT_HEIGHT = 600;
    private static final int NUM_COLUMNS = 2;
    private static Shell sShell;
    private static ThemeModel sModel;
    private static Text sSearchText;
    private static Table sTable;
    private static ModifyListener sModifyListener;
    private static ShellAdapter sShellListener;

    public static void show(Shell parentShell, ThemeModel model) {
        if (sShell == null) {
            DumpThemeDisplay.buildContents();
        } else {
            sSearchText.setText("");
            sTable.removeAll();
        }
        sModel = model;
        DumpThemeDisplay.addTableItems("", sModel.getData());
        sShell.setLocation(parentShell.getBounds().x, parentShell.getBounds().y);
        for (int i = 0; i < 2; ++i) {
            sTable.getColumn(i).pack();
        }
        sTable.setLayoutData((Object)GridDataFactory.swtDefaults().hint(DumpThemeDisplay.sTable.computeSize((int)-1, (int)-1).x, 600).create());
        sShell.pack();
        sShell.open();
    }

    private static void addTableItem(String name, String value) {
        TableItem row = new TableItem(sTable, 0);
        row.setText(0, name);
        row.setText(1, value);
    }

    private static String sanitize(@NonNull String text) {
        return text.toLowerCase().trim();
    }

    private static void addTableItems(String searchText, List<ThemeModel.ThemeModelData> list) {
        for (ThemeModel.ThemeModelData data : list) {
            if ("".equals(searchText = DumpThemeDisplay.sanitize(searchText))) {
                DumpThemeDisplay.addTableItem(data.getName(), data.getValue());
                continue;
            }
            if (!DumpThemeDisplay.sanitize(data.getName()).contains(searchText) && !DumpThemeDisplay.sanitize(data.getValue()).contains(searchText)) continue;
            DumpThemeDisplay.addTableItem(data.getName(), data.getValue());
        }
    }

    private static void buildContents() {
        sShell = new Shell(Display.getDefault(), 96);
        sShell.setText("Dump Theme");
        sShell.addShellListener((ShellListener)sShellListener);
        sShell.setLayout((Layout)new GridLayout());
        sSearchText = new Text((Composite)sShell, 2052);
        sSearchText.setMessage("Enter text to search list");
        sSearchText.addModifyListener(sModifyListener);
        sTable = new Table((Composite)sShell, 67584);
        sTable.setHeaderVisible(true);
        sTable.setLinesVisible(true);
        String[] headers = new String[]{"Resource Name", "Resource Value"};
        for (int i = 0; i < headers.length; ++i) {
            TableColumn column = new TableColumn(sTable, 0);
            column.setText(headers[i]);
        }
    }

    static {
        sModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String searchText = DumpThemeDisplay.sanitize(sSearchText.getText());
                sTable.removeAll();
                DumpThemeDisplay.addTableItems(searchText, sModel.getData());
            }
        };
        sShellListener = new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
                sShell.setVisible(false);
            }
        };
    }
}

