/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.SdkConstants;
import com.android.ant.TaskHelper;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.DeweyDecimal;

public class CheckEnvTask
extends Task {
    private static final String ANT_MIN_VERSION = "1.8.0";

    public void execute() {
        DeweyDecimal atLeast = new DeweyDecimal(ANT_MIN_VERSION);
        Project antProject = this.getProject();
        DeweyDecimal version = this.getAntVersion(antProject);
        if (atLeast.isGreaterThan(version)) {
            throw new BuildException("The Android Ant-based build system requires Ant 1.8.0 or later. Current version is " + version);
        }
        File sdkDir = TaskHelper.getSdkLocation(antProject);
        File platformTools = new File(sdkDir, "platform-tools");
        if (!platformTools.isDirectory()) {
            throw new BuildException(String.format("SDK Platform Tools component is missing. Please install it with the SDK Manager (%1$s%2$c%3$s)", "tools", Character.valueOf(File.separatorChar), SdkConstants.androidCmdName()));
        }
        DeweyDecimal toolsRevison = TaskHelper.getToolsRevision(sdkDir);
        if (toolsRevison != null) {
            System.out.println("Android SDK Tools Revision " + toolsRevison);
            System.out.println("Installed at " + sdkDir.getAbsolutePath());
        }
    }

    private DeweyDecimal getAntVersion(Project antProject) {
        char[] versionString = antProject.getProperty("ant.version").toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean foundFirstDigit = false;
        for (int i = 0; i < versionString.length; ++i) {
            if (Character.isDigit(versionString[i])) {
                sb.append(versionString[i]);
                foundFirstDigit = true;
            }
            if (versionString[i] == '.' && foundFirstDigit) {
                sb.append(versionString[i]);
            }
            if (Character.isLetter(versionString[i]) && foundFirstDigit) break;
        }
        return new DeweyDecimal(sb.toString());
    }
}

