﻿//###############################################################
//File:      client.js
//Name:      统一接口专用用户数据同步工具 客户端UI控制代码
//Code By:   小李刀刀(Eric Wu) http://www.oophome.net
//Copyright: 广东佛山动易网络科技有限公司 http://www.powereasy.net
//Version:   v2.0
//###############################################################
var arrIntro = new Array();
var arrBody = new Array();
var objIntro,objBody;
var currentStep = 0;
var xmlHttp;
var init = 1;
var blnSource = false;
var blnRemote = false;
arrIntro[0] = "本程序支持在动易SiteFactory与动网论坛.NET1.0之间进行用户数据同步；在进行操作之前，请务必阅读以下操作步骤说明和注意事项，并严格按照操作步骤进行！"
arrIntro[1] = "请设定源数据库的程序类型版本和数据库类型，同步工具将把该数据库中的用户信息同步复制到目标数据库中。设定完成后需要先进行数据库连接测试，测试成功后才能进行下一步操作。"
arrIntro[2] = "请设定目标数据库的程序类型版本和数据库类型，同步工具将向该数据库中写入用户信息，设定完成后需要先进行数据库连接测试，测试成功后才能进行下一步操作，为了避免操作失败造成用户资料损坏，请务必先备份好该数据库！"
arrIntro[3] = "请设定当同名用户出现时的处理方式，以及是否启用分批处理模式，建议启用。启用分批处理模式以后，可以指定每次处理的数据量，以减少因操作超时或网络超时导致的失败。"
window.onload = function() {
	objIntro = document.getElementById("introcontent");
	objBody = document.getElementById("body0");
	objIntro.innerHTML = arrIntro[0];
	objBody.setAttribute("class","content2");
	objBody.className = "content2";
	checkButtonState(0);
}
function GoNext() {
	currentStep += 1;
	checkButtonState(currentStep);
	if (currentStep > 0 && currentStep < 4) {
		objIntro.innerHTML = arrIntro[currentStep];
		objBody.setAttribute("class","content");
		objBody.className = "content";
		objBody = document.getElementById("body" + currentStep);
		objBody.setAttribute("class","content2");
		objBody.className = "content2";
	}
	if (currentStep == 4) {
		if (confirm("温馨提示：本操作可能会对目标数据库造成不可挽回的更改或损坏。\n\n您确定已经备份过目标数据库了吗？")) {
			document.getElementById("myform").submit();
		} else {
			currentStep = 3;
			checkButtonState(3);
		}
	}
}
function GoPreview() {	
	currentStep -= 1;
	checkButtonState(currentStep);
	if (currentStep > -1 || currentStep < 4) {
		objIntro.innerHTML = arrIntro[currentStep];
		objBody.setAttribute("class","content");
		objBody.className = "content";
		objBody = document.getElementById("body" + currentStep);
		objBody.setAttribute("class","content2");
		objBody.className = "content2";
	}
}
function checkButtonState(newstate) {
	var objBtnGo = document.getElementById("btn_go");
	var objBtnBack = document.getElementById("btn_back");
	switch (newstate) {
		case 0 :
			if (document.getElementById("confirm").checked == false) {
				objBtnGo.setAttribute("disabled","disabled");
			}else{
				objBtnGo.removeAttribute("disabled");
			}
			objBtnBack.setAttribute("disabled","disabled");
			break;
		case 1 :
			if (blnSource) {
				objBtnGo.removeAttribute("disabled");
			}else{
				objBtnGo.setAttribute("disabled","disabled");
			}
			objBtnBack.removeAttribute("disabled");
			break;
		case 2 :
			if (blnRemote) {
				objBtnGo.removeAttribute("disabled");
			}else{
				objBtnGo.setAttribute("disabled","disabled");
			}
			break;
	    case 3 :
			objBtnBack.removeAttribute("disabled");
			objBtnGo.removeAttribute("disabled");
			break;
		default :
			objBtnBack.setAttribute("disabled","disabled");
			objBtnGo.setAttribute("disabled","disabled");
			break;
	}
}
function testconn(testtype) {
	document.getElementById("msgspan").style.display="block";
	var strQuery = "testtype=" + testtype;
	if (testtype == "source") {
		strQuery += "&source_systype=" + getValue("source_systype");
		strQuery += "&source_dbtype=" + getValue("source_dbtype");
		strQuery += "&source_dbpath=" + getValue("source_dbpath");
		strQuery += "&source_servername=" + getValue("source_servername");
		strQuery += "&source_dbname=" + getValue("source_dbname");
		strQuery += "&source_username=" + getValue("source_username");
		strQuery += "&source_password=" + getValue("source_password");
		strQuery += "&sql_source_table=" + getValue("sql_source_table");
		strQuery += "&ac_source_table=" + getValue("ac_source_table");
		strQuery += "&sql_source_c=" + getValue("sql_source_c");
		strQuery += "&ac_source_c=" + getValue("ac_source_c");
	} else if (testtype == "remote") {
		strQuery += "&remote_systype=" + getValue("remote_systype");
		strQuery += "&remote_dbtype=" + getValue("remote_dbtype");
		strQuery += "&remote_dbpath=" + getValue("remote_dbpath");
		strQuery += "&remote_servername=" + getValue("remote_servername");
		strQuery += "&remote_dbname=" + getValue("remote_dbname");
		strQuery += "&remote_username=" + getValue("remote_username");
		strQuery += "&remote_password=" + getValue("remote_password");
		strQuery += "&sql_remote_table=" + getValue("sql_remote_table");
		strQuery += "&ac_remote_table=" + getValue("ac_remote_table");
		strQuery += "&sql_remote_c=" + getValue("sql_remote_c");
		strQuery += "&ac_remote_c=" + getValue("ac_remote_c");
	}
	createXmlHttp();
	xmlHttp.onreadystatechange = function () {
		if (xmlHttp.readyState == 4) {
			document.getElementById("msgspan").style.display = "none";
			var ServerMsg = xmlHttp.responseText;
			var testState = ServerMsg.charAt(1);
			if (testState == "0") {
				if (testtype == "source") {
					blnSource = true;
				} else {
					blnRemote = true;
				}
				var re = /\{0\}/g;
				ServerMsg = ServerMsg.replace(re,"");
			} else {
				if (testtype == "source") {
					blnSource = false;
				} else {
					blnRemote = false;
				}
			}
			checkButtonState(currentStep);
			alert(ServerMsg);
		}
	}
	xmlHttp.open("POST", "UserSynchro.aspx?action=TestConn", true);
	xmlHttp.setRequestHeader("Content-Type","application/x-www-form-urlencoded;");
	xmlHttp.setRequestHeader("Charset","gb2312");
	xmlHttp.send(strQuery);
}

function createXmlHttp() {
	if (window.ActiveXObject) {
		xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
	}else if (window.XMLHttpRequest) {
		xmlHttp = new XMLHttpRequest();
	}
}
function getValue(objID) {
	return document.getElementById(objID).value;
}