﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text.RegularExpressions;
using System.Collections.Specialized;
using System.Text;

public partial class api_API_Response : System.Web.UI.Page
{
    // Fields
    protected ApiData API;

    // Methods
    public bool CheckSysKey(string iName, string iSysKey)
    {
        if (((iName == string.Empty) || (iName == null)) || ((iSysKey == string.Empty) || (iSysKey == null)))
        {
            return false;
        }
        if (iSysKey.Length == 0x20)
        {
            iSysKey = iSysKey.Substring(8, 0x10);
        }
        string str = Common.MD5(iName + this.API.ApiKey).Substring(8, 0x10);
        string str2 = Common.MD5GB2312(iName + this.API.ApiKey).Substring(8, 0x10);
        if ((str.ToLower() != iSysKey.ToLower()) && (str2.ToLower() != iSysKey.ToLower()))
        {
            return false;
        }
        return true;
    }

    public void checkUser()
    {
        this.CheckUserName();
        this.CheckUserEmail();
    }

    public bool CheckUserEmail()
    {
        this.API.SpeItems[7, 1] = this.API.GetNodeText(this.API.SpeItems[7, 0]);
        if (!Regex.IsMatch(this.API.SpeItems[7, 1], @"\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"))
        {
            this.API.FoundErr = true;
            this.API.ErrMsg = "请输入正确的Email";
            return false;
        }
        //程序检查Email逻辑
        return true;
    }

    public bool CheckUserName()
    {
        string username = this.API.SpeItems[5, 1];
        //验证用户名逻辑
        return true;
    }

    public void createUser()
    {
        if (this.CheckUserName() && this.CheckUserEmail())
        {
            //注册逻辑 数据参考 ApiData API.SpeItems
            // this.API.SpeItems[0, 1] ~ this.API.SpeItems[0x1f, 1];
        }
    }

    public void DealResponse()
    {
        try
        {
            this.API.MyXmlDoc.Load(base.Request.InputStream);
        }
        catch
        {
            this.API.FoundErr = true;
            this.API.ErrMsg = "加载xml数据错误!";
            this.API.WriteErrXml();
            return;
        }
        this.API.SpeItems[2, 1] = this.API.GetNodeText(this.API.SpeItems[2, 0]);
        this.API.SpeItems[5, 1] = this.API.GetNodeText(this.API.SpeItems[5, 0]);
        this.API.SpeItems[1, 1] = this.API.GetNodeText(this.API.SpeItems[1, 0]);
        if (((this.API.SpeItems[2, 1] == "") || (this.API.SpeItems[5, 1] == "")) || (this.API.SpeItems[1, 1] == ""))
        {
            this.API.FoundErr = true;
            this.API.ErrMsg = "未包含必须元素，数据同步被拒绝!";
        }
        if (!this.CheckSysKey(this.API.SpeItems[5, 1], this.API.SpeItems[2, 1]))
        {
            this.API.FoundErr = true;
            this.API.ErrMsg = "安全码不符，数据同步被拒绝!";
        }
        this.API.PrepareData(true);
        if (this.API.FoundErr)
        {
            this.API.WriteErrXml();
        }
        switch (this.API.SpeItems[1, 1])
        {
            case "checkname":
                this.checkUser();
                break;

            case "reguser":
                this.createUser();
                break;

            case "login":
                this.loginUser();
                break;

            case "logout":
                this.Loginout();
                break;

            case "update":
                this.UpdateUser();
                break;

            case "delete":
                this.DeleteUser();
                break;

            case "getinfo":
                this.GetUserInfo();
                break;
        }
        if (!this.API.FoundErr)
        {
            this.API.SpeItems[3, 1] = "0";
            this.API.PrepareXml(false);
            this.API.WriteXml();
        }
        else
        {
            this.API.WriteErrXml();
        }
    }

    public void DeleteUser()
    {
        //删除用户逻辑  this.API.SpeItems[5, 1]
    }

    public void GetUserInfo()
    {
        //获取用户信息逻辑 this.API.SpeItems[5, 1]
        //返回数据
            //UserInfo userInfo = Users.GetUserInfo(username);
            //if (userInfo != null)
            //{
            //    this.API.SpeItems[0x12, 1] = userInfo.Location;
            //    this.API.SpeItems[13, 1] = userInfo.Bday;
            //    this.API.SpeItems[30, 1] = string.Empty;
            //    this.API.SpeItems[7, 1] = userInfo.Email;
            //    this.API.SpeItems[20, 1] = userInfo.Website;
            //    this.API.SpeItems[15, 1] = userInfo.Msn;
            //    this.API.SpeItems[6, 1] = userInfo.Password;
            //    this.API.SpeItems[0x1d, 1] = string.Empty;
            //    this.API.SpeItems[14, 1] = userInfo.Qq;
            //    this.API.SpeItems[0x1f, 1] = userInfo.Gender.ToString();
            //    this.API.SpeItems[0x11, 1] = userInfo.Phone;
            //}
        
    }

    public void Loginon()
    {
        //登陆逻辑 用户名：this.API.SpeItems[5, 1] 密码：this.API.SpeItems[6, 1]
        if (this.CheckSysKey(this.API.SpeItems[5, 1], this.API.SpeItems[2, 1]))
        {
            //如果错误，输出错误信息
            //this.API.ErrMsg = "用户名或密码错误！";
            //this.API.WriteErrXml();
        }
    }

    private void Loginout()
    {
        //退出登陆逻辑
    }

    public void loginUser()
    {
        //验证登陆逻辑 用户名：this.API.SpeItems[5, 1] 密码：this.API.SpeItems[6, 1]
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        this.API = new ApiData();
        if (this.API.ApiEnable != "true")
        {
            this.API.ErrMsg = "接口没有开通";
            this.API.WriteErrXml();
        }
        NameValueCollection values = HttpUtility.ParseQueryString(base.Request.Url.Query, Encoding.GetEncoding("GB2312"));
        this.API.SpeItems[2, 1] = this.Context.Request.QueryString[this.API.SpeItems[2, 0]];
        this.API.SpeItems[5, 1] = values[this.API.SpeItems[5, 0]];
        this.API.SpeItems[6, 1] = this.Context.Request.QueryString[this.API.SpeItems[6, 0]];
        this.API.SpeItems[10, 1] = this.Context.Request.QueryString[this.API.SpeItems[10, 0]];
        Response.AddHeader("P3P", "CP=CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR");
        if ((this.API.SpeItems[2, 1] != "") && (this.API.SpeItems[5, 1] != null))
        {
            if ((this.API.SpeItems[5, 1] != "") && (this.API.SpeItems[5, 1] != null))
            {
                if ((this.API.SpeItems[6, 1] != "") && (this.API.SpeItems[6, 1] != null))
                {
                    this.Loginon();
                }
                else
                {
                    this.Loginout();
                }
            }
        }
        else
        {
            this.DealResponse();
        }
    }

    public void UpdateUser()
    {
        //更新用户信息
        //int userID = Users.GetUserId(this.API.SpeItems[5, 1]);
        //if (userID == 0)
        //{
        //    this.API.FoundErr = true;
        //    this.API.ErrMsg = string.Format("同步用户信息失败：用户名{0}不存在！", this.API.SpeItems[5, 1]);
        //}
        //else
        //{
        //    this.API.PrepareData(true);
        //    UserInfo userInfo = Users.GetUserInfo(userID);
        //    if (userInfo != null)
        //    {
        //        userInfo.Location = this.API.SpeItems[0x12, 1];
        //        userInfo.Bday = this.API.SpeItems[13, 1];
        //        userInfo.Email = this.API.SpeItems[7, 1];
        //        userInfo.Website = this.API.SpeItems[20, 1];
        //        userInfo.Msn = this.API.SpeItems[15, 1];
        //        userInfo.Qq = this.API.SpeItems[14, 1];
        //        userInfo.Gender = Utils.StrToInt(this.API.SpeItems[0x1f, 1], 0);
        //        userInfo.Phone = this.API.SpeItems[0x11, 1];
        //        userInfo.Realname = this.API.SpeItems[11, 1];
        //        userInfo.Lastip = this.API.SpeItems[0x15, 1];
        //        Users.UpdateUserProfile(userInfo);
        //        if (!(string.IsNullOrEmpty(this.API.SpeItems[6, 1]) || !(this.API.SpeItems[6, 1] != userInfo.Password)))
        //        {
        //            Users.UpdateUserPassword(userInfo.Uid, this.API.SpeItems[6, 1], true);
        //        }
        //    }
        //}
    }
}
