﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PromotionProduct.aspx.cs"
    Inherits="PowerEasy.Module.Promotion.WebSite.User.Promotion.PromotionProduct" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>
        <asp:Literal ID="LitTitle" runat="server" Text="<%$ Res:User_Promotion_PromotionProduct_Title,查询推广商品 %>" />
    </title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li class="hover"><span><a href="javascript:void(0)">
                    <asp:Literal ID="LitTitle1" runat="server" Text="<%$ Res:User_Promotion_PromotionProduct_Title,查询推广商品 %>" />
                </a></span></li>
            </ul>
        </div>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="EgvPromotion" runat="server" AutoGenerateColumns="False"
                AllowPaging="True" ItemName="<%$ Res: User_Promotion_PromotionProduct_13,推广商品 %>"
                ItemUnit="<%$ Res: User_Promotion_PromotionProduct_14,个 %>" CheckBoxFieldHeaderWidth="3%"
                SerialText="" IsHoldState="True" OnRowDataBound="EgvPromotion_RowDataBound" DataKeyNames="ID"
                DataSourceID="OdsPromotion">
                <Columns>
                    <pe:TemplateField HeaderText="ID" SortExpression="Stocks">
                        <ItemStyle HorizontalAlign="Center" Width="3%" />
                        <ItemTemplate>
                            <%#Eval("ID")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionProduct_15,商品图片 %>">
                        <ItemStyle HorizontalAlign="center" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedImage ID="extendedImage" runat="server" />
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionProduct_16,商品名称 %>"
                        SortExpression="ProductName">
                        <ItemStyle HorizontalAlign="Left" />
                        <ItemTemplate>
                            <pe:LinkImage ID="LinkImageModel" runat="server">
                                <pe:ExtendedLabel ID="LblNodeName" HtmlEncode="false" runat="server"></pe:ExtendedLabel>
                                <asp:HyperLink ID="LnkProductName" runat="server"></asp:HyperLink>
                            </pe:LinkImage>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:BoundField DataField="Unit" HeaderText="<%$ Res: User_Promotion_PromotionProduct_17,单位 %>"
                        SortExpression="Unit">
                        <HeaderStyle Width="5%" />
                    </pe:BoundField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionProduct_18,库存 %>"
                        SortExpression="Stocks">
                        <ItemStyle HorizontalAlign="Right" Width="6%" />
                        <ItemTemplate>
                            <%#Eval("Stocks")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionProduct_19,价格 %>"
                        SortExpression="Price">
                        <ItemStyle HorizontalAlign="Right" />
                        <HeaderStyle Width="7%" />
                        <ItemTemplate>
                            <asp:Label ID="LblProductPrice" runat="server" Text=""></asp:Label>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionProduct_20,佣金类型 %>"
                        SortExpression="CommissionType">
                        <ItemStyle HorizontalAlign="center" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <asp:Label ID="LblCommissionType" runat="server" Text="Label"></asp:Label>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionProduct_21,佣金 %>"
                        SortExpression="Commission">
                        <ItemStyle HorizontalAlign="center" />
                        <HeaderStyle Width="7%" />
                        <ItemTemplate>
                            <asp:Label ID="LblRate" runat="server" Text="Label"></asp:Label>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionProduct_22,操作 %>">
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedLiteral HtmlEncode="false" ID="LblPromotionCode" runat="server"></pe:ExtendedLiteral>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </pe:MemberExtendedGridView>
            <asp:ObjectDataSource ID="OdsPromotion" runat="server" SelectMethod="GetUserPromotionInfoList"
                SelectCountMethod="GetTotalOfPromotion" TypeName="PowerEasy.Module.Promotion.BusinessLogic.Promotion"
                DeleteMethod="Delete" EnablePaging="True" StartRowIndexParameterName="startRowIndexId"
                MaximumRowsParameterName="maxNumberRows" OldValuesParameterFormatString="original_{0}">
                <DeleteParameters>
                    <asp:Parameter Name="id" Type="String" />
                </DeleteParameters>
                <SelectParameters>
                    <asp:QueryStringParameter Name="listType" QueryStringField="ListType" Type="int32" />
                    <asp:QueryStringParameter Name="keyWord" QueryStringField="KeyWord" Type="string" />
                </SelectParameters>
            </asp:ObjectDataSource>
        </div>
    </div>
    <div class="clear">
    </div>
    <div class="model_list_manage">
        <asp:Literal ID="Literal1" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_23,搜索选项：%>" />
        <select id="SelField" style="width: 140px" onchange="ChanageSelect(this)">
            <option value="1" selected="selected">
                <asp:Literal ID="Literal3" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_24,商品名称%>" /></option>
            <option value="2">
                <asp:Literal ID="Literal4" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_25,固定佣金范围%>" /></option>
            <option value="3">
                <asp:Literal ID="Literal5" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_26,佣金百分比范围%>" /></option>
        </select>&nbsp; <span id="key" style="display: ">
            <input id="TxtKeyWord" style="width: 134px;" type="text" class="inputxt" runat="server"
                onclick="keyWord()" value="" />
        </span><span id="key2" style="display: none">
            <input id="TxtCommission1" onclick="checkMoney(this);" class="inputxt" style="width: 45px;
                text-align: right;" type="text" value="0.00" />
            <asp:Literal ID="Literal6" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_28,到%>" />
            <input id="TxtCommission2" onclick="checkMoney(this);" class="inputxt" style="width: 45px;
                text-align: right;" type="text" value="0.00" />
            <asp:Literal ID="Literal7" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_29,元%>" />
        </span><span id="key3" style="display: none">
            <input id="TxtCommission3" onclick="checkMoney(this);" class="inputxt" style="width: 45px;
                text-align: right;" type="text" value="0.00" />
            <asp:Literal ID="Literal8" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_28,到%>" />
            <input id="TxtCommission4" onclick="checkMoney(this);" class="inputxt" style="width: 45px;
                text-align: right;" type="text" value="0.00" />
            % </span>
        <input id='BtnSearch' type='button' class='input_button' value='查询' onclick="return OpenMainRight()" />
        <script type="text/javascript">
            function keyWord() {
                if (document.getElementById('TxtKeyWord').value == '<asp:Literal ID="Literal10" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_27,请输入关键字...%>" />') document.getElementById('TxtKeyWord').value = '';
            }
            function ChanageSelect(select) {
                switch (select.options[select.options.selectedIndex].value) {
                    case "1":
                        document.getElementById("key").style.display = "";
                        document.getElementById("key2").style.display = "none";
                        document.getElementById("key3").style.display = "none";
                        break;
                    case "2":
                        document.getElementById("key").style.display = "none";
                        document.getElementById("key2").style.display = "";
                        document.getElementById("key3").style.display = "none";
                        break;
                    case "3":
                        document.getElementById("key").style.display = "none";
                        document.getElementById("key2").style.display = "none";
                        document.getElementById("key3").style.display = "";
                        break;
                    default:
                        break;
                }
            }
            function checkMoney(obj) {
                var tempValue = obj.value.replace(/(^\s+)|(\s+$)/g, '');
                if (!tempValue) { return }
                if (/^-?\d+(\.\d+)?$/.test(tempValue)) {
                    obj.value = parseFloat(tempValue).toFixed(2);
                    return true;
                } else {
                    alert('<asp:Literal ID="Literal18" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_31,请输入可包含小数点后2位的有效数字值！%>" />');
                    obj.value = "0.00";
                    obj.focus();
                    return false;
                }
            }
            function OpenMainRight() {
                var field = 0;
                var objSel = document.getElementById("SelField");
                var keyword = "";
                field = objSel.options[objSel.options.selectedIndex].value;

                switch (field) {
                    case "1":
                        keyword = document.getElementById('TxtKeyWord').value;
                        if (keyword == "") {
                            alert('<asp:Literal ID="Literal17" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_32,请输入要查询的条件！%>" />');
                            return false;
                        }
                        break;
                    case "2":
                        var commission1 = document.getElementById('TxtCommission1').value;
                        if (commission1 == "") {
                            alert('<asp:Literal ID="Literal11" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_33,请输入要开始的查询范围！%>" />');
                            return false;
                        }
                        var commission2 = document.getElementById('TxtCommission2').value;
                        if (commission2 == "") {
                            alert('<asp:Literal ID="Literal12" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_34,请输入要结束的查询范围！%>" />');
                            return false;
                        }
                        if (parseInt(commission1) > parseInt(commission2)) {
                            alert('<asp:Literal ID="Literal13" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_35,查询开始范围不能大于查询结束范围！%>" />');
                            return false;
                        }
                        keyword = commission1 + "$$$" + commission2;
                        break;
                    case "3":
                        var commission3 = document.getElementById('TxtCommission3').value;
                        if (commission3 == "") {
                            alert('<asp:Literal ID="Literal14" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_33,请输入要开始的查询范围！%>" />');
                            return false;
                        }
                        var commission4 = document.getElementById('TxtCommission4').value;
                        if (commission4 == "") {
                            alert('<asp:Literal ID="Literal15" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_34,请输入要结束的查询范围！%>" />');
                            return false;
                        }
                        if (parseInt(commission3) > parseInt(commission4)) {
                            alert('<asp:Literal ID="Literal16" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_35,查询开始范围不能大于查询结束范围！%>" />');
                            return false;
                        }
                        keyword = commission3 + "$$$" + commission4;
                        break;
                    default:
                        break;
                }

                var url = "PromotionProduct.aspx?ListType=" + field + "&KeyWord=" + escape(keyword);
                window.location = url;
            }
        </script>
    </div>
    <div class="model_Info_Tips">
        <asp:Literal ID="Literal9" runat="server" Text="<%$ Res: User_Promotion_PromotionProduct_30,注意：商品价格为商品的当前零售价格，不同会员会因为会员组的折扣比会显示有不同的价格。  %>" />
    </div>
    </form>
</body>
</html>
