﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PromotionOrder.aspx.cs"
    Inherits="PowerEasy.Module.Promotion.WebSite.User.Promotion.PromotionOrder" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>
        <asp:Literal ID="LitTitle" runat="server" Text="<%$ Res:User_Promotion_PromotionOrder_Title,查看推广订单 %>" />
    </title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li class="hover"><span><a href="javascript:void(0)">
                    <asp:Literal ID="LitTitle1" runat="server" Text="<%$ Res:User_Promotion_PromotionOrder_Title,查看推广订单 %>" />
                </a></span></li>
            </ul>
        </div>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="GdvPromotionOrder" runat="server" AutoGenerateColumns="False"
                DataSourceID="OdsOrder" DataKeyNames="OrderId" OnRowDataBound="GdvPromotionOrder_RowDataBound"
                AllowPaging="True" OnDataBound="GdvPromotionOrder_DataBound" ItemName="<%$ Res: User_Promotion_PromotionOrder_16,订单%>"
                ItemUnit="<%$ Res: User_Promotion_PromotionOrder_17,个%>" EmptyDataText="<%$ Res: User_Promotion_PromotionOrder_18,没有任何符合条件的订单！%>"
                AutoGenerateCheckBoxColumn="False" ShowFooter="True" CheckBoxFieldHeaderWidth="3%"
                SerialText="" RowDblclickBoundField="OrderId">
                <Columns>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionOrder_19,订单编号%>" SortExpression="OrderNum">
                        <HeaderStyle Width="35%" />
                        <ItemTemplate>
                            <%#Eval("OrderNum")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionOrder_20,下单时间%>" SortExpression="InputTime">
                        <HeaderStyle Width="30%" />
                        <ItemTemplate>
                            <%# Eval("InputTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionOrder_21,订单状态%>">
                        <HeaderStyle Width="15%" />
                        <ItemTemplate>
                            <pe:ExtendedLabel HtmlEncode="false" ID="LblOrderStatus" runat="server" />
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionOrder_22,订单金额%>" SortExpression="MoneyTotal">
                        <ItemStyle HorizontalAlign="Right" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedLabel HtmlEncode="false" ID="LblOrderMoney" runat="server" />
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_Promotion_PromotionOrder_23,佣金金额%>">
                        <ItemStyle HorizontalAlign="Right" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedLabel HtmlEncode="false" ID="LblCommission" runat="server" />
                        </ItemTemplate>
                    </pe:TemplateField>
                </Columns>
                <FooterStyle CssClass="tdbg" />
            </pe:MemberExtendedGridView>
            <asp:HiddenField ID="HdnOrderType" runat="server" Value="99" />
            <asp:HiddenField ID="HdnListType" runat="server" Value="0" />
            <asp:ObjectDataSource ID="OdsOrder" runat="server" SelectCountMethod="GetTotalOfPromotionOrder"
                SelectMethod="GetUserPromotionOrderInfoList" TypeName="PowerEasy.Module.Promotion.BusinessLogic.PromotionOrder"
                EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
                <SelectParameters>
                    <asp:ControlParameter ControlID="HdnOrderType" Type="Int32" Name="orderType" PropertyName="Value" />
                    <asp:ControlParameter ControlID="HdnListType" Type="Int32" Name="listType" PropertyName="Value" />
                    <asp:ControlParameter ControlID="DpkStartDate" Type="DateTime" Name="startDate" PropertyName="Text" />
                    <asp:ControlParameter ControlID="DpkEndDate" Type="DateTime" Name="endDate" PropertyName="Text" />
                </SelectParameters>
            </asp:ObjectDataSource>
        </div>
    </div>
    <div class="clear">
    </div>
    <div class="model_list_manage">
        <asp:Literal ID="Literal2" runat="server" Text="<%$ Res: User_Promotion_PromotionOrder_4,开始日期：%>" />
        <pe:DatePicker ID="DpkStartDate" runat="server" Width="80" DateImage="~/User/Images/Calendar.gif"
            CssClass="inputxt"></pe:DatePicker>
        <pe:RequiredFieldValidator ID="ValrDpkStartDate" ControlToValidate="DpkStartDate"
            runat="server" ErrorMessage="<%$ Res: User_Promotion_PromotionOrder_14,开始日期不能为空！%>"
            Display="Dynamic" RequiredText="" ValidationGroup="Search"></pe:RequiredFieldValidator><pe:RegexValidator
                ValidateType="Date" ID="VdateStartDate" runat="server" ControlToValidate="DpkStartDate"
                Display="Dynamic" ErrorMessage="日期不正确！" SetFocusOnError="true" ValidationGroup="Search"></pe:RegexValidator>
        <asp:Literal ID="Literal3" runat="server" Text="<%$ Res: User_Promotion_PromotionOrder_5,结束日期：%>" />
        <pe:DatePicker ID="DpkEndDate" runat="server" Width="80" DateImage="~/User/Images/Calendar.gif"
            CssClass="inputxt"></pe:DatePicker><pe:RequiredFieldValidator ID="ValrDpkEndDate"
                ControlToValidate="DpkEndDate" runat="server" ErrorMessage="<%$ Res: User_Promotion_PromotionOrder_15,结束日期不能为空！%>"
                Display="Dynamic" RequiredText="" ValidationGroup="Search"></pe:RequiredFieldValidator>
        <pe:RegexValidator ValidateType="Date" ID="VdateEndDate" runat="server" ControlToValidate="DpkEndDate"
            Display="Dynamic" SetFocusOnError="true" ErrorMessage="日期不正确！" ValidationGroup="Search"></pe:RegexValidator>
        <asp:Literal ID="Literal4" runat="server" Text="<%$ Res: User_Promotion_PromotionOrder_6,订单状态：%>" />
        <asp:DropDownList ID="DropOrderStatus" runat="server">
        </asp:DropDownList>
        <asp:Button ID="BtnSearch" runat="server" CssClass="input_button" Text=" <%$ Res: User_Promotion_PromotionOrder_13,查询%> "
            OnClick="BtnSearch_Click" ValidationGroup="Search" />
    </div>
    <div class="model_Info_Tips">
        <asp:Literal ID="Literal5" runat="server" Text="<%$ Res: User_Promotion_PromotionOrder_24,注意： 订单金额只统计该订单中所有推广商品的金额统计。%>" />
    </div>
    </form>
</body>
</html>
