﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Bankroll.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.User.Info.Bankroll" %>

<%@ Import Namespace="PowerEasy.Module.General.BusinessLogic.Accessories" %>
<%@ Import Namespace="PowerEasy.Module.General.Model.Accessories" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li id="TabTitle6"><span>
                    <asp:HyperLink runat="server" ID="LnkShowAll" NavigateUrl="Bankroll.aspx?ShowType=6"
                        Text="<%$Res: User_Info_Bankroll_ShowAll%>" /></span></li>
                <li id="TabTitle7"><span>
                    <asp:HyperLink runat="server" ID="LnkShowIncome" NavigateUrl="Bankroll.aspx?ShowType=7"
                        Text="<%$Res: User_Info_Bankroll_ShowIncome%>" /></span></li>
                <li id="TabTitle8"><span>
                    <asp:HyperLink runat="server" ID="LnkShowOutput" NavigateUrl="Bankroll.aspx?ShowType=8"
                        Text="<%$Res: User_Info_Bankroll_ShowOutput%>" /></span></li>
            </ul>
        </div>
        <script type="text/javascript">
            Request = {
                QueryString: function (item) {
                    var svalue = location.search.match(new RegExp("[\?\&]" + item + "=([^\&]*)(\&?)", "i"));
                    return svalue ? svalue[1] : svalue;
                }
            }
            var showtype = Request.QueryString("ShowType");
            document.getElementById("TabTitle" + showtype.toString()).className = "hover";                
        </script>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="EgvBankroll" runat="server" AutoGenerateColumns="False"
                CheckBoxFieldHeaderWidth="3%" DataSourceID="OdsBankroll" EmptyDataText="<%$ Res: User_Info_Bankroll_EgvBankroll,没有任何符合条件的资金记录！ %>"
                SerialText="" DataKeyNames="ItemId" AllowPaging="True" OnDataBound="EgvBankroll_DataBound"
                OnRowDataBound="EgvBankroll_RowDataBound" ShowFooter="True" IsHoldState="True">
                <Columns>
                    <asp:BoundField DataField="DateAndTime" HeaderText="<%$ Res: User_Info_Bankroll_BoundField1,交易时间 %>"
                        SortExpression="DateAndTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                        <HeaderStyle Width="16%" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="<%$ Res: User_Info_Bankroll_TemplateField1,交易方式 %>"
                        SortExpression="MoneyType">
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <%#  BankrollItem.GetMoneyType(Eval("MoneyType")) %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Res: User_Info_Bankroll_TemplateField2,币种 %>"
                        SortExpression="CurrencyType">
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <%# BankrollItem.GetCurrencyType(Eval("CurrencyType")) %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Res: User_Info_Bankroll_TemplateField3,收入金额 %>">
                        <ItemStyle CssClass="content_right" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <%# (decimal)Eval("Money")>0?Eval("Money","{0:N2}"):"" %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Res: User_Info_Bankroll_TemplateField4,支出金额 %>">
                        <ItemStyle CssClass="content_right" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <%#  (decimal)Eval("Money")>0?"":Math.Abs((decimal)Eval("Money")).ToString("N2") %>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Res: User_Info_Bankroll_TemplateField5,银行名称 %>"
                        SortExpression="Bank">
                        <ItemTemplate>
                            <%# (int)Eval("MoneyType") == 3 ? PayPlatform.GetPayPlatformById((int)Eval("EBankId")).PayPlatformName : (Eval("Bank")== null ? "" : Eval("Bank").ToString())%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="<%$ Res: User_Info_Bankroll_TemplateField6,备注/说明 %>"
                        SortExpression="Remark">
                        <ItemStyle CssClass="content_left" />
                        <ItemTemplate>
                            <asp:Label runat="server" Text='' ID="LblRemark"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </pe:MemberExtendedGridView>
        </div>
    </div>
    <asp:HiddenField ID="HdnBankRollType" Value="0" runat="server" />
    <asp:ObjectDataSource ID="OdsBankroll" runat="server" SelectMethod="GetList" TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.BankrollItem"
        EnablePaging="True" SelectCountMethod="GetTotalOfBankrollItem">
        <SelectParameters>
            <asp:Parameter DefaultValue="0" Name="startRowIndex" Type="Int32" />
            <asp:Parameter DefaultValue="10" Name="maximumRows" Type="Int32" />
            <asp:Parameter DefaultValue="10" Name="searchType" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="6" Name="field" QueryStringField="ShowType"
                Type="Int32" />
            <asp:ControlParameter ControlID="HdnUserName" DefaultValue="" Name="keyword" PropertyName="Value"
                Type="String" />
            <asp:ControlParameter ControlID="HdnBankRollType" Type="Int32" Name="brankRollType"
                PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HdnUserName" runat="server" />
    </form>
    <div class="model_Info_Tips">
        <asp:Literal ID="BankrollNotice" runat="server" Text="<%$ Resources: DynamicPageResources , User_Info_Bankroll_Notice%>" /></div>
</body>
</html>
