﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Favorite.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.User.Content.Favorites" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>我收藏的信息</title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li class="hover"><span><a href="javascript:void(0)">
                    <asp:Localize ID="Localize4" Text="<%$ Res: User_Contents_Favorite_PageTitle,我收藏的信息 %>"
                        runat="server" /></a></span></li>
            </ul>
        </div>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="EgvFavorite" DataKeyNames="InfoId" runat="server"
                AllowPaging="True" AutoGenerateColumns="False" AutoGenerateCheckBoxColumn="true"
                ItemName="<%$ Res: User_Contents_Favorite_EgvFavorite,记录 %>" SerialText="" CheckBoxFieldHeaderWidth="3%"
                DataSourceID="OdsFavorite" OnRowDataBound="EgvFavorite_RowDataBound">
                <Columns>
                    <pe:BoundField DataField="InfoId" HeaderStyle-Width="6%" HeaderText="ID" SortExpression="InfoId" />
                    <pe:TemplateField>
                        <HeaderTemplate>
                            <asp:Localize ID="Localize1" Text="<%$ Res: User_Contents_Favorite_Localize1,标题 %>"
                                runat="server" /></HeaderTemplate>
                        <ItemTemplate>
                            <asp:HyperLink ID="HLContentPreview" Target="_blank" runat="server"></asp:HyperLink>
                        </ItemTemplate>
                        <ItemStyle CssClass="content_left" />
                    </pe:TemplateField>
                    <pe:BoundField DataField="FavoriteTime" HeaderStyle-Width="18%" HeaderText="<%$ Res: User_Contents_Favorite_BoundField2,收藏时间 %>"
                        SortExpression="FavoriteTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="false" />
                    <pe:TemplateField HeaderText="<%$ Res: User_Contents_Favorite_TemplateField2,操作 %>">
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedNodeAnchor ID="EahContentView" IsChecked="false" href='<%# "Favorite.aspx?Action=Delete&Id=" + Eval("InfoId")%>'
                                runat="server">
                                <asp:Localize ID="Localize2" Text="<%$ Res: User_Contents_Favorite_Localize2,取消收藏 %>"
                                    runat="server" /></pe:ExtendedNodeAnchor>
                        </ItemTemplate>
                    </pe:TemplateField>
                </Columns>
            </pe:MemberExtendedGridView>
        </div>
    </div>
    <div class="clear">
    </div>
    <div class="model_list_manage">
        <label
            for="ChkAll" class="checkbox"><input id="ChkAll" type="checkbox" /> <asp:Localize ID="Localize3" Text="<%$ Res: User_Contents_Favorite_Localize3,全选 %>"
                runat="server" /></label>
        <asp:Button CssClass="input_button_seven" ID="BtnBatchDelete" runat="server" OnClientClick="return batchconfirm();"
            Text="<%$ Res: User_Contents_Favorite_BtnBatchDelete,批量取消收藏 %>" OnClick="BtnBatchDelete_Click" />
    </div>
    <asp:ObjectDataSource ID="OdsFavorite" runat="server" SelectMethod="GetList" SelectCountMethod="GetTotalOfFavorite"
        TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.Favorite"  EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:Parameter Name="userId" Type="int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="nodeId" QueryStringField="NodeId"
                Type="Int32" />
            <asp:Parameter Name="modelType" Type="int32" DefaultValue="1" />
        </SelectParameters>
    </asp:ObjectDataSource>
    </form>
</body>
</html>
