﻿<%@ Page Language="C#" Inherits="PowerEasy.Foundation.Web.UI.BasePage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        string payOnlineShopID;
        string PayOnlineKey;

        int payPlatformId = 5;  //西部支付
        PowerEasy.Module.General.Model.Accessories.PayPlatformInfo payPlatform = PowerEasy.Module.General.BusinessLogic.Accessories.PayPlatform.GetPayPlatformById(payPlatformId);
        if (payPlatform.IsDisabled || payPlatform.MD5 == "3069" || string.IsNullOrEmpty(payPlatform.MD5))
        {
            LblMsg.Text = Resources.DynamicPageResources.PayOnline_PayResult99bill_ToPayNo;
            return;
        }

        payOnlineShopID = payPlatform.AccountsId;
        PayOnlineKey = payPlatform.MD5;
        string v_mid = Request["p1_MerId"];
        string v_oid = Request["r6_Order"];
        string v_amount = Request["r3_Amt"];

        // 商家的交易定单号
        string p2_Order = Request.Form["p2_Order"];
        StringBuilder message = new StringBuilder();
        try
        {
            // 查询订单
            BuyQueryOrdDetailResult result = QueryOrdDetail(p2_Order, payOnlineShopID, PayOnlineKey);

            if (result.R1_Code == "1")
            {
                message = new StringBuilder(Resources.DynamicPageResources.PayOnline_PayResultYeepay_ToPayYes);
                PowerEasy.Module.Shop.BusinessLogic.PayOnline payOnline = new PowerEasy.Module.Shop.BusinessLogic.PayOnline();
                PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState payOnlineState = payOnline.UpdateOrder(v_oid, PowerEasy.Framework.Common.DataConverter.ToDecimal(v_amount), "", 3, "", true, true);
                if (payOnlineState == PowerEasy.Module.General.Enumerations.Accessories.PayOnlineState.Ok)
                {
                    message.Append(payOnline.Message);
                }
                else
                {
                    message.Append(PowerEasy.Module.Shop.BusinessLogic.PayOnline.GetStateDescription(payOnlineState));
                }
                LblMsg.Text = message.ToString();
            }
            else
            {
                message.Append(Resources.DynamicPageResources.PayOnline_PayResultYeepay_Err);
            }
        }
        catch (Exception)
        {
            
        }

        PowerEasy.Module.Shop.BusinessLogic.PayOnline.TestLog(false, Resources.DynamicPageResources.PayOnline_PayResultYeepay_FastToPay, message.ToString(), v_mid.Trim(), payOnlineShopID.Trim());

    }

    #region BuyQueryOrdDetailResult 查询订单明细(通讯)
    /// <summary>
    /// 查询订单明细
    /// </summary>
    /// <param name="p1_MerId">商户编号</param>
    /// <param name="keyValue">商户密钥</param>
    /// <param name="p2_Order">商户订单号</param>
    /// <returns>BuyQueryOrdDetailResult</returns>
    public static BuyQueryOrdDetailResult QueryOrdDetail(string p2_Order, string id, string keyvalue)
    {
        string sbOld = "";

        sbOld += "QueryOrdDetail";
        sbOld += id;
        sbOld += p2_Order;

        string hmac = HmacSign(sbOld, keyvalue);
        string para = "";

        para += "?p0_Cmd=QueryOrdDetail";
        para += "&p1_MerId=" + id;	    	//加入商家ID
        para += "&p2_Order=" + p2_Order;				//加入购买订单号码
        para += "&hmac=" + hmac;      	    //加入校验码

        string reqResult = HttpUtils.SendRequest("https://www.yeepay.com/app-merchant-proxy/command", para);

        string r0_Cmd = FormatQueryString.GetQueryString("r0_Cmd", reqResult, '\n');
        string r1_Code = FormatQueryString.GetQueryString("r1_Code", reqResult, '\n');
        string r2_TrxId = FormatQueryString.GetQueryString("r2_TrxId", reqResult, '\n');
        string r3_Amt = FormatQueryString.GetQueryString("r3_Amt", reqResult, '\n');
        string r4_Cur = FormatQueryString.GetQueryString("r4_Cur", reqResult, '\n');

        string r5_Pid = FormatQueryString.GetQueryString("r5_Pid", reqResult, '\n');
        string r6_Order = FormatQueryString.GetQueryString("r6_Order", reqResult, '\n');
        string r8_MP = FormatQueryString.GetQueryString("r8_MP", reqResult, '\n');
        string rb_PayStatus = FormatQueryString.GetQueryString("rb_PayStatus", reqResult, '\n');
        string rc_RefundCount = FormatQueryString.GetQueryString("rc_RefundCount", reqResult, '\n');

        string rd_RefundAmt = FormatQueryString.GetQueryString("rd_RefundAmt", reqResult, '\n');
        hmac = FormatQueryString.GetQueryString("hmac", reqResult, '\n');
        //string hmac			= FormatQueryString.GetQueryString("hmac", reqResult, '\n');

        BuyQueryOrdDetailResult result = new BuyQueryOrdDetailResult(r0_Cmd, r1_Code, r2_TrxId, r3_Amt, r4_Cur, r5_Pid, r6_Order, r8_MP, rb_PayStatus, rc_RefundCount, rd_RefundAmt, hmac);

        return result;
    }
    public abstract class FormatQueryString
    {
        public FormatQueryString()
        {

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="strParaName"></param>
        /// <param name="strUrl"></param>
        /// <param name="strSplitChar"></param>
        /// <returns></returns>
        public static string GetQueryString(string strParaName, string strUrl, char strSplitChar)
        {
            string result = "";

            string[] strUrlArg = strUrl.Split(strSplitChar);

            for (int i = 0; i < strUrlArg.Length; i++)
            {
                if (strUrlArg[i].IndexOf(strParaName) >= 0)
                {
                    result = System.Web.HttpUtility.UrlDecode(strUrlArg[i].Split('=')[1], System.Text.Encoding.GetEncoding("gb2312"));
                    break;
                }
            }
            return result;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="strParaName"></param>
        /// <param name="strUrl"></param>
        /// <returns></returns>
        public static string GetQueryString(string strParaName, string strUrl)
        {
            return GetQueryString(strParaName, strUrl, '&');
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="strParaName"></param>
        /// <returns></returns>
        public static string GetQueryString(string strParaName)
        {
            return GetQueryString(strParaName, System.Web.HttpContext.Current.Request.Url.Query, '&');
        }

    }

    /// <summary>
    /// 通讯函数
    /// </summary>
    public abstract class HttpUtils
    {
        public HttpUtils()
        {

        }

        #region 通讯函数
        /// <summary>
        /// 通讯函数
        /// </summary>
        /// <param name="url">请求Url</param>
        /// <param name="para">请求参数</param>
        /// <param name="method">请求方式GET/POST</param>
        /// <returns></returns>
        public static string SendRequest(string url, string para, string method)
        {
            string strResult = "";

            if (url == null || url == "")
                return null;

            if (method == null || method == "")
                method = "GET";

            // GET方式
            if (method.ToUpper() == "GET")
            {
                try
                {
                    System.Net.WebRequest wrq = System.Net.WebRequest.Create(url + para);
                    wrq.Method = "GET";

                    System.Net.WebResponse wrp = wrq.GetResponse();
                    System.IO.StreamReader sr = new System.IO.StreamReader(wrp.GetResponseStream(), System.Text.Encoding.GetEncoding("gb2312"));

                    strResult = sr.ReadToEnd();
                }
                catch (Exception ex)
                {
                    return ex.Message;
                }
            }

            // POST方式
            if (method.ToUpper() == "POST")
            {
                if (para.Length > 0 && para.IndexOf('?') == 0)
                {
                    para = para.Substring(1);
                }

                System.Net.WebRequest req = System.Net.WebRequest.Create(url);
                req.Method = "POST";
                req.ContentType = "application/x-www-form-urlencoded";
                StringBuilder UrlEncoded = new StringBuilder();
                Char[] reserved = { '?', '=', '&' };
                byte[] SomeBytes = null;
                if (para != null)
                {
                    int i = 0, j;
                    while (i < para.Length)
                    {
                        j = para.IndexOfAny(reserved, i);
                        if (j == -1)
                        {
                            UrlEncoded.Append(HttpUtility.UrlEncode(para.Substring(i, para.Length - i), System.Text.Encoding.GetEncoding("gb2312")));
                            break;
                        }
                        UrlEncoded.Append(HttpUtility.UrlEncode(para.Substring(i, j - i), System.Text.Encoding.GetEncoding("gb2312")));
                        UrlEncoded.Append(para.Substring(j, 1));
                        i = j + 1;
                    }
                    SomeBytes = Encoding.Default.GetBytes(UrlEncoded.ToString());
                    req.ContentLength = SomeBytes.Length;
                    System.IO.Stream newStream = req.GetRequestStream();
                    newStream.Write(SomeBytes, 0, SomeBytes.Length);
                    newStream.Close();
                }
                else
                {
                    req.ContentLength = 0;
                }
                try
                {
                    System.Net.WebResponse result = req.GetResponse();
                    System.IO.Stream ReceiveStream = result.GetResponseStream();

                    Byte[] read = new Byte[512];
                    int bytes = ReceiveStream.Read(read, 0, 512);

                    while (bytes > 0)
                    {

                        // 注意：
                        // 下面假定响应使用 UTF-8 作为编码方式。
                        // 如果内容以 ANSI 代码页形式（例如，932）发送，则使用类似下面的语句：
                        //  Encoding encode = System.Text.Encoding.GetEncoding("shift-jis");
                        Encoding encode = System.Text.Encoding.GetEncoding("gb2312");
                        strResult += encode.GetString(read, 0, bytes);
                        bytes = ReceiveStream.Read(read, 0, 512);
                    }

                    return strResult;
                }
                catch (Exception ex)
                {
                    return ex.Message;
                }
            }
            return strResult;
        }
        #endregion

        #region 简化通讯函数
        /// <summary>
        /// GET方式通讯
        /// </summary>
        /// <param name="url"></param>
        /// <param name="para"></param>
        /// <returns></returns>
        public static string SendRequest(string url, string para)
        {
            return SendRequest(url, para, "GET");
        }
        #endregion
    }

    /// <summary>
    /// BuyQueryOrdDetailResult的实体类
    /// </summary>
    [Serializable]
    public class BuyQueryOrdDetailResult
    {
        private string r0_Cmd;
        private string r1_Code;
        private string r2_TrxId;
        private string r3_Amt;
        private string r4_Cur;

        private string r5_Pid;
        private string r6_Order;
        private string r8_MP;
        private string rb_PayStatus;
        private string rc_RefundCount;

        private string rd_RefundAmt;
        private string hmac;

        /// <summary>
        /// B2C在线支付订单明细查询返回序列
        /// </summary>
        /// <param name="r0_Cmd"></param>
        /// <param name="r1_Code"></param>
        /// <param name="r2_TrxId"></param>
        /// <param name="r3_Amt"></param>
        /// <param name="r4_Cur"></param>
        /// <param name="r5_Pid"></param>
        /// <param name="r6_Order"></param>
        /// <param name="r8_MP"></param>
        /// <param name="rb_PayStatus"></param>
        /// <param name="rc_RefundCount"></param>
        /// <param name="rd_RefundAmt"></param>
        /// <param name="hmac"></param>
        public BuyQueryOrdDetailResult(string r0_Cmd, string r1_Code, string r2_TrxId, string r3_Amt, string r4_Cur, string r5_Pid, string r6_Order, string r8_MP, string rb_PayStatus, string rc_RefundCount, string rd_RefundAmt, string hmac)
        {
            this.r0_Cmd = r0_Cmd;
            this.r1_Code = r1_Code;
            this.r2_TrxId = r2_TrxId;
            this.r3_Amt = r3_Amt;
            this.r4_Cur = r4_Cur;

            this.r5_Pid = r5_Pid;
            this.r6_Order = r6_Order;
            this.r8_MP = r8_MP;
            this.rb_PayStatus = rb_PayStatus;
            this.rc_RefundCount = rc_RefundCount;

            this.rd_RefundAmt = rd_RefundAmt;
            this.hmac = hmac;
        }

        public string R0_Cmd
        {
            get { return r0_Cmd; }
        }

        public string R1_Code
        {
            get { return r1_Code; }
        }

        public string R2_TrdId
        {
            get { return r2_TrxId; }
        }

        public string R3_Amt
        {
            get { return r3_Amt; }
        }

        public string R4_Cur
        {
            get { return r4_Cur; }
        }
        //---
        public string R5_Pid
        {
            get { return r5_Pid; }
        }

        public string R6_Order
        {
            get { return r6_Order; }
        }

        public string R8_MP
        {
            get { return r8_MP; }
        }

        public string Rb_PayStatus
        {
            get { return rb_PayStatus; }
        }

        public string Rc_RefundCount
        {
            get { return rc_RefundCount; }
        }
        //---
        public string Rd_RefundAmt
        {
            get { return rd_RefundAmt; }
        }

        public string Hmac
        {
            get { return hmac; }
        }
    }
    #endregion

    public static string HmacSign(string aValue, string aKey)
    {
        byte[] k_ipad = new byte[64];
        byte[] k_opad = new byte[64];
        byte[] keyb;
        byte[] Value;
        keyb = Encoding.UTF8.GetBytes(aKey);
        Value = Encoding.UTF8.GetBytes(aValue);

        for (int i = keyb.Length; i < 64; i++)
            k_ipad[i] = 54;

        for (int i = keyb.Length; i < 64; i++)
            k_opad[i] = 92;

        for (int i = 0; i < keyb.Length; i++)
        {
            k_ipad[i] = (byte)(keyb[i] ^ 0x36);
            k_opad[i] = (byte)(keyb[i] ^ 0x5c);
        }

        HmacMD5 md = new HmacMD5();

        md.update(k_ipad, (uint)k_ipad.Length);
        md.update(Value, (uint)Value.Length);
        byte[] dg = md.finalize();
        md.init();
        md.update(k_opad, (uint)k_opad.Length);
        md.update(dg, 16);
        dg = md.finalize();

        return toHex(dg);
    }
    public static string toHex(byte[] input)
    {
        if (input == null)
            return null;

        StringBuilder output = new StringBuilder(input.Length * 2);

        for (int i = 0; i < input.Length; i++)
        {
            int current = input[i] & 0xff;
            if (current < 16)
                output.Append("0");
            output.Append(current.ToString("x"));
        }

        return output.ToString();
    }
    public class HmacMD5
    {
        private uint[] count;
        private uint[] state;
        private byte[] buffer;
        private byte[] Digest;

        public HmacMD5()
        {
            count = new uint[2];
            state = new uint[4];
            buffer = new byte[64];
            Digest = new byte[16];
            init();
        }

        public void init()
        {
            count[0] = 0;
            count[1] = 0;
            state[0] = 0x67452301;
            state[1] = 0xefcdab89;
            state[2] = 0x98badcfe;
            state[3] = 0x10325476;
        }

        public void update(byte[] data, uint length)
        {
            uint left = length;
            uint offset = (count[0] >> 3) & 0x3F;
            uint bit_length = (uint)(length << 3);
            uint index = 0;

            if (length <= 0)
                return;

            count[0] += bit_length;
            count[1] += (length >> 29);
            if (count[0] < bit_length)
                count[1]++;

            if (offset > 0)
            {
                uint space = 64 - offset;
                uint copy = (offset + length > 64 ? 64 - offset : length);
                System.Buffer.BlockCopy(data, 0, buffer, (int)offset, (int)copy);

                if (offset + copy < 64)
                    return;

                transform(buffer);
                index += copy;
                left -= copy;
            }

            for (; left >= 64; index += 64, left -= 64)
            {
                System.Buffer.BlockCopy(data, (int)index, buffer, 0, 64);
                transform(buffer);
            }

            if (left > 0)
                System.Buffer.BlockCopy(data, (int)index, buffer, 0, (int)left);

        }

        private static byte[] pad = new byte[64] {
													 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
													 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
													 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
													 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        public byte[] finalize()
        {
            byte[] bits = new byte[8];
            encode(ref bits, count, 8);
            uint index = (uint)((count[0] >> 3) & 0x3f);
            uint padLen = (index < 56) ? (56 - index) : (120 - index);
            update(pad, padLen);
            update(bits, 8);
            encode(ref Digest, state, 16);

            for (int i = 0; i < 64; i++)
                buffer[i] = 0;

            return Digest;
        }

        public string md5String()
        {
            string s = "";

            for (int i = 0; i < Digest.Length; i++)
                s += Digest[i].ToString("x2");

            return s;
        }

        #region Constants for MD5Transform routine.

        private const uint S11 = 7;
        private const uint S12 = 12;
        private const uint S13 = 17;
        private const uint S14 = 22;
        private const uint S21 = 5;
        private const uint S22 = 9;
        private const uint S23 = 14;
        private const uint S24 = 20;
        private const uint S31 = 4;
        private const uint S32 = 11;
        private const uint S33 = 16;
        private const uint S34 = 23;
        private const uint S41 = 6;
        private const uint S42 = 10;
        private const uint S43 = 15;
        private const uint S44 = 21;
        #endregion

        private void transform(byte[] data)
        {
            uint a = state[0];
            uint b = state[1];
            uint c = state[2];
            uint d = state[3];
            uint[] x = new uint[16];

            decode(ref x, data, 64);

            // Round 1
            FF(ref a, b, c, d, x[0], S11, 0xd76aa478); /* 1 */
            FF(ref d, a, b, c, x[1], S12, 0xe8c7b756); /* 2 */
            FF(ref c, d, a, b, x[2], S13, 0x242070db); /* 3 */
            FF(ref b, c, d, a, x[3], S14, 0xc1bdceee); /* 4 */
            FF(ref a, b, c, d, x[4], S11, 0xf57c0faf); /* 5 */
            FF(ref d, a, b, c, x[5], S12, 0x4787c62a); /* 6 */
            FF(ref c, d, a, b, x[6], S13, 0xa8304613); /* 7 */
            FF(ref b, c, d, a, x[7], S14, 0xfd469501); /* 8 */
            FF(ref a, b, c, d, x[8], S11, 0x698098d8); /* 9 */
            FF(ref d, a, b, c, x[9], S12, 0x8b44f7af); /* 10 */
            FF(ref c, d, a, b, x[10], S13, 0xffff5bb1); /* 11 */
            FF(ref b, c, d, a, x[11], S14, 0x895cd7be); /* 12 */
            FF(ref a, b, c, d, x[12], S11, 0x6b901122); /* 13 */
            FF(ref d, a, b, c, x[13], S12, 0xfd987193); /* 14 */
            FF(ref c, d, a, b, x[14], S13, 0xa679438e); /* 15 */
            FF(ref b, c, d, a, x[15], S14, 0x49b40821); /* 16 */

            // Round 2 
            GG(ref a, b, c, d, x[1], S21, 0xf61e2562); /* 17 */
            GG(ref d, a, b, c, x[6], S22, 0xc040b340); /* 18 */
            GG(ref c, d, a, b, x[11], S23, 0x265e5a51); /* 19 */
            GG(ref b, c, d, a, x[0], S24, 0xe9b6c7aa); /* 20 */
            GG(ref a, b, c, d, x[5], S21, 0xd62f105d); /* 21 */
            GG(ref d, a, b, c, x[10], S22, 0x2441453); /* 22 */
            GG(ref c, d, a, b, x[15], S23, 0xd8a1e681); /* 23 */
            GG(ref b, c, d, a, x[4], S24, 0xe7d3fbc8); /* 24 */
            GG(ref a, b, c, d, x[9], S21, 0x21e1cde6); /* 25 */
            GG(ref d, a, b, c, x[14], S22, 0xc33707d6); /* 26 */
            GG(ref c, d, a, b, x[3], S23, 0xf4d50d87); /* 27 */
            GG(ref b, c, d, a, x[8], S24, 0x455a14ed); /* 28 */
            GG(ref a, b, c, d, x[13], S21, 0xa9e3e905); /* 29 */
            GG(ref d, a, b, c, x[2], S22, 0xfcefa3f8); /* 30 */
            GG(ref c, d, a, b, x[7], S23, 0x676f02d9); /* 31 */
            GG(ref b, c, d, a, x[12], S24, 0x8d2a4c8a); /* 32 */

            // Round 3
            HH(ref a, b, c, d, x[5], S31, 0xfffa3942); /* 33 */
            HH(ref d, a, b, c, x[8], S32, 0x8771f681); /* 34 */
            HH(ref c, d, a, b, x[11], S33, 0x6d9d6122); /* 35 */
            HH(ref b, c, d, a, x[14], S34, 0xfde5380c); /* 36 */
            HH(ref a, b, c, d, x[1], S31, 0xa4beea44); /* 37 */
            HH(ref d, a, b, c, x[4], S32, 0x4bdecfa9); /* 38 */
            HH(ref c, d, a, b, x[7], S33, 0xf6bb4b60); /* 39 */
            HH(ref b, c, d, a, x[10], S34, 0xbebfbc70); /* 40 */
            HH(ref a, b, c, d, x[13], S31, 0x289b7ec6); /* 41 */
            HH(ref d, a, b, c, x[0], S32, 0xeaa127fa); /* 42 */
            HH(ref c, d, a, b, x[3], S33, 0xd4ef3085); /* 43 */
            HH(ref b, c, d, a, x[6], S34, 0x4881d05); /* 44 */
            HH(ref a, b, c, d, x[9], S31, 0xd9d4d039); /* 45 */
            HH(ref d, a, b, c, x[12], S32, 0xe6db99e5); /* 46 */
            HH(ref c, d, a, b, x[15], S33, 0x1fa27cf8); /* 47 */
            HH(ref b, c, d, a, x[2], S34, 0xc4ac5665); /* 48 */

            // Round 4
            II(ref a, b, c, d, x[0], S41, 0xf4292244); /* 49 */
            II(ref d, a, b, c, x[7], S42, 0x432aff97); /* 50 */
            II(ref c, d, a, b, x[14], S43, 0xab9423a7); /* 51 */
            II(ref b, c, d, a, x[5], S44, 0xfc93a039); /* 52 */
            II(ref a, b, c, d, x[12], S41, 0x655b59c3); /* 53 */
            II(ref d, a, b, c, x[3], S42, 0x8f0ccc92); /* 54 */
            II(ref c, d, a, b, x[10], S43, 0xffeff47d); /* 55 */
            II(ref b, c, d, a, x[1], S44, 0x85845dd1); /* 56 */
            II(ref a, b, c, d, x[8], S41, 0x6fa87e4f); /* 57 */
            II(ref d, a, b, c, x[15], S42, 0xfe2ce6e0); /* 58 */
            II(ref c, d, a, b, x[6], S43, 0xa3014314); /* 59 */
            II(ref b, c, d, a, x[13], S44, 0x4e0811a1); /* 60 */
            II(ref a, b, c, d, x[4], S41, 0xf7537e82); /* 61 */
            II(ref d, a, b, c, x[11], S42, 0xbd3af235); /* 62 */
            II(ref c, d, a, b, x[2], S43, 0x2ad7d2bb); /* 63 */
            II(ref b, c, d, a, x[9], S44, 0xeb86d391); /* 64 */

            state[0] += a;
            state[1] += b;
            state[2] += c;
            state[3] += d;

            for (int i = 0; i < 16; i++)
                x[i] = 0;
        }

        #region encode - decode
        private void encode(ref byte[] output, uint[] input, uint len)
        {
            uint i, j;
            if (System.BitConverter.IsLittleEndian)
            {
                for (i = 0, j = 0; j < len; i++, j += 4)
                {
                    output[j] = (byte)(input[i] & 0xff);
                    output[j + 1] = (byte)((input[i] >> 8) & 0xff);
                    output[j + 2] = (byte)((input[i] >> 16) & 0xff);
                    output[j + 3] = (byte)((input[i] >> 24) & 0xff);
                }
            }
            else
            {
                for (i = 0, j = 0; j < len; i++, j += 4)
                {
                    output[j + 3] = (byte)(input[i] & 0xff);
                    output[j + 2] = (byte)((input[i] >> 8) & 0xff);
                    output[j + 1] = (byte)((input[i] >> 16) & 0xff);
                    output[j] = (byte)((input[i] >> 24) & 0xff);
                }
            }
        }

        private void decode(ref uint[] output, byte[] input, uint len)
        {
            uint i, j;
            if (System.BitConverter.IsLittleEndian)
            {
                for (i = 0, j = 0; j < len; i++, j += 4)
                    output[i] = ((uint)input[j]) | (((uint)input[j + 1]) << 8) |
                        (((uint)input[j + 2]) << 16) | (((uint)input[j + 3]) << 24);
            }
            else
            {
                for (i = 0, j = 0; j < len; i++, j += 4)
                    output[i] = ((uint)input[j + 3]) | (((uint)input[j + 2]) << 8) |
                        (((uint)input[j + 1]) << 16) | (((uint)input[j]) << 24);
            }
        }
        #endregion

        private uint rotate_left(uint x, uint n)
        {
            return (x << (int)n) | (x >> (int)(32 - n));
        }

        #region F, G, H and I are basic MD5 functions.
        private uint F(uint x, uint y, uint z)
        {
            return (x & y) | (~x & z);
        }

        private uint G(uint x, uint y, uint z)
        {
            return (x & z) | (y & ~z);
        }

        private uint H(uint x, uint y, uint z)
        {
            return x ^ y ^ z;
        }

        private uint I(uint x, uint y, uint z)
        {
            return y ^ (x | ~z);
        }
        #endregion

        #region  FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4.
        private void FF(ref uint a, uint b, uint c, uint d, uint x, uint s, uint ac)
        {
            a += F(b, c, d) + x + ac;
            a = rotate_left(a, s) + b;
        }

        private void GG(ref uint a, uint b, uint c, uint d, uint x, uint s, uint ac)
        {
            a += G(b, c, d) + x + ac;
            a = rotate_left(a, s) + b;
        }

        private void HH(ref uint a, uint b, uint c, uint d, uint x, uint s, uint ac)
        {
            a += H(b, c, d) + x + ac;
            a = rotate_left(a, s) + b;
        }

        private void II(ref uint a, uint b, uint c, uint d, uint x, uint s, uint ac)
        {
            a += I(b, c, d) + x + ac;
            a = rotate_left(a, s) + b;
        }
        #endregion
    }
</script>
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>
        <asp:Localize ID="Localize1" Text="<%$ Res: PayOnline_PayResultYeepay_Page , 西部支付 %>"
            runat="server" /></title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <pe:ExtendedLabel HtmlEncode="false" ID="LblMsg" runat="server"></pe:ExtendedLabel>
        <asp:TextBox ID="TextBox1" runat="server"></asp:TextBox>
    </div>
    </form>
</body>
</html>
