﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ValidLog.ascx.cs" Inherits="PowerEasy.Module.General.WebSite.Controls.Common.ValidLog" %>
<pe:MemberExtendedGridView ID="EgvUserValid" runat="server" AllowPaging="True" AutoGenerateColumns="False"
    DataKeyNames="LogId" DataSourceID="OdsUserValid" ItemName="<%$ Res: Controls_PointLog_EgvUserPoint_ItemName , 记录 %>"
    ItemUnit="<%$ Res: Controls_PointLog_EgvUserPoint_ItemUnit , 条 %>" OnRowDataBound="EgvUserValid_RowDataBound">
    <Columns>
        <pe:BoundField DataField="LogTime" HeaderText="<%$ Res: Controls_PointLog_BoundField1 , 时间 %>"
            DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" SortExpression="LogTime" HtmlEncode="False">
            <HeaderStyle Width="17%" />
        </pe:BoundField>
        <pe:TemplateField HeaderText="<%$ Res: Controls_ValidLog_TemplateField1 , 用户名 %>">
            <HeaderStyle Width="10%" />
            <ItemTemplate>
                <asp:HyperLink runat="server" ID="HypUserName"></asp:HyperLink>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:BoundField DataField="IP" HeaderText="<%$ Res: Controls_PointLog_BoundField2 , IP地址 %>"
            SortExpression="IP">
            <HeaderStyle Width="13%" />
        </pe:BoundField>
        <pe:TemplateField HeaderText="<%$ Res: Controls_PointLog_BoundField5 , 增加 %>" SortExpression="IncomePayout">
            <HeaderStyle Width="8%" />
            <ItemTemplate>
                <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="labIncome">
                </pe:ExtendedLabel>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="<%$ Res: Controls_PointLog_BoundField6 , 扣除 %>" SortExpression="IncomePayout">
            <HeaderStyle Width="8%" />
            <ItemTemplate>
                <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="labPayOut">
                </pe:ExtendedLabel>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:BoundField DataField="Inputer" HeaderText="<%$ Res: Controls_PointLog_BoundField4 , 操作员 %>"
            SortExpression="Inputer">
            <HeaderStyle Width="10%" />
        </pe:BoundField>
        <pe:TemplateField HeaderText="<%$ Res: Controls_ValidLog_TemplateField3 , 备注/说明 %>">
            <ItemStyle HorizontalAlign="Left" />
            <ItemTemplate>
                <asp:Label ID="labRemark" runat="server"></asp:Label>
            </ItemTemplate>
        </pe:TemplateField>
    </Columns>
</pe:MemberExtendedGridView>
<asp:HiddenField ID="HdnSearchType" runat="server" />
<asp:HiddenField ID="HdnField" runat="server" />
<asp:HiddenField ID="HdnKeyword" runat="server" />
<asp:HiddenField ID="HdnType" runat="server" />
<asp:ObjectDataSource ID="OdsUserValid" runat="server" SelectMethod="GetValidList"
    SelectCountMethod="GetNumberOfValidList" TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.UserValidLog"
    EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
    <SelectParameters>
        <asp:ControlParameter ControlID="HdnSearchType" DefaultValue="-1" Name="scopesType"
            Type="Int32" />
        <asp:ControlParameter ControlID="HdnField" DefaultValue="0" Name="field" Type="Int32" />
        <asp:ControlParameter ControlID="HdnKeyword" DefaultValue="" Name="keyword" Type="String" />
        <asp:ControlParameter ControlID="HdnType" DefaultValue="-1" Name="type" Type="Int32" />
    </SelectParameters>
</asp:ObjectDataSource>
