﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ShowMessageList.ascx.cs"
    Inherits="PowerEasy.Module.General.WebSite.Controls.Common.ShowMessageList" %>
<pe:MemberExtendedGridView ID="GdvMessageList" runat="server" DataKeyNames="MessageId"
    AllowPaging="True" ItemName="<%$ Res: Controls_ShowMessageList_GdvMessageList_ItemName ,短消息 %>"
    AutoGenerateColumns="False" AutoGenerateCheckBoxColumn="True" OnRowDataBound="GdvMessageList_RowDataBound"
    OnRowCommand="GdvMessageList_RowCommand" OnPageIndexChanging="GdvMessageList_PageIndexChanging"
    DataSourceID="OdsMessageList" CheckBoxFieldHeaderWidth="3%" SerialText="" OnDataBound="GdvMessageList_DataBound">
    <Columns>
        <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField1 ,短消息主题 %>"
            ShowHeader="False">
            <ItemStyle CssClass="content_left"/>
            <ItemTemplate>
                <asp:HyperLink runat="server" ID="HlnkMessage" Text='<%# Eval("Title") %>' NavigateUrl='<%# Eval("MessageID","MessageRead.aspx?MessageID={0}") %>'></asp:HyperLink></ItemTemplate>
        </pe:TemplateField>
        <pe:BoundField DataField="Incept" HeaderText="<%$ Res: Controls_ShowMessageList_BoundField1 ,收件人 %>" />
        <pe:BoundField DataField="Sender" HeaderText="<%$ Res: Controls_ShowMessageList_BoundField2 ,发件人 %>" />
        <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField2 ,发送日期 %>"
            SortExpression="SendTime">
            <ItemTemplate>
                <%# Eval("SendTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField3 ,大小 %>"
            SortExpression="Content">
            <ItemStyle HorizontalAlign="Right" />
            <ItemTemplate>
                <%# Eval("Content").ToString().Length +" Byte"%>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField4 ,已读 %>">
            <ItemTemplate>
                <%# Convert.ToInt32(Eval("IsRead")) == 0 ? "<font color=red>×</font>" : "√"%>
            </ItemTemplate>
        </pe:TemplateField>
        <pe:TemplateField HeaderText="<%$ Res: Controls_ShowMessageList_TemplateField5 ,操作 %>">
            <ItemTemplate>
                <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("MessageID") %>'
                    CommandName="Del" OnClientClick='<%$ Res: Controls_ShowMessageList_LbtnDelete_OnClientClick ,return confirm("是否删除此短消息?") %>'
                    Text="<%$ Res: Controls_ShowMessageList_LbtnDelete ,删除 %>"></asp:LinkButton>
            </ItemTemplate>
        </pe:TemplateField>
    </Columns>
</pe:MemberExtendedGridView>
<br />
<input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><asp:Localize
    ID="Localize1" Text="<%$ Res: Controls_ShowMessageList_Localize1 ,选中本页显示的所有短消息 %>"
    runat="server" />
<asp:Button ID="BtnDelete" runat="server" CssClass="input_button_eight" Text="<%$ Res: Controls_ShowMessageList_BtnDelete ,删除选定的短消息 %>"
    OnClientClick='<%$ Res: Controls_ShowMessageList_BtnDelete_OnClientClick ,return confirm("是否删除所选定的短消息?") %>'
    OnClick="BtnDelete_Click" CausesValidation="False" />
<asp:Button ID="BtnDeleteAll" CssClass="input_button" runat="server" Text="Button"
    OnClick="BtnDeleteAll_Click" OnClientClick="<%$ Res: Controls_ShowMessageList_BtnDeleteAll_OnClientClick ,return confirm('确定要清空短消息吗？') %>" />&nbsp;<br />
<asp:HiddenField ID="HdnSearchField" runat="server" />
<asp:HiddenField ID="HdnKeyword" runat="server" />
<asp:ObjectDataSource ID="OdsMessageList" runat="server" SelectMethod="GetMessageList"
    SelectCountMethod="Count" TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.Message"
    EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
    <SelectParameters>
        <asp:ControlParameter ControlID="HdnSearchField" DefaultValue="0" Name="searchField"
            PropertyName="Value" />
        <asp:ControlParameter ControlID="HdnKeyword" DefaultValue="" Name="keyword" PropertyName="Value" />
    </SelectParameters>
</asp:ObjectDataSource>
<asp:HiddenField ID="HdnManageType" runat="server" Value="0" />
