﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/MasterPage.master"
    CodeBehind="WorkCategory.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Work.WorkCategoryUI" Title="表单类别添加/修改" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">

    <script language="JavaScript" type="text/JavaScript">
        var tID = 0;
        var arrTabTitle = new Array("TabTitle0", "TabTitle1");
        var arrTrs0 = new Array("TabsWork");
        var arrTrs1 = new Array("TabsCustomForm");
        var arrTab = new Array(arrTrs0, arrTrs1);

        function ShowTabs(ID) {
            if (ID != tID) {
                document.getElementById(arrTabTitle[tID].toString()).className = "tabtitle";
                document.getElementById(arrTabTitle[ID].toString()).className = "titlemouseover";

                for (var i = 0; i < arrTab.length; i++) {
                    var tab = arrTab[i];
                    if (i == ID) {
                        for (var j = 0; j < tab.length; j++) {
                            document.getElementById(tab[j].toString()).style.display = "";
                        }
                    }
                    else {
                        for (var j = 0; j < tab.length; j++) {
                            document.getElementById(tab[j].toString()).style.display = "none";
                        }
                    }
                }

                tID = ID;
            }
        }
    </script>

    <table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr align="center">
            <td colspan="3" class="spacingtitle">
                <pe:AlternateLiteral ID="AltrTitle" Text="添加表单类别" AlternateText="修改表单类别" runat="Server" />
            </td>
        </tr>
        <tr align="center">
            <td id="TabTitle0" class="titlemouseover" onclick="ShowTabs(0)">
                基本信息
            </td>
            <td id="TabTitle1" class="tabtitle" onclick="ShowTabs(1)">
                绑定表单
            </td>
            <td>
                &nbsp;
            </td>
        </tr>
    </table>
    <table style="width: 100%; margin: 0 auto;" cellpadding="2" cellspacing="1" class="border">
        <tbody id="TabsWork">
            <tr class="tdbg" id="TrParentPath" visible="false" runat="server">
                <td align="right" style="width: 28%">
                    <strong>所属类别：</strong>
                </td>
                <td>
                    <asp:Literal ID="LitParentPath" runat="server"></asp:Literal>
                </td>
            </tr>
            <tr class="tdbg">
                <td align="right" style="width: 28%" class="tdbgleft">
                    <strong>类别名称：</strong>
                </td>
                <td>
                    <asp:TextBox ID="TxtName" runat="server" Width="220px" MaxLength="20" />
                    <pe:RequiredFieldValidator ID="ValrBankShortName" runat="server" ControlToValidate="TxtName"
                        ErrorMessage="类别名称不能为空！" SetFocusOnError="true" Display="Dynamic" />
                </td>
            </tr>
            <tr class="tdbg">
                <td align="right" style="width: 28%" class="tdbgleft">
                    <strong>类别描述：</strong>
                </td>
                <td>
                    <asp:TextBox ID="TxtDescription" runat="server" TextMode="MultiLine" Columns="60"
                        Height="100" />
                </td>
            </tr>
            <tr class="tdbg">
                <td align="right" style="width: 28%" class="tdbgleft">
                    <strong>工作流：</strong>
                    <asp:PlaceHolder ID="WorkFlowTips" Visible="false" runat="server">
                        <br />
                        <span style="color: Blue">注：修改后只对新添加、新修改的表单数据启用新的工作流</span></asp:PlaceHolder>
                </td>
                <td>
                    <asp:DropDownList ID="DropWorkFlow" DataTextField="FlowName" DataValueField="FlowId"
                        runat="server" AppendDataBoundItems="true">
                        <asp:ListItem Text="请选择" Value="-1"></asp:ListItem>
                    </asp:DropDownList>
                </td>
            </tr>
        </tbody>
        <tbody id="TabsCustomForm" style="display: none">
            <tr class="tdbg">
                <td>
                    <asp:Repeater ID="RepCustomFormTemplate" runat="server" OnItemDataBound="RepCustomFormTemplate_ItemDataBound">
                        <HeaderTemplate>
                            <table width="100%">
                                <tr class="tdbg">
                                    <td align="left">
                                        <strong>选择自定义表单</strong>
                                    </td>
                                    <td align="left">
                                        <strong>选择自定义表单对应的表单布局模板</strong>
                                    </td>
                                </tr>
                        </HeaderTemplate>
                        <ItemTemplate>
                            <tr>
                                <td class="tdbgleft">
                                    <asp:CheckBox ID="ChkModel" Text='<%# Eval("ModelName") %>' runat="server" /><asp:HiddenField
                                        ID="HdnModelId" runat="server" Value='<%# Eval("ModelId") %>' />
                                </td>
                                <td style="width: 65%" align="left">
                                    前台表单布局模板：<pe:TemplateSelectControl ID="FileCUserTemplate" Width="300px" runat="server"></pe:TemplateSelectControl><br />
                                    后台数据查看模板：<pe:TemplateSelectControl ID="FileCAdminViewTemplate" Width="300px" runat="server"></pe:TemplateSelectControl><br />
                                    后台表单布局模板：<pe:TemplateSelectControl ID="FileCAdminTemplate" Width="300px" runat="server"></pe:TemplateSelectControl>
                                </td>
                            </tr>
                        </ItemTemplate>
                        <FooterTemplate>
                            </table></FooterTemplate>
                    </asp:Repeater>
                </td>
            </tr>
        </tbody>
        <tr class="tdbgbottom">
            <td colspan="2">
                <pe:AlternateButton ID="BtnSubmit" runat="server" Text="保存表单类别" AlternateText="修改表单类别"
                    OnClick="BtnSubmit_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
