﻿<%@ Page Title="WAP内容管理" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="WapContentManage.aspx.cs" Inherits="PowerEasy.Module.Wap.WebSite.Admin.Wap.WapContentManage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:Bookmarks ID="bookmark" runat="server" ControlID="HdnStatus" ExtendedGridViewID="egvWapContent">
        <pe:BookmarkItem Title="所有内容" Value="100"></pe:BookmarkItem>
        <pe:BookmarkItem Title="草稿" Value="-1"></pe:BookmarkItem>
        <pe:BookmarkItem Title="待审核" Value="0"></pe:BookmarkItem>
        <pe:BookmarkItem Title="已审核" Value="99"></pe:BookmarkItem>
    </pe:Bookmarks>
    <pe:ExtendedGridView ID="egvWapContent" runat="server" DataSourceID="odsWapContent"
        AutoGenerateCheckBoxColumn="True" AutoGenerateColumns="False" AllowPaging="true"
        SerialText="" OnRowDataBound="egvWapContent_RowDataBound" OnRowCommand="egvWapContent_RowCommand"
        RowDblclickUrl="WapContent.aspx?action=modify&articleId={$Field}" DataKeyNames="WapArticleId"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True" RowDblclickBoundField="WapArticleId">
        <Columns>
            <asp:BoundField DataField="WapArticleId" HeaderText="ID" HeaderStyle-Width="4%" />
            <asp:TemplateField HeaderText="操作" HeaderStyle-Width="70px" ItemStyle-Width="70px">
                <ItemTemplate>
                    <pe:DropdownMenu runat="server" ID="ddmenu" ShowShortcut="true">
                        <pe:LinkMenuItem ID="ContentModify" SkinID="Edit" runat="server" />
                        <pe:ButtonMenuItem ID="ContentDelete" SkinID="Delete" runat="server" CommandName="delete"
                            OnClientClick="return confirm('确定要删除选中的项目吗？');" CommandArgument='<%# Eval("WapArticleId") %>' />
                        <pe:ButtonMenuItem ID="BMPass" Text="审核通过" runat="server" Visible="false" OnClick="EBtnPass_Click" />
                        <pe:ButtonMenuItem ID="BMCancelPass" Text="取消审核" runat="server" Visible="false" OnClick="EBtnCancelPass_Click" />
                        <pe:LinkMenuItem ID="ContentPreview" Target="_blank" Text="前台预览" runat="server" />
                    </pe:DropdownMenu>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="标题" SortExpression="Title">
                <ItemTemplate>
                    <pe:ExtendedHyperLink ID="LnkCategoryLink" runat="server" />
                    <pe:ExtendedHyperLink ID="HypTitle" runat="server" />
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:BoundField DataField="inputer" HeaderText="录入人" HeaderStyle-Width="14%" />
            <asp:TemplateField HeaderText="状态" HeaderStyle-Width="20%">
                <ItemTemplate>
                    <asp:Literal ID="ltrStatus" runat="server"></asp:Literal>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnStatus" runat="server" Value="100" />
    <asp:HiddenField ID="HdnSearchType" runat="server" Value="" />
    <asp:HiddenField ID="HdnSearchKeyword" runat="server" Value="" />
    <asp:HiddenField ID="HdnWapCategoryId" runat="server" Value="-1" />
    <asp:ObjectDataSource ID="odsWapContent" runat="server" SelectMethod="GetList" SelectCountMethod="GetTotalOfWapArticle"
        TypeName="PowerEasy.Module.Wap.BusinessLogic.WapArticle" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
        StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnStatus" Type="Int32" Name="status" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnSearchType" Type="String" Name="searchType" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnSearchKeyword" Type="String" Name="keyword" PropertyName="Value" />
            <asp:QueryStringParameter Type="Int32" Name="wapCategoryId" DefaultValue="-1" QueryStringField="wapCategoryId" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <table border="0" cellpadding="0" cellspacing="1" style="width: 100%; height: 100%;">
        <tr>
            <td style="width: 170px;">
                <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
                    for="ChkAll">选中本页显示的所有项目</label>
            </td>
            <td>
                <asp:Button ID="EBtnBatchDelete" Text="批量删除" Width="115" OnClientClick="return batchconfirm('确定要删除选中的项目吗？');"
                    OnClick="EBtnBatchDelete_Click" CausesValidation="False" runat="server" />
                <asp:Button ID="EBtnPass" Text="审核通过" Width="115" runat="server" OnClick="EBtnPass_Click" />
                <asp:Button ID="EBtnCancelPass" Text="取消审核" Width="115" runat="server" OnClick="EBtnCancelPass_Click" />
            </td>
        </tr>
    </table>
    <br />
    <table style="width: 100%;" cellpadding="2" cellspacing="1" class="border">
        <tr>
            <td style="width: 80px" align="left" class="tdbg">
                <b>搜索选项：</b>
            </td>
            <td class="tdbg">
                <asp:DropDownList ID="DrpSearchType" runat="server">
                    <asp:ListItem Value="ID" Text="ID" />
                    <asp:ListItem Value="Title" Text="内容标题" Selected="True" />
                    <asp:ListItem Value="Inputer" Text="录入人" />
                </asp:DropDownList>
                <asp:TextBox ID="TxtSearchKeyword" onkeypress="javascript:return DefaultButton(event)"
                    runat="server" />
                <asp:Button ID="BtnSearch" runat="server" Text="搜索" OnClick="BtnSearch_Click" />&nbsp;
            </td>
        </tr>
    </table>

    <script language="javascript" type="text/javascript">
        function ShowHash() {
            parent.jQuery("#newFrameTab").click();
            var d = jQuery(parent.document);
            d.find("#main_right").attr("src", "<%=BasePath%><%= PowerEasy.Foundation.SiteConfig.SiteOption.ManageDir %>/Contents/ContentHashProgress.aspx?IsShow=true");
        }

        function Check(id) {
            checkBoxes = document.getElementsByTagName("input");
            for (var i = 0; i < checkBoxes.length; i++) {
                if (checkBoxes[i].type == "checkbox") {
                    checkBoxes[i].checked = false;
                }
            }
            document.getElementById(id).checked = true;
            if (document.getElementById(id).checked) {
                return true;
            }
            else {
                return false;
            }
        }
        function DefaultButton(event) {
            if (event.keyCode == 13 && !(event.srcElement && (event.srcElement.tagName.toLowerCase() == "textarea"))) {
                var defaultButton = document.getElementById('<%= BtnSearch.ClientID %>');
                if (defaultButton && typeof (defaultButton.click) != "undefined") {
                    defaultButton.click();
                    event.cancelBubble = true;
                    if (event.stopPropagation)
                        event.stopPropagation();
                    return false;
                }
            }
            return true;
        }
    </script>

</asp:Content>
