﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/MasterPage.master"
    CodeBehind="DepartmentManage.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.User.DepartmentManage"
    Title="部门管理" ValidateRequest="false"%>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <table border='0' cellpadding='0' cellspacing='0' width='100%'>
        <tr>
            <td align="left">
                <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
                <div style="padding-top: 5px;">
                </div>
            </td>
            <td align="right">
                <asp:DropDownList ID="DropDownList1" runat="server" AutoPostBack="true" OnSelectedIndexChanged="OnSelectedChanged">
                 <asp:ListItem Text="ID降序排列" Value="0"></asp:ListItem>
                 <asp:ListItem Text="ID升序排列" Value="1"></asp:ListItem>
                 <asp:ListItem Text="权重降序排列" Value="2" Selected="True"></asp:ListItem>
                 <asp:ListItem Text="权重升序排列" Value="3"></asp:ListItem>
                </asp:DropDownList>
            </td>
        </tr>
    </table>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="EgvDepartment" runat="server" AutoGenerateCheckBoxColumn="True"
        ItemName="部门" ItemUnit="个" AutoGenerateColumns="False" DataKeyNames="DepartmentId"
        AllowPaging="True" DataSourceID="OdsDepartment" RowDblclickBoundField="DepartmentId"
        OnRowCommand="EgvDepartment_RowCommand" RowDblclickUrl="Department.aspx?Action=Modify&amp;DepartmentId={$Field}"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True" SerialText="" 
        OnRowDataBound="EgvDepartment_DataBound">
        <Columns>
            <asp:BoundField DataField="DepartmentId" HeaderText="ID" SortExpression="ShortedForm">
                <HeaderStyle Width="7%" />
                <ItemStyle Width="7%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="部门名称">
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="ExtendedAnchor3" IsChecked="true" runat="server" OperateCode="GVDepartmentManage"
                        href='<%#managePath+string.Format("/User/Department.aspx?Action=Modify&DepartmentId={0}",Eval("DepartmentId")) %>'>
                        <%#Eval("DepartmentName")%></pe:ExtendedAnchor>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
            </asp:TemplateField>
            <asp:TemplateField>
             <HeaderTemplate>
              部门成员
             </HeaderTemplate>
             <ItemTemplate>
              <asp:Label ID="adminmemenber" runat="server"></asp:Label>
             </ItemTemplate>
             <ItemStyle Width="25%"/>
            </asp:TemplateField>
            <asp:BoundField DataField="CategoryName" HeaderText="所属类别" SortExpression="CategoryName">
                <HeaderStyle Width="100px" />
            </asp:BoundField>
            <asp:BoundField DataField="Priority" HeaderText="权重" SortExpression="Priority">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="EArDepartmentPublicInfo" runat="server" href='<%#managePath+string.Format("/User/DepartmentMembers.aspx?DepartmentId={0}",Eval("DepartmentId")) %>'
                        IsChecked="true" OperateCode="GVDepartmentManage">
                        设置成员</pe:ExtendedAnchor>
                    <pe:ExtendedAnchor ID="ModifyOwn" runat="server" href='<%#managePath+string.Format("/User/Department.aspx?Action=Modify&DepartmentId={0}",Eval("DepartmentId")) %>'
                        IsChecked="true" OperateCode="GVDepartmentManage">
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("DepartmentId") %>'
                        CommandName="Del" IsChecked="true" OnClientClick="return confirm('删除该部门将删除该部门所有相关数据，确定要删除此部门吗？')"
                        OperateCode="GVDepartmentManage">删除</pe:ExtendedLinkButton>
                    <a href="<%= BasePath %>Common/DepartmentInfo.aspx?departmentId=<%#Eval("DepartmentId")%>" target="_blank">前台预览</a>
                </ItemTemplate>
                <HeaderStyle Width="20%" />
                <ItemStyle Wrap="false" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnCategoryName" runat="server" Value="All" />
    <asp:HiddenField ID="HdnSearchType" runat="server" />
    <asp:HiddenField ID="HdnSearchKeyword" runat="server" />
    <asp:HiddenField ID="Sorts" runat="server" Value="2"/>
    <asp:HiddenField ID="HdnParentId" runat="server" />
    <asp:ObjectDataSource ID="OdsDepartment" runat="server" 
        SelectMethod="GetListBySort" TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.Department"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows" SelectCountMethod="GetTotalOfDepartment">
        <SelectParameters>
            <asp:QueryStringParameter Name="categoryName" QueryStringField="CategoryName" Type="String" />
            <asp:ControlParameter ControlID="HdnSearchType" Type="String" Name="searchType" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnSearchKeyword" Type="String" Name="searchKeyword" PropertyName="Value" />
            <asp:ControlParameter ControlID="Sorts" Type="Int32" Name="sort" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnParentId" Type="Int32" Name="parentId" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <table id="TabDelete" runat="server" border="0" cellpadding="0" cellspacing="1" style="width: 100%;
        height: 100%;">
        <tr>
            <td style="width: 170px;">
                <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
                    for="ChkAll">选中本页显示的所有项目</label>
            </td>
            <td>
                <pe:ExtendedButton IsChecked="true" OperateCode="GVDepartmentManage" ID="BtnDelete"
                    runat="server" OnClientClick="return batchconfirm('删除该部门将删除该部门所有相关数据，确定要删除此部门吗？')"
                    Text="删除选中的部门" OnClick="BtnDelete_Click" />
                <asp:Button ID="BtnAddDepartment" runat="server" OnClick="BtnAddDepartment_click" Text="添加部门"/>
            </td>
        </tr>
    </table>
    <br />
    <table id="TabSearch" runat="server" style="width: 100%;" cellpadding="2" cellspacing="1"
        class="border">
        <tr>
            <td style="width: 80px" align="left" class="tdbg">
                <b>搜索选项：</b>
            </td>
            <td class="tdbg">
                <select id="SelectSearchType" onchange="ChangeHdnValue(this)">
                    <option value="1">部门名称</option>
                    <option value="2">部门ID</option>
                </select>
                <asp:HiddenField ID="HdnSearchTypeValue" Value="1" runat="server" />
                <asp:HiddenField ID="HdnSearchTypeText" Value="部门名称" runat="server" />
                <asp:TextBox ID="TxtSearchKeyword" runat="server" onkeypress="javascript:return DefaultButton(event)" />
                <asp:Button ID="BtnSearch" runat="server" ValidationGroup="VGroupSearch" Text="搜索"
                    OnClick="BtnSearch_Click" />
            </td>
        </tr>
    </table>

    <script language="javascript" type="text/javascript">
        ChangeHdnValue(document.getElementById("SelectSearchType"));
        function ChangeHdnValue(sel) {
            if (sel != null) {
                var hdnValue = document.getElementById("<%=HdnSearchTypeValue.ClientID %>");
                var hdnText = document.getElementById("<%=HdnSearchTypeText.ClientID %>");
                hdnValue.value = sel.options[sel.selectedIndex].value;
                hdnText.value = sel.options[sel.selectedIndex].text;
            }
        }

        function DefaultButton(event) {
            if (event.keyCode == 13 && !(event.srcElement && (event.srcElement.tagName.toLowerCase() == "textarea"))) {
                var defaultButton = document.getElementById('<%= BtnSearch.ClientID %>');
                if (defaultButton && typeof (defaultButton.click) != "undefined") {
                    defaultButton.click();
                    event.cancelBubble = true;
                    if (event.stopPropagation)
                        event.stopPropagation();
                    return false;
                }
            }
            return true;
        }
    </script>

</asp:Content>
