﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.General.WebSite.Admin.User.CardsManage" Title="充值卡管理" Codebehind="CardsManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
  <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                          <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="-1" onclick="ShowBookmarks"><span>所有</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitUnUse" />> 
                        <asp:LinkButton ID="LinkUnUse" runat="server" CommandArgument="1" onclick="ShowBookmarks"><span>未使用</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitUse" />>    
                       <asp:LinkButton ID="LinkUse" runat="server" CommandArgument="2" onclick="ShowBookmarks"><span>已使用</span></asp:LinkButton>
                    </li>
                     <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitLost" />>    
                        <asp:LinkButton ID="LinkLost" runat="server" CommandArgument="3" onclick="ShowBookmarks"><span>已失效</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvCards" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        AutoGenerateCheckBoxColumn="True" DataKeyNames="CardId" ItemName="充值卡" ItemUnit="个"
        DataSourceID="OdsCards" OnRowDataBound="EgvCards_RowDataBound" OnRowDeleting="EgvCards_RowDeleting"
        CheckBoxFieldHeaderWidth="3%" SerialText="" OnDataBound="EgvCards_DataBound"
        RowDblclickBoundField="CardId" 
        RowDblclickUrl="CardModify.aspx?CardId={$Field}">
        <Columns>
            <pe:TemplateField HeaderText="类型" SortExpression="CardType" />
            <pe:TemplateField HeaderText="卡号">
                <ItemTemplate>
                    <a href='<%# Eval("CardId", "CardShow.aspx?CardId={0}") %>'>
                        <%# Eval("CardNum") %>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="面值" DataField="Money" DataFormatString="{0:0.00}元" HtmlEncode="False"
                SortExpression="Money" />
            <pe:TemplateField HeaderText="点数" SortExpression="ValidNum" />
            <pe:BoundField HeaderText="截止日期" DataField="EndDate" DataFormatString="{0:yyyy-MM-dd}"
                HtmlEncode="False" SortExpression="EndDate" />
            <pe:TemplateField HeaderText="所属商品" SortExpression="ProductName" />
            <pe:TemplateField HeaderText="状态" />
            <pe:TemplateField HeaderText="使用者">
                <ItemTemplate>
                      <a href='../User/UserShow.aspx?UserName=<%#Eval("UserName") %>'><%# Eval("UserName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="充值时间" DataField="UseTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
                HtmlEncode="False" SortExpression="UseTime" />
            <pe:TemplateField HeaderText="代理商">
                <ItemTemplate>
                     <%# Eval("AgentName")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <%--<a href='<%# Eval("CardId", "CardModify.aspx?CardId={0}") %>'></a>--%>
                    <%--  <asp:LinkButton  ID="LBtnModify" runat="server" CommandName="Modify" Text="修改"/>--%>
                    <asp:HyperLink Text="修改" runat="server" ID="HlnkModify" NavigateUrl='<%# Eval("CardId", "CardModify.aspx?CardId={0}") %>' />
                    <asp:LinkButton ID="LBtnDelete" runat="server" OnClientClick="return confirm('确定要删除此充值卡吗？')"
                        CommandName="Delete">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnCardTypes" runat="server" Value="-1" />
    <asp:ObjectDataSource ID="OdsCards" runat="server" SelectMethod="GetCardList" TypeName="PowerEasy.Module.General.BusinessLogic.Accessories.Cards"
        EnablePaging="True" MaximumRowsParameterName="maxiNumRows" SelectCountMethod="GetTotalofCards"
        StartRowIndexParameterName="startRowIndexId" DeleteMethod="DelCard">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="-1" Name="cardType" QueryStringField="CardType"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="-1" Name="cardStatus" QueryStringField="CardStatus"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="1" Name="field" QueryStringField="Field"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="Keyword"
                Type="String" />
            <asp:QueryStringParameter Name="agentName" QueryStringField="AgentName" Type="String" />
            <asp:ControlParameter ControlID="HdnCardTypes" Type="Int32" Name="status" PropertyName="Value"/>
        </SelectParameters>
        <DeleteParameters>
            <asp:ControlParameter ControlID="EgvCards" Name="cardId" PropertyName="SelectedValue"
                Type="Int32" />
        </DeleteParameters>
    </asp:ObjectDataSource>
    <br />
    <asp:Button ID="BtnDel" runat="server" OnClick="BtnDel_Click" Text="删除选中的充值卡" OnClientClick="return batchconfirm('确定要删除指定的充值卡吗？')" />
    <pe:OneClickButton ID="BtnExportExcel" runat="server" OnClick="BtnExportExcel_Click" Text="导出到EXCEL" IsOneClick="false" />
    <br />
    <div id="prompt-note">
        <dl>
        <dt class="prompt-note-tit">
        <span>提示说明</span>
        </dt>
        <dd class="prompt-note-con">
            <ul>
                <li>通过商店销售的充值卡有四种状态：未售出、已售出、已使用、已失效</li>
                <li><span style="color: blue">不</span>通过商店销售的充值卡有三种状态：未使用、已使用、已失效</li>
                <li>已经售出或已经使用过的充值卡将不能修改和删除</li>
            </ul>
        </dd>  
       </dl>
    </div>

</asp:Content>
