﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="CodeSnippetManage.aspx.cs" ValidateRequest="false" Inherits="PowerEasy.Module.General.WebSite.Admin.Template.CodeSnippetManageUI"
    Title="代码段管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
    <br />
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr class="title">
            <td style="width: 88px">
                <strong>分类列表：</strong>
            </td>
            <td align="left">
                <a href="CodeSnippetManage.aspx">显示全部</a>
                <asp:Repeater ID="Repeater1" runat="server" DataSourceID="OdsCodeSnippetType">
                    <ItemTemplate>
                        | <a href="CodeSnippetManage.aspx?Type=-1&Category=<%# Server.UrlEncode(Container.DataItem.ToString()) %>">
                            <%# Container.DataItem.ToString()%>
                        </a>
                    </ItemTemplate>
                </asp:Repeater>
                <asp:ObjectDataSource ID="OdsCodeSnippetType" runat="server" SelectMethod="GetCodeSnippetCategoryList"
                    TypeName="PowerEasy.Module.General.BusinessLogic.Templates.CodeSnippetManage"></asp:ObjectDataSource>
            </td>
        </tr>
    </table>
    <br />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="GdvCodeSnippetList" AutoGenerateColumns="False" runat="server"
        DataSourceID="OdsCodeSnippet" DataKeyNames="name" AllowPaging="True" ItemName="代码段"
        ItemUnit="条" AutoGenerateCheckBoxColumn="True" PageSize="20" CheckBoxFieldHeaderWidth="3%"
        SerialText="" OnRowCommand="GdvCodeSnippetListRowCommand">
        <Columns>
            <pe:TemplateField HeaderText="名称">
                <ItemTemplate>
                    <asp:HiddenField ID="Hdn" runat="server" Value='<%# Eval("FullName") %>' />
                    <a href="CodeSnippet.aspx?Action=Modify&FullName=<%# Server.UrlEncode(Eval("FullName").ToString()) %>">
                        <span runat="server" id="spanLabelName">
                            <%# Eval("Name").ToString() %></span> </a>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
            </pe:TemplateField>
            <pe:BoundField DataField="Category" HeaderText="分类" SortExpression="Category">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:BoundField DataField="UpdateTime" HeaderText="更新时间" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
                SortExpression="UpdateTime" HtmlEncode="False">
                <HeaderStyle Width="18%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <a href="CodeSnippet.aspx?Action=Modify&FullName=<%# Server.UrlEncode(Eval("FullName").ToString()) %>">
                        修改</a>
<%--                    <asp:LinkButton ID="LbtnCopy" runat="server" CausesValidation="False" CommandArgument='<%# Eval("FullName") %>'
                        CommandName="Copy">复制</asp:LinkButton>--%>
                    <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("FullName") %>'
                        CommandName="Remove" OnClientClick="return confirm('是否删除本代码段？')">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <asp:Button ID="BtnDel" runat="server" Text="批量删除选定的代码段" CausesValidation="False"
        OnClientClick="return batchconfirm('确实要删除选中的代码段？');" OnClick="BtnDel_Click" />&nbsp;&nbsp;<asp:Button
            ID="BtnAdd" runat="server" Text="增加一个新的代码段" OnClick="BtnAdd_Click" />
    <asp:ObjectDataSource ID="OdsCodeSnippet" runat="server" TypeName="PowerEasy.Module.General.BusinessLogic.Templates.CodeSnippetManage"
        SelectMethod="GetCodeSnippetList">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="type" QueryStringField="type" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="field" Type="Int32" QueryStringField="Field" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" Type="string" QueryStringField="Keyword" />
            <asp:QueryStringParameter DefaultValue="" Name="category" Type="string" QueryStringField="Category" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
