﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="CodeSnippet.aspx.cs" ValidateRequest="false" Inherits="PowerEasy.Module.General.WebSite.Admin.Template.CodeSnippet"
    Title="代码段" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server" EnableViewState="true">
    <asp:ScriptManager ID="ScriptManager1" runat="server" EnablePartialRendering="true" />
    <table style="width: 100%; margin: 0 auto;" cellpadding="2" cellspacing="1" class="border">
        <tr>
            <td class="spacingtitle" colspan="4" align="center">
                <span id="SpanTitle" style="font-weight: bold;" runat="server">添加代码段</span>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right" style="width: 105px">
                <strong>代码段名称：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left" style="width: 330px">
                <asp:TextBox ID="TxtName" runat="server" Width="288px" />
                <pe:RequiredFieldValidator runat="server" ID="NReq" ControlToValidate="TxtName" Display="Dynamic"
                    ErrorMessage="请输入代码段名称" />
                    <pe:RegexValidator runat="server" ID="ValrTxtName" ValidateType="FileName" ControlToValidate="TxtName" Display="Dynamic" />
            </td>
            <td colspan="2" rowspan="3">
                <asp:TextBox ID="TxtContent" runat="server" Width="98%" Height="180px" TextMode="MultiLine"></asp:TextBox>
                <pe:RequiredFieldValidator runat="server" ID="RequiredFieldValidator1" ControlToValidate="TxtContent"
                    Display="Dynamic" ErrorMessage="请输入代码段内容" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right" style="width: 105px">
                <strong>代码段分类：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left" style="width: 330px">
                <asp:TextBox ID="TxtCategory" runat="server" Width="180px"></asp:TextBox>
                <pe:RequiredFieldValidator runat="server" ID="ValrCategory" ControlToValidate="TxtCategory"
                    Display="Dynamic" ErrorMessage="请设置或选择一个分类" />
                <asp:DropDownList ID="DropCategory" runat="server" Width="80px">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right" style="width: 105px">
                <strong>代码段说明：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left" style="width: 330px">
                <asp:TextBox ID="TxtDescription" runat="server" Width="288px" Height="112px" TextMode="MultiLine"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="4" align="center">
                <asp:Button ID="Button1" runat="server" Text="保　存" OnClick="BtnSave_Click" Style="cursor: pointer;
                    cursor: hand; width: 88px;" />&nbsp;&nbsp;
                <input id="Button2" type="button" class="inputbutton" value="取　消" onclick="Redirect('CodeSnippetManage.aspx')"
                    style="cursor: pointer; cursor: hand; width: 88px;" />
            </td>
        </tr>
    </table>
    <div id="prompt-note">
        <dl>
            <dt class="prompt-note-tit"><span>提示说明</span> <a>使用说明</a> <a>名词解释</a> <span class="right-line">
            </span></dt>
            <dd class="prompt-note-con">
                <p>
                    使用代码段，您可以存储内容以便快速重复使用。您可以创建并插入 HTML、JavaScript、CSS、标签代码段、自定义代码段等代码段。<br />
                    系统还包含了一些预定义的代码片段，您可以使用它们作为起始点。
                </p>
            </dd>
            <dd class="prompt-note-con" style="display: none;">
                <p>
                    代码段名称:<br />
                    代码片段名称，该名称一旦确定后，在同分类下不允许重复。</p>
                <p>
                    代码段分类:<br />
                    您可以为代码片段选择一个分类，如果没有您需要的分类，可以直接在分类输入框中输入您需要的分类名称，该分类将会自动创建，如果保持分类为空，则该代码段不属于任何分类。</p>
            </dd>
            <div class="clearbox">
            </div>
        </dl>
    </div>

    <script type="text/javascript">
        function changeText() {
            var select = document.getElementById('<%=DropCategory.ClientID %>');
            var tar = document.getElementById('<%=TxtCategory.ClientID %>');
            for (i = 0; i < select.length; i++) {
                if (select[i].selected && select[i].value != "noneType") {
                    tar.value = select[i].value;
                }
            }
        }
    </script>

</asp:Content>
