﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true" ValidateRequest="false"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Survey.SurveyCode" EnableViewState="true" Codebehind="SurveyCode.aspx.cs" Title="问卷代码调用" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvCode" runat="server" AutoGenerateColumns="False" SerialText=""
        ItemName="问卷" ItemUnit="篇" DataSourceID="OdsSurvey" AllowPaging="True" OnRowDataBound="Egv_RowDataBound">
        <Columns>
            <pe:BoundField DataField="SurveyName" HeaderText="问卷名称" SortExpression="SurveyName"
                >
                <ItemStyle Width="160px" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="问卷页面调用代码" SortExpression="Disabled">
                <ItemTemplate>
                    <asp:TextBox ID="TxtFrameCode" runat="server" TextMode="MultiLine" Width="230" Height="50"
                        onclick="copyToClipboard(this);" Text=''></asp:TextBox>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="问卷页面链接调用代码" SortExpression="Disabled">
                <ItemTemplate>
                    <asp:TextBox ID="TxtLinkCode" runat="server" TextMode="MultiLine" Width="230" Height="50"
                        onclick="copyToClipboard(this);" Text=''></asp:TextBox>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="问卷结果调用代码" SortExpression="Disabled">
                <ItemTemplate>
                    <asp:TextBox ID="TxtResultCode" runat="server" TextMode="MultiLine" Width="230" Height="50"
                        onclick="copyToClipboard(this);" Text=''></asp:TextBox>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsSurvey" runat="server" SelectMethod="GetList" TypeName="PowerEasy.Module.General.BusinessLogic.Survey.SurveyManager"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="SearchType" QueryStringField="SearchType" Type="Int32" />
            <asp:QueryStringParameter Name="Keyword" QueryStringField="Keyword" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
        <script type="text/javascript">
        function copyToClipboard(obj) {
            var txt = obj.value;
            if (window.clipboardData) {
                window.clipboardData.clearData();
                window.clipboardData.setData("Text", txt);
                alert("调用代码已经成功的复制到了剪贴板！");
            } else if (navigator.userAgent.indexOf("Opera") != -1) {
                window.location = txt;
            } else if (window.netscape) {
                try {
                    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
                } catch (e) {
                    alert("被浏览器拒绝！\n请在浏览器地址栏输入'about:config'并回车\n然后将'signed.applets.codebase_principal_support'设置为'true'");
                }
                var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
                if (!clip)
                    return;
                var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
                if (!trans)
                    return;
                trans.addDataFlavor('text/unicode');
                var str = new Object();
                var len = new Object();
                var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
                var copytext = txt;
                str.data = copytext;
                trans.setTransferData("text/unicode", str, copytext.length * 2);
                var clipid = Components.interfaces.nsIClipboard;
                if (!clip)
                    return false;
                clip.setData(trans, null, clipid.kGlobalClipboard);
                alert("调用代码已经成功的复制到了剪贴板！");
            }
        }
    
    </script>
    
    
    
    
</asp:Content>
