﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/Guide.master"
    CodeBehind="RedirectUrlGuide.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.RedirectUrl.RedirectUrlGuide"
    Title="转向链接信息管理向导" %>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="CphTitle">
    转向链接信息管理
</asp:Content>
<asp:Content ID="Content2" runat="server" ContentPlaceHolderID="CphSubMenu">
    <div class="guideexpand" onclick="Switch(this)">
        管理操作</div>
    <div class="guide">
        <ul>
            <li><a href="RedirectUrlManage.aspx" target="main_right">链接信息管理</a></li>
            <li><a href="RedirectUrl.aspx?Action=Add" target="main_right">添加链接信息</a></li>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        按类别查询</div>
    <div class="guide">
        <ul>
            <li><a href="RedirectUrlManage.aspx?CategoryID=0" target="main_right">
                所有类别</a></li>
            <asp:Repeater ID="RptRedirectUrl" runat="server">
                <ItemTemplate>
                    <li><a href="RedirectUrlManage.aspx?CategoryID=<%# Eval("CategoryId") %>" target="main_right">
                        <%# Eval("CategoryName")%></a></li>
                </ItemTemplate>
            </asp:Repeater>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        链接查询</div>
    <div class="guidesearch">
        <ul>
            <li>
                <select id="SelField" style="width: 140px">
                    <option value="1">ID</option>
                    <option value="2" selected="selected">链接名称</option>
                    <option value="3">链接ID</option>                    
                    
                </select>
            </li>
            <li>
                <input id="TxtKeyWord" style="width: 134px;" type="text" class="inputtext" />
            </li>
            <li>
                <input id="BtnSearch" type="button" class="inputbutton" value="查询" onclick="return OpenMainRight()" />
            </li>
        </ul>
    </div>

    <script type="text/javascript">
        function OpenMainRight() {
            var field = 0;
            var keyword = document.getElementById("TxtKeyWord").value.trim();
            var objSel = document.getElementById("SelField");

            if (keyword == "") {
                alert("请输入要查询的条件！");
                return false;
            }
            field = objSel.options[objSel.options.selectedIndex].value;

            if (field == "1" || field == "3") {
                if (checknumber(keyword)) {
                    alert("只允许输入数字！");
                    return false;
                }
            }

            var url = "RedirectUrlManage.aspx?ListType=" + field + "&KeyWord=" + escape(keyword);
            JumpToMainRight(url);
        }

        function checknumber(String) {
            var Letters = "1234567890";
            var i;
            var c;
            for (i = 0; i < String.length; i++) {
                c = String.charAt(i);
                if (Letters.indexOf(c) == -1) {
                    return true;
                }
            }
            return false;
        } 
    </script>

</asp:Content>
