﻿<%@ Page Language="C#" MasterPageFile="~/Admin/Guide.master" CodeBehind="RegisterCommissionGuide.aspx.cs"
    Inherits="PowerEasy.Module.Promotion.WebSite.Admin.Promotion.RegisterCommissionGuide"
    AutoEventWireup="True" Title="注册推广佣金明细管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphTitle" runat="Server">
    注册佣金明细管理
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphSubMenu" runat="Server">
    <div class="guidecollapse" onclick="Switch(this)">
        快速查找</div>
    <div class="guide">
        <ul>
            <li><a href="RegisterCommission.aspx?ListType=-1" target="main_right">所有佣金明细</a> </li>
            <li><a href="RegisterCommission.aspx?ListType=10" target="main_right">10天内的佣金明细</a>
            </li>
            <li><a href="RegisterCommission.aspx?ListType=11" target="main_right">当前月的佣金明细</a>
            </li>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        高级查找</div>
    <div class="guidesearch">
        <ul>
            <li>
                <select id="SelField" style="width: 140px" onchange="ChanageSelect(this)">
                    <option value="1" selected="selected">推广人</option>
                    <option value="2">注册会员名</option>
                    <option value="3">注册时间</option>
                </select>
            </li>
            <li id="key" style="display: ">
                <input id="TxtKeyWord" style="width: 134px;" type="text" class="inputtext" onmouseover="this.select()"
                    onclick="javascript:{if (aspnetForm.TxtKeyWord.value == '请输入关键字...')aspnetForm.TxtKeyWord.value=''; };"
                    value="请输入关键字..." />
            </li>
            <li id="dpk" style="display: none">
                <pe:DatePicker ID="Dpk" runat="server" Width="115px"></pe:DatePicker>
                <br />
                <pe:RegexValidator ValidateType="Date" ID="Vdate" ControlToValidate="Dpk" Display="Dynamic"
                    SetFocusOnError="true" runat="server"></pe:RegexValidator>
            </li>
            <li>
                <input id="BtnSearch" type="button" class="inputbutton" value="查询" onclick="OpenMainRight()" />
            </li>
        </ul>
    </div>

    <script type="text/javascript">
        function ChanageSelect(select) {
            if (select.options[select.options.selectedIndex].value != 3) {
                document.getElementById("dpk").style.display = "none";
                document.getElementById("key").style.display = "";
            } else {
                document.getElementById("dpk").style.display = "";
                document.getElementById("key").style.display = "none";
            }
        }
        ChanageSelect(document.getElementById("SelField"));
        function OpenMainRight() {
            var field = 0;
            var keyword = document.getElementById("TxtKeyWord").value.trim();
            var objSel = document.getElementById("SelField");

            if (objSel.options[objSel.options.selectedIndex].value != 3) {
                keyword = document.getElementById("TxtKeyWord").value.trim();
            } else {
                keyword = document.getElementById("<%=Dpk.ClientID %>").value
                if (!isVbDate(keyword)) {
                    alert("请输入日期！");
                    return false;
                }
            }
            
            if (keyword == "") {
                alert("请输入要查询的条件！");
                return false;
            }
            field = objSel.options[objSel.options.selectedIndex].value;
            var url = "RegisterCommission.aspx?ListType=" + field + "&KeyWord=" + escape(keyword);
            JumpToMainRight(url);
        }

        function isVbDate(str) {
            var reg = /^(\d{4})(-|\/|\.)(\d{1,2})\2(\d{1,2})$/;
            result = str.match(reg);
            if (result == null) {
                return false;
            }
            var y, m, d;

            //获得用户输入之年份
            y = result[1];

            //获得用户输入之月份
            m = parseInt(result[3], 10);

            //获得用户输入之日
            d = parseInt(result[4], 10);

            if ((m < 1) || (m > 12) || (d < 1) || (d > 31)) return false;
            if (((m == 4) || (m == 6) || (m == 9) || (m == 11)) && (d > 30)) return false;
            if ((y % 4) == 0) {
                if ((m == 2) && (d > 29)) return false;
            } else {
                if ((m == 2) && (d > 28)) return false;
            }
            return true;
        }
    </script>

</asp:Content>
