﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="PromotionManage.aspx.cs" Inherits="PowerEasy.Module.Promotion.WebSite.Admin.Promotion.PromotionProduct"
    Title="推广商品管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <pe:ExtendedGridView ID="EgvPromotion" runat="server" AutoGenerateColumns="False"
                AllowPaging="True" AutoGenerateCheckBoxColumn="True" ItemName="推广商品" ItemUnit="个"
                CheckBoxFieldHeaderWidth="3%" SerialText="" IsHoldState="True" OnRowDataBound="EgvPromotion_RowDataBound"
                DataKeyNames="ID" DataSourceID="OdsPromotion" RowDblclickBoundField="GeneralId"
                RowDblclickUrl="../Shop/ProductView.aspx?GeneralID={$Field}">
                <Columns>
                    <pe:TemplateField HeaderText="ID" SortExpression="Stocks">
                        <ItemStyle HorizontalAlign="Center" Width="3%" />
                        <ItemTemplate>
                            <%#Eval("ID")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="商品图片">
                        <ItemStyle HorizontalAlign="center" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedImage ID="extendedImage" runat="server" ImageWidth="60" ImageHeight="45" />
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="商品名称" SortExpression="ProductName">
                        <ItemStyle HorizontalAlign="Left" />
                        <ItemTemplate>
                            <pe:LinkImage ID="LinkImageModel" runat="server">
                                <pe:ExtendedLabel ID="LblNodeName" HtmlEncode="false" runat="server"></pe:ExtendedLabel>
                                <asp:HyperLink ID="LnkProductName" runat="server"></asp:HyperLink>
                            </pe:LinkImage>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:BoundField DataField="Unit" HeaderText="单位" SortExpression="Unit">
                        <HeaderStyle Width="5%" />
                    </pe:BoundField>
                    <pe:TemplateField HeaderText="库存" SortExpression="Stocks">
                        <ItemStyle HorizontalAlign="Right" Width="6%" />
                        <ItemTemplate>
                            <%#Eval("Stocks")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="价格" SortExpression="Price">
                        <ItemStyle HorizontalAlign="Right" />
                        <HeaderStyle Width="7%" />
                        <ItemTemplate>
                            <asp:Label ID="LblProductPrice" runat="server" Text=""></asp:Label>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="佣金类型" SortExpression="CommissionType">
                        <ItemStyle HorizontalAlign="center" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <asp:DropDownList ID="DropCommissionType" runat="server">
                                <asp:ListItem Selected="True" Value="0">百分比</asp:ListItem>
                                <asp:ListItem Value="1">固定佣金</asp:ListItem>
                            </asp:DropDownList>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="佣金" SortExpression="Commission">
                        <ItemStyle HorizontalAlign="center" />
                        <HeaderStyle Width="7%" />
                        <ItemTemplate>
                            <asp:TextBox ID="TxtRate" runat="server" Width="50px" onchange="checkMoney(this)"
                                Style="text-align: right">0</asp:TextBox>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <asp:TemplateField HeaderText="操作">
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedLiteral HtmlEncode="false" ID="LitSave" runat="server">保存</pe:ExtendedLiteral>&nbsp;<a
                                href='<%# "PromotionManage.aspx?Action=Delete&ID=" + Eval("Id")%>' onclick="return confirm('是否删除此记录？');">删除</a>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </pe:ExtendedGridView>
            <asp:ObjectDataSource ID="OdsPromotion" runat="server" SelectMethod="GetPromotionInfoList"
                SelectCountMethod="GetTotalOfPromotion" TypeName="PowerEasy.Module.Promotion.BusinessLogic.Promotion"
                DeleteMethod="Delete" EnablePaging="True" StartRowIndexParameterName="startRowIndexId"
                MaximumRowsParameterName="maxNumberRows" OldValuesParameterFormatString="original_{0}">
                <DeleteParameters>
                    <asp:Parameter Name="id" Type="String" />
                </DeleteParameters>
                <SelectParameters>
                    <asp:QueryStringParameter Name="listType" QueryStringField="ListType" Type="int32" />
                    <asp:QueryStringParameter Name="keyWord" QueryStringField="KeyWord" Type="string" />
                </SelectParameters>
            </asp:ObjectDataSource>
        </ContentTemplate>
    </asp:UpdatePanel>
    <br />
    <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" />选中本页显示的所有推广商品
    &nbsp;&nbsp;
     <pec:FloatingDialog ID="FdAddProduct" runat="server" Name="添加推广商品" BeginString=""
        EndString="" Title="添加推广商品" Width="700" Height="450" LoadUrl="../Shop/ProductPicker.aspx?ShowType=1"
        ShowType="1" />
    <asp:Button ID="EBtnBatchDelete" Text="删除选中的推广商品" OnClientClick="return batchconfirm('是否要删除选中的推广商品？');"
        OnClick="EBtnBatchDelete_Click" CausesValidation="False" runat="server" />
    <asp:Button ID="EBtnBatchSave" Text="保存选中项的佣金设置" OnClientClick="return batchconfirm('是否要保存选中项的佣金设置？');"
        OnClick="EBtnBatchSave_Click" CausesValidation="False" runat="server" />
   
    <div id="prompt-note">
        <dl>
            <dt class="prompt-note-tit"><span>提示说明</span> <a>推广商品管理</a> <span class="right-line">
            </span></dt>
            <dd class="prompt-note-con">
                <p>
                    <li>商品价格为商品的当前零售价格。</li>
                    <li>不同会员会因为会员组的折扣比会显示不同的价格。</li>
                    <li>多属性商品也会因商品属性价格不同而显示不同。</li>
                    <li>注意普通管理员添加推广商品要拥有商品栏目的查看权限。</li>
                </p>
            </dd>
            <div class="clearbox">
            </div>
        </dl>
    </div>

    <script type="text/javascript">
        function DoProductPickerPostBack(arrProductList) {
            __doPostBack('AddProductButton', arrProductList);
        }

        function CheckLength(obj) {
            if (obj.value.length > 200) {
                obj.value = obj.value.substr(0, 200);
            }
        }
        function SavePromotion(id, dropCommissionType, rate) {
            if (!checkMoney(document.getElementById(rate))) {
                return
            }
            var rate = document.getElementById(rate).value;
            var CommissionType = document.getElementById(dropCommissionType).value;
            window.location = 'PromotionManage.aspx?Action=Save&ID=' + id + '&Rate=' + rate + '&CommissionType=' + CommissionType;
        }
        function checkMoney(obj) {
            var tempValue = obj.value.replace(/(^\s+)|(\s+$)/g, '');
            if (!tempValue) { return }
            if (/^-?\d+(\.\d+)?$/.test(tempValue)) {
                obj.value = parseFloat(tempValue).toFixed(2);
                return true;
            } else {
                alert('请输入可包含小数点后2位的有效数字值！');
                return false;
            }
        } 
    </script>

</asp:Content>
