﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CustomForm.aspx.cs" MasterPageFile="~/Admin/MasterPage.master" Title="表单添加/修改" ValidateRequest="false" Inherits="PowerEasy.Module.General.WebSite.Admin.CustomForm.CustomForm" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table class="border" width="100%" cellpadding="2" cellspacing="1">
        <tr>
            <td class="spacingtitle" colspan="2" align="center">
                <pe:AlternateLiteral ID="AltrTitle" Text="添加自定义表单" AlternateText="修改自定义表单" runat="Server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 35%">
                <strong>表单名称：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtModelName" runat="server" Width="156" MaxLength="200" />
                <pe:RequiredFieldValidator ID="ValrModelName" ControlToValidate="TxtModelName" runat="server"
                    ErrorMessage="自定义表单名称不能为空！" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>创建的数据表名：</strong>
                <pe:AlternateLiteral ID="TableNameText" Text="<br /><span style='color: red'>注意：</span>创建表后将无法再更改表名称"
                    runat="Server" />
            </td>
            <td>
                <asp:Label ID="LblTablePrefix" runat="server" Text="PE_U_" />
                <asp:TextBox ID="TxtTableName" runat="server" Width="120" MaxLength="50" />
                <pe:RequiredFieldValidator ID="ValrTableName" ControlToValidate="TxtTableName" runat="server"
                    ErrorMessage="数据表名不能为空" SetFocusOnError="true" Display="Dynamic" />
                <asp:RegularExpressionValidator ID="ValeTableName" runat="server" ControlToValidate="TxtTableName"
                    ErrorMessage="只允许输入字母、数字或下划线" ValidationExpression="^[\w_]+$" SetFocusOnError="true"
                    Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>标题字段：</strong>
                <br />
                用作于表单标题的表单字段。
            </td>
            <td>
                <asp:DropDownList runat="server" ID="DrlTitleField">
                   <asp:ListItem Value="" Text="默认"></asp:ListItem>
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>项目名称：</strong>
                <br />
                例如：文章、软件、图片、商品
            </td>
            <td>
                <asp:TextBox ID="TxtItemName" runat="server" Width="156" MaxLength="20" />
                <pe:RequiredFieldValidator ID="ValrItemName" ControlToValidate="TxtItemName" runat="server"
                    ErrorMessage="项目名称不能为空" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>项目单位：</strong>
                <br />
                例如：篇、个、件
            </td>
            <td>
                <asp:TextBox ID="TxtItemUnit" runat="server" Width="156" MaxLength="20" />
                <pe:RequiredFieldValidator ID="ValrItemUnit" ControlToValidate="TxtItemUnit" runat="server"
                    ErrorMessage="项目单位不能为空" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>项目图标：</strong>
                <br />
                图标存放在~/Images/ModelIcon/目录下
            </td>
            <td>
                <asp:TextBox ID="TxtItemIcon" Text="Default.gif" runat="server" Width="156" MaxLength="20" />
                <asp:Image ID="ImgItemIcon" runat="server" ImageUrl="~/Images/ModelIcon/Default.gif" />
                <=<asp:DropDownList ID="DrpItemIcon" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>表单描述：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtDescription" runat="server" TextMode="MultiLine" Width="365px"
                    Height="43px"  MaxLength="255" /><asp:RegularExpressionValidator ID="RegTxtDescription" runat="server" Display="Dynamic" ErrorMessage="表单描述超过了255个字符" ValidationExpression=".{0,255}" ControlToValidate="TxtDescription"></asp:RegularExpressionValidator>
            </td> 
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>前台提交页模板：</strong>
            </td>
            <td>
                <pe:TemplateSelectControl ID="FileCTemplate" runat="server" Width="300px" />
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:Button ID="EBtnSubmit" Text="保存" OnClick="EBtnSubmit_Click" runat="server" />
                &nbsp;&nbsp;
                <input name="Cancel" type="button" class="inputbutton" id="Cancel" value="取消" onclick="Redirect('CustomFormManage.aspx')" />
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="HdnModelId" runat="server" />
    <asp:HiddenField ID="HdnModelName" runat="server" />
    <asp:HiddenField ID="HdnTableName" runat="server" />

    <script type="text/javascript">
    function ChangeImgItemIcon(icon)
    {
        document.getElementById("<%= ImgItemIcon.ClientID %>").src = "../../Images/ModelIcon/"+icon;
    }
    function ChangeTxtItemIcon(icon)
    {
        document.getElementById("<%= TxtItemIcon.ClientID %>").value = icon;
    }
    </script>

</asp:Content>
