﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="MainContacter.ascx.cs"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Controls.Crm.MainContacter" %>
<asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server">
</asp:ScriptManagerProxy>
<asp:UpdatePanel ID="UpdatePanelContacter" runat="server">
    <ContentTemplate>
        <table cellpadding="2" cellspacing="1" style="width: 100%;" class="border" border="0">
            <tr style="text-align: center;" class="tdbgleft">
                <td>
                    真实姓名
                </td>
                <td>
                    办公电话
                </td>
                <td>
                    移动电话
                </td>
                <td>
                    QQ号码
                </td>
                <td>
                    Email地址
                </td>
                <td>
                    操作
                </td>
            </tr>
            <asp:Repeater ID="RptContainer" runat="server" OnItemDataBound="RptContainer_OnItemDataBound">
                <ItemTemplate>
                    <tr class="tdbg">
                        <td align="center">
                            <asp:HyperLink ID="LnkTrueName" runat="server" Text='<%#Eval("TrueName") %>'></asp:HyperLink>
                        </td>
                        <td align="center">
                            <%#Eval("OfficePhone") %>
                        </td>
                        <td align="center">
                            <%#Eval("Mobile")%>
                        </td>
                        <td align="center">
                            <%#Eval("QQ")%>
                        </td>
                        <td align="center">
                            <%#Eval("Email")%>
                        </td>
                        <td align="center">
                            <asp:LinkButton ID="LBtnDelete" runat="server" Text="删除" CausesValidation="false"
                                OnCommand="LBtnDelete_Click" CommandArgument='<%# Container.ItemIndex %>' />
                        </td>
                    </tr>
                </ItemTemplate>
            </asp:Repeater>
            <tr class="tdbg">
                <td>
                    <asp:TextBox ID="txtTrueName" runat="server" ValidationGroup="MainContacter"></asp:TextBox>
                </td>
                <td>
                    <asp:TextBox ID="txtOfficePhone" runat="server" ValidationGroup="MainContacter"></asp:TextBox>
                </td>
                <td>
                    <asp:TextBox ID="txtMobile" runat="server" ValidationGroup="MainContacter"></asp:TextBox>
                </td>
                <td>
                    <asp:TextBox ID="txtQQ" runat="server" ValidationGroup="MainContacter"></asp:TextBox>
                </td>
                <td>
                    <asp:TextBox ID="txtEmail" runat="server" ValidationGroup="MainContacter"></asp:TextBox>
                </td>
                <td>
                    <pe:ExtendedButton IsChecked="true" OperateCode="ContacterAdd" ID="BtnAddContacter"
                        runat="server" Text="添加" OnClick="BtnAddContainer_Click" ValidationGroup="MainContacter" />
                </td>
            </tr>
        </table>
        <div style="text-align: left">
            <pe:ExtendedLabel ForeColor="Red" HtmlEncode="false" runat="server" ID="LblMsg" />
            <pe:RegexValidator ValidateType="Mobile" ID="VtelOfficePhone" ControlToValidate="txtOfficePhone"
                SetFocusOnError="true" Display="dynamic" runat="server" ErrorMessage="<li>填写的电话号码格式不正确！</li>"
                ValidationGroup="MainContacter"></pe:RegexValidator>
            <pe:RegexValidator ValidateType="Mobile" ID="VmblMobile" ControlToValidate="txtMobile"
                SetFocusOnError="true" Display="dynamic" runat="server" ErrorMessage="<li>填写的手机号码格式不正确！</li>"
                ValidationGroup="MainContacter"></pe:RegexValidator>
            <pe:RegexValidator ValidateType="QQ" ID="VQQ" ControlToValidate="txtQQ" SetFocusOnError="true"
                Display="dynamic" runat="server" ErrorMessage="<li>填写的QQ号码格式不正确！</li>" ValidationGroup="MainContacter"></pe:RegexValidator>
            <pe:RegexValidator ValidateType="Email" ID="Vmail" ControlToValidate="txtEmail" SetFocusOnError="true"
                Display="dynamic" runat="server" ErrorMessage="<li>填写的Email地址格式不正确！</li>" ValidationGroup="MainContacter"></pe:RegexValidator>
        </div>
    </ContentTemplate>
</asp:UpdatePanel>
