﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="MoodManage.aspx.cs"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Contents.MoodManage"
    MasterPageFile="~/Admin/MasterPage.master" Title="心情指数管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation"
    runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider"
        runat="server" />
    <br />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent"
    runat="Server">
    <pe:ExtendedGridView ID="GdvMoodSchemeList" AutoGenerateColumns="False"
        runat="server" DataSourceID="OdsMoodSchemeList" DataKeyNames="MoodId"
        AllowPaging="True" ItemName="心情指数方案" ItemUnit="项" AutoGenerateCheckBoxColumn="True"
        PageSize="20" CheckBoxFieldHeaderWidth="3%" OnRowDataBound="GdvMoodSchemeList_RowDataBound" OnRowCommand="GdvMoodSchemeList_RowCommand">
        <Columns>
            <pe:TemplateField HeaderText="ID" HeaderStyle-Width="3%" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label ID="TxtMoodId" runat="server" Text='<%# Eval("MoodId") %>'></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="方案名称" HeaderStyle-Width="25%">
                <ItemTemplate>
                    <a href="Mood.aspx?Action=Modify&MoodID=<%# Eval("MoodId") %>">
                        <asp:Label ID="TxtMoodName" runat="server" Text='<%# Eval("MoodName") %>'></asp:Label>
                    </a>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="调用标签">
                <ItemTemplate>
                    <asp:TextBox ID="TxtLable" onclick="copyToClipboard(this);" runat="server"
                        TextMode="MultiLine" Height="18" Width="98%" Wrap="true"></asp:TextBox>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                <a href="Mood.aspx?Action=Modify&MoodID=<%# Eval("MoodId") %>">修改</a>
          <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("MoodId") %>'
            CommandName="Deleted" OnClientClick="return confirm('是否删除本心情指数方案？')">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView><br />
    <asp:Button ID="BtnDel" runat="server" Text="批量删除选定的心情指数方案" CausesValidation="False"
    OnClientClick="return batchconfirm('确实要删除选中的心情指数方案？');" OnClick="BtnDel_Click" />&nbsp;&nbsp;<asp:Button
      ID="BtnAdd" runat="server" Text="增加一个新的心情指数方案" OnClick="BtnAdd_Click" />
    <asp:ObjectDataSource ID="OdsMoodSchemeList" runat="server" TypeName="PowerEasy.Module.General.BusinessLogic.Contents.MoodSchemeManage"
        SelectMethod="GetMoodSchemeList"></asp:ObjectDataSource>

    <script type="text/javascript">
        function copyToClipboard(obj) {
            var txt = obj.value;
            if (window.clipboardData) {
                window.clipboardData.clearData();
                window.clipboardData.setData("Text", txt);
                alert("调用代码已经成功的复制到了剪贴板！");
            } else if (navigator.userAgent.indexOf("Opera") != -1) {
                window.location = txt;
            } else if (window.netscape) {
                try {
                    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
                } catch (e) {
                    alert("被浏览器拒绝！\n请在浏览器地址栏输入'about:config'并回车\n然后将'signed.applets.codebase_principal_support'设置为'true'");
                }
                var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);
                if (!clip)
                    return;
                var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
                if (!trans)
                    return;
                trans.addDataFlavor('text/unicode');
                var str = new Object();
                var len = new Object();
                var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
                var copytext = txt;
                str.data = copytext;
                trans.setTransferData("text/unicode", str, copytext.length * 2);
                var clipid = Components.interfaces.nsIClipboard;
                if (!clip)
                    return false;
                clip.setData(trans, null, clipid.kGlobalClipboard);
                alert("调用代码已经成功的复制到了剪贴板！");
            }
        }
    
    </script>

</asp:Content>
