﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Mood.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Contents.Mood"
    MasterPageFile="~/Admin/MasterPage.master" Title="心情指数添加、修改" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
    <br />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" EnablePartialRendering="true" runat="server">
    </asp:ScriptManager>
    <table style="width: 100%; margin: 0 auto;" cellpadding="2" cellspacing="1" class="border">
        <tr class="tdbg" align="center">
            <td colspan="2" class="spacingtitle">
                <asp:Label ID="LblTitle" runat="server" Text="心情指数添加"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 15%; text-align: right">
                是否启用：
            </td>
            <td>
                <asp:CheckBox ID="ChkMoodStatus" Checked="true" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 15%; text-align: right">
                只有会员才可以投票：
            </td>
            <td>
                <asp:CheckBox ID="ChkIsOnlyMember" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="text-align: right">
                项目名称：
            </td>
            <td>
                <asp:TextBox ID="TxtMoodSchemeName" runat="server" Width="180"></asp:TextBox>
                <pe:RequiredFieldValidator runat="server" ID="NReq" ControlToValidate="TxtMoodSchemeName"
                    Display="Dynamic" ErrorMessage="请输入心情指数方案名称" />
                如：心情项目指数等
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="text-align: right">
                项目选项：<br />
                图标存放在：<br />
                Images/MoodIcon/目录下&nbsp;
            </td>
            <td>
                <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                    <ContentTemplate>
                        <pe:ExtendedGridView ID="GdvOption" runat="server" AutoGenerateColumns="False" DataKeyNames="Id"
                            Style="width: 100%;">
                            <Columns>
                                <pe:TemplateField HeaderText="选项" HeaderStyle-Width="30%">
                                    <ItemTemplate>
                                        <%# Eval("Option") %>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:TextBox ID="TxtOptionEdit" runat="server"></asp:TextBox>
                                    </EditItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="图标预览" HeaderStyle-Width="10%" ItemStyle-HorizontalAlign="Center">
                                    <ItemTemplate>
                                        <img width="35px" height="26px" src='../../Images/MoodIcon/<%# Eval("Icon") %>' alt="<%# Eval("Option") %>" />
                                    </ItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="选项图标" HeaderStyle-Width="45%" HeaderStyle-VerticalAlign="Middle">
                                    <ItemTemplate>
                                        <%# Eval("Icon") %>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:TextBox ID="TxtIconEdit" runat="server"></asp:TextBox>
                                        <asp:Image ImageAlign="Middle" ID="ImgItemIconEdit" runat="server" Width="35" Height="25" />
                                        <asp:DropDownList ID="DrpIconEdit" runat="server">
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="操作" ItemStyle-HorizontalAlign="Center">
                                    <HeaderStyle HorizontalAlign="Center" Width="15%" />
                                    <ItemTemplate>
                                        <asp:LinkButton ID="LnkEdit" runat="server" CausesValidation="False" CommandName="Edit"
                                            Text="编辑"></asp:LinkButton>
                                        <asp:LinkButton ID="LnkDelete" runat="server" CausesValidation="False" CommandName="Delete"
                                            OnClientClick="return confirm('你确定要删除吗?');">删除</asp:LinkButton>
                                    </ItemTemplate>
                                    <EditItemTemplate>
                                        <asp:LinkButton ID="LnkUpdate" runat="server" CausesValidation="False" CommandName="Update">修改</asp:LinkButton>
                                        <asp:LinkButton ID="LnkCancl" runat="server" CausesValidation="False" CommandName="Cancel"
                                            Text="取消"></asp:LinkButton>
                                    </EditItemTemplate>
                                </pe:TemplateField>
                            </Columns>
                        </pe:ExtendedGridView>
                        <table class="border" cellspacing="1" cellpadding="1" border="0" style="width: 100%; border-top:none">
                            <tr class="tdbg">
                                <td style="width:30%;" align="center" valign="middle">
                                    <asp:TextBox ID="TxtOption" runat="server" Width="180px"></asp:TextBox>
                                </td>
                                <td style="width: 55%;" valign="middle">
                                    <asp:TextBox ID="TxtIcon" Text="" runat="server" Width="156" />
                                    <asp:Image ID="ImgItemIcon" ImageUrl="../../Images/MoodIcon/motion_01.gif" runat="server" ImageAlign="Middle" Width="35" Height="26" />
                                    <=<asp:DropDownList ID="DrpIcon" runat="server" Width="160" />
                                </td>
                                <td style="width: 15%; text-align: center">
                                    <pe:OneClickButton runat="server" IsOneClick="false" ID="BtnAddMoodScheme" OnClick="BtnAddOptionClick" Text="添加选项"
                                        EnableViewState="False" CausesValidation="false"></pe:OneClickButton>
                                </td>
                            </tr>
                        </table>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2" style="text-align: center">
                <asp:Button ID="BtnSave" runat="server" Text="添加" />
                <asp:Button ID="BtnCancelAdd" runat="server" CausesValidation="false" Text="取消" />
            </td>
        </tr>
    </table>
    <div id="prompt-note">
        <dl>
            <dt class="prompt-note-tit"><span>提示说明</span></dt>
            <dd class="prompt-note-con">
                <p>
                    通过心情指数功能，您的内容页面可以与访问用户互动，了解用户对页面内容的看法和评价。
                    <br />
                    注意：添加心情指数方案的的选项<span style="color: Red">不能少于2，最多不能超过20个</span>。
                </p>
            </dd>
            <div class="clearbox">
            </div>
        </dl>
    </div>

    <script type="text/javascript">
        function ChangeTxtItemIcon(obj, id) {
            if (obj.value == 'chooseAnIcon') return;
            document.getElementById(id).value = obj.value;
        }
        function ChangeImgItemIcon(icon, obj) {
            if (icon.value == 'chooseAnIcon') {
                document.getElementById(obj).src = "../../Images/MoodIcon/motion_01.gif";
                return;
            }
            document.getElementById(obj).src = "../../Images/MoodIcon/" + icon.value;
        }
        function CheckLength(obj, maxLength) {
            if (obj.value.length > maxLength) {
                obj.value = obj.value.substring(0, maxLength - 1);
                alert("字符长度不能超过" + maxLength + "个字符");
            }
        }
    </script>

</asp:Content>
