﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.General.WebSite.Admin.Contents.ContentModelManage"
    MasterPageFile="~/Admin/MasterPage.master" Title="内容模型管理" CodeBehind="ModelManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvModel" runat="server" AutoGenerateColumns="False" DataKeyNames="ModelID"
        DataSourceID="OdsModel" ItemName="模型" ItemUnit="个" SerialText="" OnRowCommand="EgvModel_RowCommand"
        RowDblclickBoundField="ModelID" RowDblclickUrl="Model.aspx?Action=Modify&amp;ModelID={$Field}"
        OnRowDataBound="EgvModel_RowDataBound">
        <Columns>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:DropdownMenu runat="server" ID="ddmenu" ShowShortcut="true">
                        <pe:LinkMenuItem ID="EahModelModify" SkinID="Edit" runat="server" />
                        <pe:LinkMenuItem ID="EahFieldManage" runat="server" Text="字段列表" />
                        <pe:MenuSeparator runat="server" ID="ModelSeparator" />
                        <pe:ButtonMenuItem ID="ELbtnDisabled" Text='<%# (bool)Eval("Disabled") ? "启用" : "禁用"%>'
                            runat="server" CommandName='<%# (bool)Eval("Disabled") ? "Enabled" : "Disabled"%>'
                            CommandArgument='<%# Eval("ModelID")%>' />
                        <pe:LinkMenuItem ID="EahModelDelete" SkinID="Delete" runat="server" OnClientClick="return confirm('删除模型将会把该内容模型所有的相关数据以及采集项目被删除，确定一定要删除此模型吗？');" />
                        <pe:LinkMenuItem ID="EahModelTemplate" runat="server" Text="存为模型模板" />
                    </pe:DropdownMenu>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="ModelID" HeaderText="ID">
                <HeaderStyle Width="5%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="图标">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <asp:Image ID="ImgItemIcon" runat="server" ImageUrl='<%#"~/Images/ModelIcon/" + (string.IsNullOrEmpty(Eval("ItemIcon").ToString())?"Default.gif":Eval("ItemIcon").ToString()) %>' />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="模型名称">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <a href='Model.aspx?Action=Modify&ModelID=<%#Eval("ModelID") %>'>
                        <%# Eval("ModelName").ToString().Length <= 10 ? Eval("ModelName") : Eval("ModelName").ToString().Substring(0, 10) + ".."%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="模型描述">
                <ItemTemplate>
                    <%# Eval("Description").ToString()%>
                </ItemTemplate>
                <ItemStyle HorizontalAlign="Left" VerticalAlign="Top" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="项目名称">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%# Eval("ItemName").ToString().Length <= 10 ? Eval("ItemName") : Eval("ItemName").ToString().Substring(0, 10) + ".."%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="TableName" HeaderText="表名" SortExpression="TableName">
                <HeaderStyle Width="10%" />
                <ItemStyle HorizontalAlign="Left" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="状态">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <%# (bool)Eval("Disabled") ? "<span style='color:Red'>禁用</span>" : "正常"%>
                </ItemTemplate>
            </pe:TemplateField>
            <%--<pe:TemplateField HeaderText="管理操作">
                <HeaderStyle Width="26%" />
                <ItemTemplate>
                    <a id="EahModelModify" href='<%# "Model.aspx?Action=Modify&ModelID=" + Eval("ModelID")%>'
                        runat="server">修改</a> <a id="ELbtnDisabled" text='<%# (bool)Eval("Disabled") ? "启用" : "禁用"%>'
                            runat="server" commandname='<%# (bool)Eval("Disabled") ? "Enabled" : "Disabled"%>'
                            commandargument='<%# Eval("ModelID")%>' /><a id="EahModelDelete" href='<%# AppendSecurityCode("ModelManage.aspx?Action=Delete&ModelID=" + Eval("ModelID"))%>'
                                onclick="return confirm('删除模型将会把该内容模型所有的相关数据以及采集项目被删除，确定一定要删除此模型吗？');" runat="server">删除</a> <a id="EahFieldManage"
                                    href='<%# "~/Admin/CommonModel/FieldManage.aspx?ModelType=1&ModelID=" + Eval("ModelID")+"&ModelName="+Server.UrlEncode(Eval("ModelName").ToString())%>'
                                    runat="server">字段列表</a> <a id="EahModelTemplate" href='<%# AppendSecurityCode("~/Admin/CommonModel/ModelTemplate.aspx?Action=AddModelToFieldTemplate&ModelType=1&ModelID=" + Eval("ModelID")+"&ModelName="+Server.UrlEncode(Eval("ModelName").ToString()))%>'
                                        runat="server">存为模型模板</a> 
                </ItemTemplate>
            </pe:TemplateField>--%>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <asp:ObjectDataSource ID="OdsModel" runat="server" SelectMethod="ContentModelList"
        TypeName="PowerEasy.Module.General.BusinessLogic.CommonModel.ModelManager" EnablePaging="False">
        <SelectParameters>
            <asp:Parameter DefaultValue="0" Name="showType" Type="int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
