﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.General.WebSite.Admin.Contents.CommentModify"
    MasterPageFile="~/Admin/MasterPage.master" Title="评论修改" ValidateRequest="false"
    CodeBehind="CommentModify.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <!-- 显示评论树开始 -->
    <table style="width: 100%; margin: 0 auto;" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <asp:Label ID="LblCommentTitle" runat="server" Text="评论修改" />
            </td>
        </tr>
        <asp:Label ID="LblUserInfo" runat="server" Text="评论修改" Visible="false" /><tr class="tdbg"
            runat="server" id="trUser">
            <td class="tdbgleft" align="right" style="width: 150px;">
                <strong>用户名：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left">
                <asp:TextBox ID="TxtUserName" runat="server" Width="120px" />
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="trEmail">
            <td class="tdbgleft" align="right" style="width: 150px;">
                <strong>邮件：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left">
                <asp:TextBox ID="TxtEmail" runat="server" Style="width: 120px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right" style="width: 150px; height: 42px;">
                <strong>评论标题：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left" style="height: 42px">
                <asp:TextBox ID="TxtCommentTitle" runat="server" Style="width: 250px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right" style="width: 150px">
                <strong>评论内容：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left">
                <asp:TextBox ID="TxtCommentContent" runat="server" Height="118px" TextMode="MultiLine"
                    Width="355px"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrCommentContent" ControlToValidate="TxtCommentContent"
                    runat="server" ErrorMessage="评论回复不能为空！" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right" style="width: 150px">
                <strong>评分：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left">
                <pec:ScoreControl ID="ScoreControl" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right" style="width: 150px">
                <strong>评论是否隐藏：&nbsp;</strong><br />
                <span style="color: #336600">(隐藏只有评论 人才能查看)</span>
            </td>
            <td class="tdbg" align="left">
                <asp:CheckBox ID="ChkReplyIsPrivate" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right" style="width: 150px">
                <strong>引用回复：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left">
                <pe:ExtendedGridView ID="EgvComment" runat="server" DataKeyNames="CommentID" DataSourceID="ObjComment"
                    SerialText="" IsHoldState="True" AllowPaging="True" PageSize="20" AutoGenerateColumns="False"
                    CheckBoxFieldHeaderWidth="3%" EmptyDataHeight="100px" EnableModelValidation="True"
                    AutoGenerateCheckBoxColumn="true">
                    <Columns>
                        <pe:TemplateField HeaderText="评论ID">
                            <ItemTemplate>
                                <%#Eval("CommentID")%>
                            </ItemTemplate>
                        </pe:TemplateField>
                        <pe:TemplateField HeaderText="内容ID">
                            <ItemTemplate>
                                <%#Eval("GeneralID")%>
                            </ItemTemplate>
                        </pe:TemplateField>
                        <pe:TemplateField HeaderText="评论标题">
                            <ItemTemplate>
                                <%#Eval("CommentTitle")%>
                            </ItemTemplate>
                        </pe:TemplateField>
                        <pe:TemplateField HeaderText="评论内容">
                            <ItemTemplate>
                                <%#Eval("Content")%>
                            </ItemTemplate>
                        </pe:TemplateField>
                        <pe:TemplateField HeaderText="用户名">
                            <ItemTemplate>
                                <%#Eval("UserName")%>
                            </ItemTemplate>
                        </pe:TemplateField>
                        <pe:TemplateField HeaderText="IP">
                            <ItemTemplate>
                                <%#Eval("IP")%>
                            </ItemTemplate>
                        </pe:TemplateField>
                        <pe:TemplateField HeaderText="发表评论时间">
                            <ItemTemplate>
                                <%#Eval("UpdateTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                            </ItemTemplate>
                        </pe:TemplateField>
                        <pe:TemplateField HeaderText="状态">
                            <ItemTemplate>
                                <%#Convert.ToBoolean(Eval("Status")) == true ? "<span style='color:green'>审核通过</span>" : "<span style='color:red'>待审核</span>"%>
                            </ItemTemplate>
                        </pe:TemplateField>
                        <pe:TemplateField HeaderText="操作" HeaderStyle-Width="10%">
                            <ItemTemplate>
                                <asp:LinkButton ID="LtnDelete" runat="server" CommandName="Delete" OnClientClick=" if(!this.disabled) return confirm('确实要删除该记录吗？') "
                                    Text="删除" />
                            </ItemTemplate>
                        </pe:TemplateField>
                    </Columns>
                    <RowStyle HorizontalAlign="Center" />
                </pe:ExtendedGridView>
                 <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
                    for="ChkAll">选中本页显示的所有记录</label>
                <asp:Button ID="BtnSubmit1" runat="server" Text="删除选定的评论" OnClick="BtnSubmit1_Click"
                    UseSubmitBehavior="False" OnClientClick="if(!confirm('确定要批量删除评论吗？')){return false;}" />
                <asp:Button ID="BtnSubmit2" runat="server" Text="审核通过选定的评论" OnClick="BtnSubmit2_Click"
                    UseSubmitBehavior="False" />
                <asp:Button ID="BtnSubmit3" runat="server" Text="取消审核选定的评论" OnClick="BtnSubmit3_Click"
                    UseSubmitBehavior="False" />
                <%--评论数据源--%>
                <asp:ObjectDataSource ID="ObjComment" runat="server" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
                    StartRowIndexParameterName="startRowIndexId" DeleteMethod="Delete" SelectMethod="GetReferenceListForItem"
                    TypeName="PowerEasy.Module.General.BusinessLogic.Contents.Comment">
                    <DeleteParameters>
                        <asp:Parameter Name="CommentID" Type="Int32" />
                    </DeleteParameters>
                    <SelectParameters>
                        <asp:Parameter Name="startRowIndexId" Type="Int32" />
                        <asp:Parameter Name="maxNumberRows" Type="Int32" />
                        <asp:QueryStringParameter Name="searchType" QueryStringField="searchType" DefaultValue="ReferenceId"
                            Type="String" />
                        <asp:QueryStringParameter Name="keyword" QueryStringField="CommentID" Type="String" />
                    </SelectParameters>
                </asp:ObjectDataSource>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2" align="center">
                <asp:Button ID="BtnSubmit" runat="server" Text="保存" OnClick="BtnSubmit_Click" />
                &nbsp;&nbsp;
                <asp:Button ID="BtnReset" runat="server" Text="取消" OnClick="BtnReset_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
