﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" CodeBehind="SiteInfo.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Configuration.SiteInfoUI"
    Title="网站信息配置" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
   <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <strong>网站信息配置</strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 40%">
                <strong>网站名称：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="TxtSiteName" runat="server" MaxLength="50" Columns="50"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站标题：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="TxtSiteTitle" runat="server" MaxLength="50" Columns="50"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站地址：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="TxtSiteUrl" runat="server" MaxLength="255" Columns="50"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>LOGO地址：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="TxtLogoUrl" runat="server" MaxLength="255" Columns="50"></asp:TextBox>
                <pec:FloatingDialog ID="LogUrlFileFloatingDialog" runat="server" ShowType="1" Width="550" Height="380" Name="选择"
                Skin="inputbutton" Title="选择文件"/>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>Banner地址：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="TxtBannerUrl" runat="server" MaxLength="255" Columns="50"></asp:TextBox>
                <pec:FloatingDialog ID="BannerUrlFileFloatingDialog" runat="server" ShowType="1" Width="550" Height="380" Name="选择"
                Skin="inputbutton" Title="选择文件"/>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>站长姓名：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="TxtWebmaster" runat="server" MaxLength="20" Columns="50"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>站长信箱：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtWebmasterEmail" runat="server" MaxLength="100" Columns="50">
                </asp:TextBox>
                <pe:RegexValidator ValidateType="Email" ID="Vmail" ControlToValidate="TxtWebmasterEmail"
                    ErrorMessage="错误的电子邮件格式！" runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>版权信息：</strong><br />
                支持HTML标记
            </td>
            <td>
                <asp:TextBox ID="TxtCopyright" TextMode="MultiLine" runat="server" Height="80px"
                    Width="400px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站META关键词：</strong><br />
                针对搜索引擎设置的关键词
            </td>
            <td>
                <asp:TextBox ID="TxtMeta_Keywords" TextMode="MultiLine" runat="server" Height="80px"
                    Width="400px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>网站META网页描述：</strong><br />
                针对搜索引擎设置的网页描述
            </td>
            <td>
                <asp:TextBox ID="TxtMeta_Description" TextMode="MultiLine" runat="server" Height="80px"
                    Width="400px"></asp:TextBox>
            </td>
        </tr>
        <asp:PlaceHolder ID="PlhSerialNumber" Visible="false" runat="server">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <strong>产品主序列号：</strong><br />
                   <span style="color:Blue">了解更多序列号与授权设置请点击<a style="color:Red" target="_blank" href="http://go.powereasy.net/go.aspx?UrlID=1001">更多详情</a></span> 
                </td>
                <td>
                    <asp:TextBox ID="TxtSerialNumber" runat="server" Columns="50" onblur="CheckSerialNumber();"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="ReqTxtSerialNumber" runat="server" ControlToValidate="TxtSerialNumber"
                        ErrorMessage="*"></asp:RequiredFieldValidator>
                    <span id="checkloadding" style="display:none"><img src="../../Admin/Images/loader.gif" style="width:15px; height:15px"/></span>
                </td>
            </tr>
           <tr class="tdbg">
                <td class="tdbgleft">
                </td>
                <td>
                    <asp:CheckBox ID="ChBoxSerialNumber" OnCheckedChanged="mSerialNumber_click" AutoPostBack="true" runat="server" Text="支持双域名" />
                </td>
            </tr>
            <tr class="tdbg" runat="server" id="mSerialNumberDiv" visible="false">
                <td class="tdbgleft">
                    <strong>产品辅序列号：</strong><br />
                </td>
                <td>
                    <asp:TextBox ID="TxtSerialNumber2" runat="server" Columns="50"></asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtSerialNumber2"
                        ErrorMessage="*"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr class="tdbg" id="mWorkflowLimit" style="display:none;">
                <td class="tdbgleft">
                    <strong>工作流限制用户数：</strong><br />
                </td>
                <td>
                   <asp:DropDownList ID="DropWorkflowLimit" runat="server">
                     <asp:ListItem Value="50" Selected="True">50用户</asp:ListItem>
                     <asp:ListItem Value="100">100用户</asp:ListItem>
                     <asp:ListItem Value="200">200用户</asp:ListItem>
					 <asp:ListItem Value="300">300用户</asp:ListItem>
                     <asp:ListItem Value="500">500用户</asp:ListItem>
                     <asp:ListItem Value="999">无限制</asp:ListItem>
                   </asp:DropDownList>
                </td>
            </tr>
            <script type="text/javascript">
               window.onload=function(){
                  CheckSerialNumber();
                }

                function CheckSerialNumber() {
                    var SerialNumber = document.getElementById("<%=TxtSerialNumber.ClientID%>");
                    if(SerialNumber.value!="")
                    {
                      document.getElementById("checkloadding").style.display="";
                      CallTheServer(SerialNumber.value, "");
                    }
                }

                function CallTheServer(arg,context)
                {
                   <%=clientCallBackScript%>
                }

                function ReceiveServerData(data)
                {
                    document.getElementById("checkloadding").style.display="none";
                    if(data=="true")
                    {
                      document.getElementById("mWorkflowLimit").style.display="";
                    }
                    else
                    {
                      document.getElementById("mWorkflowLimit").style.display="none";
                    }
                }
            </script>
        </asp:PlaceHolder>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:Button ID="BtnSubmit" runat="server" Text="保存设置" OnClick="BtnSubmit_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
