﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Accessories.PayPlatforms" Codebehind="PayPlatform.aspx.cs" Title="在线支付平台添加/修改" ValidateRequest="false" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>
                    <pe:AlternateLiteral ID="AltrTitle" Text="添加支付平台" AlternateText="修改支付平台" runat="Server" />
                </b>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 35%;" class="tdbgleft">
                <strong>平台名称：</strong>
                 <br />
                 输入相应的支付平台名称
            </td>
            <td>
                <asp:TextBox ID="TxtPlatformName" runat="server" MaxLength="50"></asp:TextBox>
                <span style="color: #000000">
                    <pe:RequiredFieldValidator ID="ValrPlatformName" runat="server" ControlToValidate="TxtPlatformName"
                        ErrorMessage="平台名称不能为空" Display="Dynamic"></pe:RequiredFieldValidator></span>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>商户ID：</strong>
                <br />
                输入支付方式的商户ID
            </td>
            <td>
                <asp:TextBox ID="TxtAccountsID" runat="server" MaxLength="50"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrAccountsID" runat="server" ControlToValidate="TxtAccountsID"
                    ErrorMessage="商户ID不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>MD5密钥：</strong>
                <br />输入支付方式的MD5密钥
            </td>
            <td>
                <asp:TextBox ID="TxtMD5" runat="server" MaxLength="255" TextMode="Password"></asp:TextBox>                
                <pe:RequiredFieldValidator ID="ValrMD5" runat="server" ControlToValidate="TxtMD5"
                    ErrorMessage="MD5密钥不能为空" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>手续费率：</strong><br />
                  设置相应支付方式应加收的手续费比率
            </td>
            <td>
                <asp:TextBox ID="TxtRate" runat="server" Width="59px" MaxLength="6"></asp:TextBox>% 
                <asp:RegularExpressionValidator ID="ValeRate" runat="server" 
                    ControlToValidate="TxtRate" Display="Dynamic" ErrorMessage="手续费含有不允许输入的字符，手续费必须为非负数" 
                    ValidationExpression="^\d+\.?\d*$"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>支付平台图标：</strong>                 
            </td>
            <td>
                <table width="100%" border="0" cellpadding="2" cellspacing="1">
                    <tr>
                        <td style="width: 100%;" align="left">
                            <img id="ImgPayPlatformIcon" src="../../Admin/Images/default.gif" alt="在线支付平台图标" width="142px"
                                height="43px" />
                        </td>
                    </tr>
                    <tr>
                        <td align="left">
                            <pe:FileUploadControl ID="FileUploadPayPlatformIcon" CustomReturnJSFunction="UpdatePayPlatformIcon"
                                IsAddFileRecord="true" runat="server" ModuleName="PayPlatform">
                            </pe:FileUploadControl>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>备注：</strong>                 
            </td>
            <td>
                <pe:CKeditor ID="EditorRemark" runat="server" Width="580px" Height="300px">
                </pe:CKeditor>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>设为默认：</strong>
                <br />前台下订单时是否默认选中的在线支付方式<br/>已经设置为默认的在线支付方式要禁用，需要先取消默认
                </td>
            <td>
                <input type="checkbox" id="ChkIsDefault" runat="server" onclick="DefalutChange()" />
                &nbsp; &nbsp; 禁用：<input type="checkbox" id="ChkIsDisabled" runat="server" /></td>
        </tr>
        <tr align="center" class="tdbg">
            <td height="50" colspan="2">
                <pe:AlternateButton ID="BtnSubmit" runat="server" Text="添加支付平台" AlternateText="修改支付平台"
                    OnClick="BtnSubmit_Click" />
                <input type="button" id="return" onclick="window.location.href='PayPlatformManage.aspx';" class="inputbutton" value="返回" />
            </td>
        </tr>
    </table>
     <br />注意：支付宝的“MD5密钥”输入方式是安全校验码和合作者ID，用坚线隔开，如：hcxocn904wlsbz17rb86lq11|2088002037520000

    <script type="text/javascript">
        function DefalutChange()
        {
            document.getElementById('<%=ChkIsDisabled.ClientID %>').disabled = document.getElementById('<%=ChkIsDefault.ClientID %>').checked;
            if(document.getElementById('<%=ChkIsDefault.ClientID %>').checked)
            {
                document.getElementById('<%=ChkIsDisabled.ClientID %>').checked = false;
            }
        }

        function UpdatePayPlatformIcon(path, size, id) {
            document.getElementById("ImgPayPlatformIcon").src = "<%= m_ImgPath %>" + path;
        }
    </script>

</asp:Content>
