﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="LogManager.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Accessories.LogManager"
    Title="日志管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="GdvLogManager" runat="server" AutoGenerateCheckBoxColumn="True"
        CheckBoxFieldHeaderWidth="3%" SerialText="" AllowPaging="True" DataSourceID="OdsLog"
        AutoGenerateColumns="False" OnRowCommand="GdvLogManager_RowCommand" DataKeyNames="LogId" OnRowDataBound="GdvLogManager_RowDataBound"
        CssClass="TableWrap">
        <Columns>
            <pe:BoundField DataField="Title" HeaderText="标题" HeaderStyle-Width="">
                <HeaderStyle Width="28%" />
                <ItemStyle CssClass="TdWrap" HorizontalAlign="Left" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="类型">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                   <asp:Label ID="lblType" runat="server" />
                    <%--<%# PowerEasy.Framework.Logging.EnumUtility.GetResource((PowerEasy.Framework.Logging.LogCategory)Eval("Category"))%>--%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="ScriptName" HeaderText="访问地址">
                <ItemStyle CssClass="TdWrap" HorizontalAlign="Left" />
            </pe:BoundField>
            <pe:BoundField DataField="Timestamp" HeaderText="操作时间" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
                HtmlEncode="False" HeaderStyle-Width="16%" />
            <pe:BoundField DataField="UserIP" HeaderText="IP地址" HeaderStyle-Width="12%" />
            <pe:TemplateField HeaderText="操作人">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserName=<%#Eval("UserName") %>'>
                        <%#Eval("UserName") %></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="查看">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <asp:LinkButton ID="LBtnDetail" runat="server" CausesValidation="False" CommandName="Detail"
                        Text="详细" CommandArgument='<%# Eval("LogId") %>' PostBackUrl="~/Admin/Accessories/LogDetail.aspx"></asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsLog" runat="server" SelectMethod="GetList" TypeName="PowerEasy.Framework.Logging.DBLog"
        EnablePaging="True" MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId"
        SelectCountMethod="GetTotalOfLog">
        <SelectParameters>
            <asp:Parameter DefaultValue="0" Name="startRowIndexId" Type="Int32" />
            <asp:Parameter DefaultValue="10" Name="maxNumberRows" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="category" QueryStringField="Category"
                Type="Int32" />
            <asp:QueryStringParameter DefaultValue="" Name="searchType" QueryStringField="SearchType"
                Type="String" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="KeyWord" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
        for="ChkAll">选中本页显示的所有项目</label>
    &nbsp;&nbsp;
    <asp:Button ID="BtnDelete" runat="server" Text="删除选定的日志" OnClick="BtnDelete_Click" />&nbsp;<asp:Button
        ID="BtnClearLog" runat="server" Text="清空日志记录" OnClick="BtnClearLog_Click" OnClientClick="return confirm('是否要清空日志记录？')" />
    <div class="border" style="margin-top: 15px; padding: 5px;">
        <strong>删除</strong><asp:DropDownList ID="ddlOffSet" runat="server">
            <asp:ListItem Text="请选择你要进行的操作" Value="0"></asp:ListItem>
            <asp:ListItem Text="一个星期前的" Value="-7"></asp:ListItem>
            <asp:ListItem Text="半个月前的" Value="-15"></asp:ListItem>
            <asp:ListItem Text="一个月前的" Value="-30"></asp:ListItem>
            <asp:ListItem Text="最后一万条" Value="1"></asp:ListItem>
            <asp:ListItem Text="最后十万条" Value="10"></asp:ListItem>
        </asp:DropDownList>
        <strong>日志</strong>
        <asp:Button ID="btn_OffsetDel" runat="server" Text="执行选定的操作" OnClientClick="return confirm('是否要执行选定的日志记录？')"
            OnClick="btn_OffsetDel_Click" /><span style="color: Red">注：如果日志过多导致服务器超时，请每次删除十万条来操作。</span>
    </div>
</asp:Content>
