/*!
 * # Semantic UI 1.12.1 - Visibility
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,o,t,n){"use strict";e.fn.visibility=function(i){var s,c=e(this),r=c.selector||"",a=(new Date).getTime(),l=[],u=arguments[0],d="string"==typeof u,m=[].slice.call(arguments,1);return c.each(function(){var c,b,g=e.isPlainObject(i)?e.extend(!0,{},e.fn.visibility.settings,i):e.extend({},e.fn.visibility.settings),f=g.className,p=g.namespace,v=g.error,h="."+p,P="module-"+p,V=e(o),C=e(this),y=e(g.context),R=(C.selector||"",C.data(P)),x=o.requestAnimationFrame||o.mozRequestAnimationFrame||o.webkitRequestAnimationFrame||o.msRequestAnimationFrame||function(e){setTimeout(e,0)},T=this;b={initialize:function(){b.debug("Initializing",g),b.setup.cache(),b.save.position(),b.should.trackChanges()&&(b.bind.events(),"image"==g.type&&b.setup.image(),"fixed"==g.type&&b.setup.fixed(),g.observeChanges&&b.observeChanges(),b.is.visible()||b.error(v.visible,C)),g.initialCheck&&b.checkVisibility(),b.instantiate()},instantiate:function(){b.debug("Storing instance",b),C.data(P,b),R=b},destroy:function(){b.verbose("Destroying previous module"),c&&c.disconnect(),V.off("load"+h,b.event.load).off("resize"+h,b.event.resize),y.off("scrollchange"+h,b.event.scrollchange),C.off(h).removeData(P)},observeChanges:function(){y[0];"MutationObserver"in o&&(c=new MutationObserver(function(){b.verbose("DOM tree modified, updating visibility calculations"),b.timer=setTimeout(function(){b.verbose("DOM tree modified, updating sticky menu"),b.refresh()},100)}),c.observe(T,{childList:!0,subtree:!0}),b.debug("Setting up mutation observer",c))},bind:{events:function(){b.verbose("Binding visibility events to scroll and resize"),V.on("load"+h,b.event.load).on("resize"+h,b.event.resize),y.off("scroll"+h).on("scroll"+h,b.event.scroll).on("scrollchange"+h,b.event.scrollchange)},imageLoad:function(){var o=C.find("img"),n=o.length,i=n,s=0,c=[],r=[],a=t.createElement("img"),l=function(){s++,s>=n&&(b.debug("Images finished loading inside element, refreshing position"),b.refresh())};if(n>0)for(o.each(function(){c.push(e(this).attr("src"))});i--;)a=t.createElement("img"),a.onload=l,a.onerror=l,a.src=c[i],r.push(a)}},event:{resize:function(){b.debug("Window resized"),x(b.refresh)},load:function(){b.debug("Page finished loading"),x(b.refresh)},scroll:function(){g.throttle?(clearTimeout(b.timer),b.timer=setTimeout(function(){y.trigger("scrollchange"+h,[y.scrollTop()])},g.throttle)):x(function(){y.trigger("scrollchange"+h,[y.scrollTop()])})},scrollchange:function(e,o){b.checkVisibility(o)}},precache:function(o,n){o instanceof Array||(o=[o]);for(var i=o.length,s=0,c=[],r=t.createElement("img"),a=function(){s++,s>=o.length&&e.isFunction(n)&&n()};i--;)r=t.createElement("img"),r.onload=a,r.onerror=a,r.src=o[i],c.push(r)},should:{trackChanges:function(){return d?(b.debug("One time query, no need to bind events"),!1):(b.debug("Callbacks being attached"),!0)}},setup:{cache:function(){b.cache={occurred:{},screen:{},element:{}}},image:function(){var e=C.data("src");e&&(b.verbose("Lazy loading image",e),g.observeChanges=!1,b.topVisible(function(){b.debug("Image top visible",T),b.precache(e,function(){b.set.image(e),g.onTopVisible=!1})}))},fixed:function(){b.verbose("Setting up fixed on element pass"),g.once=!1,g.onTopPassed=function(){C.addClass(f.fixed).css({top:g.offset+"px"}),g.transition&&e.fn.transition!==n&&C.transition(g.transition,g.duration)},g.onTopPassedReverse=function(){C.removeClass(f.fixed).css({position:"",top:""})}}},set:{image:function(o){var t=b.cache.screen.bottom<b.cache.element.top;C.attr("src",o),t?(b.verbose("Image outside browser, no show animation"),C.show()):g.transition?e.fn.transition!==n?C.transition(g.transition,g.duration):C.fadeIn(g.duration):C.show()}},is:{visible:function(){return b.cache&&b.cache.element?b.cache.element.width>0:!1}},refresh:function(){b.debug("Refreshing constants (width/height)"),b.reset(),b.save.position(),b.checkVisibility(),g.onRefresh.call(T)},reset:function(){b.verbose("Reseting all cached values"),e.isPlainObject(b.cache)&&(b.cache.screen={},b.cache.element={})},checkVisibility:function(e){b.verbose("Checking visibility of element",b.cache.element),b.is.visible()&&(b.save.scroll(e),b.save.calculations(),b.passed(),b.passingReverse(),b.topVisibleReverse(),b.bottomVisibleReverse(),b.topPassedReverse(),b.bottomPassedReverse(),b.passing(),b.topVisible(),b.bottomVisible(),b.topPassed(),b.bottomPassed(),g.onUpdate&&g.onUpdate.call(T,b.get.elementCalculations()))},passed:function(o,t){var i=b.get.elementCalculations();if(o!==n&&t!==n)g.onPassed[o]=t;else{if(o!==n)return b.get.pixelsPassed(o)>i.pixelsPassed;i.passing&&e.each(g.onPassed,function(e,o){i.bottomVisible||i.pixelsPassed>b.get.pixelsPassed(e)?b.execute(o,e):g.once||b.remove.occurred(o)})}},passing:function(e){var o=b.get.elementCalculations(),t=e||g.onPassing,i="passing";return e&&(b.debug("Adding callback for passing",e),g.onPassing=e),o.passing?b.execute(t,i):g.once||b.remove.occurred(i),e!==n?o.passing:void 0},topVisible:function(e){var o=b.get.elementCalculations(),t=e||g.onTopVisible,i="topVisible";return e&&(b.debug("Adding callback for top visible",e),g.onTopVisible=e),o.topVisible?b.execute(t,i):g.once||b.remove.occurred(i),e===n?o.topVisible:void 0},bottomVisible:function(e){var o=b.get.elementCalculations(),t=e||g.onBottomVisible,i="bottomVisible";return e&&(b.debug("Adding callback for bottom visible",e),g.onBottomVisible=e),o.bottomVisible?b.execute(t,i):g.once||b.remove.occurred(i),e===n?o.bottomVisible:void 0},topPassed:function(e){var o=b.get.elementCalculations(),t=e||g.onTopPassed,i="topPassed";return e&&(b.debug("Adding callback for top passed",e),g.onTopPassed=e),o.topPassed?b.execute(t,i):g.once||b.remove.occurred(i),e===n?o.topPassed:void 0},bottomPassed:function(e){var o=b.get.elementCalculations(),t=e||g.onBottomPassed,i="bottomPassed";return e&&(b.debug("Adding callback for bottom passed",e),g.onBottomPassed=e),o.bottomPassed?b.execute(t,i):g.once||b.remove.occurred(i),e===n?o.bottomPassed:void 0},passingReverse:function(e){var o=b.get.elementCalculations(),t=e||g.onPassingReverse,i="passingReverse";return e&&(b.debug("Adding callback for passing reverse",e),g.onPassingReverse=e),o.passing?g.once||b.remove.occurred(i):b.get.occurred("passing")&&b.execute(t,i),e!==n?!o.passing:void 0},topVisibleReverse:function(e){var o=b.get.elementCalculations(),t=e||g.onTopVisibleReverse,i="topVisibleReverse";return e&&(b.debug("Adding callback for top visible reverse",e),g.onTopVisibleReverse=e),o.topVisible?g.once||b.remove.occurred(i):b.get.occurred("topVisible")&&b.execute(t,i),e===n?!o.topVisible:void 0},bottomVisibleReverse:function(e){var o=b.get.elementCalculations(),t=e||g.onBottomVisibleReverse,i="bottomVisibleReverse";return e&&(b.debug("Adding callback for bottom visible reverse",e),g.onBottomVisibleReverse=e),o.bottomVisible?g.once||b.remove.occurred(i):b.get.occurred("bottomVisible")&&b.execute(t,i),e===n?!o.bottomVisible:void 0},topPassedReverse:function(e){var o=b.get.elementCalculations(),t=e||g.onTopPassedReverse,i="topPassedReverse";return e&&(b.debug("Adding callback for top passed reverse",e),g.onTopPassedReverse=e),o.topPassed?g.once||b.remove.occurred(i):b.get.occurred("topPassed")&&b.execute(t,i),e===n?!o.onTopPassed:void 0},bottomPassedReverse:function(e){var o=b.get.elementCalculations(),t=e||g.onBottomPassedReverse,i="bottomPassedReverse";return e&&(b.debug("Adding callback for bottom passed reverse",e),g.onBottomPassedReverse=e),o.bottomPassed?g.once||b.remove.occurred(i):b.get.occurred("bottomPassed")&&b.execute(t,i),e===n?!o.bottomPassed:void 0},execute:function(e,o){var t=b.get.elementCalculations(),n=b.get.screenCalculations();e=e||!1,e&&(g.continuous?(b.debug("Callback being called continuously",o,t),e.call(T,t,n)):b.get.occurred(o)||(b.debug("Conditions met",o,t),e.call(T,t,n))),b.save.occurred(o)},remove:{occurred:function(e){e?b.cache.occurred[e]!==n&&b.cache.occurred[e]===!0&&(b.debug("Callback can now be called again",e),b.cache.occurred[e]=!1):b.cache.occurred={}}},save:{calculations:function(){b.verbose("Saving all calculations necessary to determine positioning"),b.save.direction(),b.save.screenCalculations(),b.save.elementCalculations()},occurred:function(e){e&&(b.cache.occurred[e]===n||b.cache.occurred[e]!==!0)&&(b.verbose("Saving callback occurred",e),b.cache.occurred[e]=!0)},scroll:function(e){e=e+g.offset||y.scrollTop()+g.offset,b.cache.scroll=e},direction:function(){var e,o=b.get.scroll(),t=b.get.lastScroll();return e=o>t&&t?"down":t>o&&t?"up":"static",b.cache.direction=e,b.cache.direction},elementPosition:function(){var e=b.cache.element,o=b.get.screenSize();return b.verbose("Saving element position"),e.fits=e.height<o.height,e.offset=C.offset(),e.width=C.outerWidth(),e.height=C.outerHeight(),b.cache.element=e,e},elementCalculations:function(){var e=b.get.screenCalculations(),o=b.get.elementPosition();return g.includeMargin?(o.margin={},o.margin.top=parseInt(C.css("margin-top"),10),o.margin.bottom=parseInt(C.css("margin-bottom"),10),o.top=o.offset.top-o.margin.top,o.bottom=o.offset.top+o.height+o.margin.bottom):(o.top=o.offset.top,o.bottom=o.offset.top+o.height),o.topVisible=e.bottom>=o.top,o.topPassed=e.top>=o.top,o.bottomVisible=e.bottom>=o.bottom,o.bottomPassed=e.top>=o.bottom,o.pixelsPassed=0,o.percentagePassed=0,o.visible=o.topVisible||o.bottomVisible,o.passing=o.topPassed&&!o.bottomPassed,o.hidden=!o.topVisible&&!o.bottomVisible,o.passing&&(o.pixelsPassed=e.top-o.top,o.percentagePassed=(e.top-o.top)/o.height),b.cache.element=o,b.verbose("Updated element calculations",o),o},screenCalculations:function(){var e=b.get.scroll();return b.save.direction(),b.cache.screen.top=e,b.cache.screen.bottom=e+b.cache.screen.height,b.cache.screen},screenSize:function(){b.verbose("Saving window position"),b.cache.screen={height:y.height()}},position:function(){b.save.screenSize(),b.save.elementPosition()}},get:{pixelsPassed:function(e){var o=b.get.elementCalculations();return e.search("%")>-1?o.height*(parseInt(e,10)/100):parseInt(e,10)},occurred:function(e){return b.cache.occurred!==n?b.cache.occurred[e]||!1:!1},direction:function(){return b.cache.direction===n&&b.save.direction(),b.cache.direction},elementPosition:function(){return b.cache.element===n&&b.save.elementPosition(),b.cache.element},elementCalculations:function(){return b.cache.element===n&&b.save.elementCalculations(),b.cache.element},screenCalculations:function(){return b.cache.screen===n&&b.save.screenCalculations(),b.cache.screen},screenSize:function(){return b.cache.screen===n&&b.save.screenSize(),b.cache.screen},scroll:function(){return b.cache.scroll===n&&b.save.scroll(),b.cache.scroll},lastScroll:function(){return b.cache.screen===n?(b.debug("First scroll event, no last scroll could be found"),!1):b.cache.screen.top}},setting:function(o,t){if(e.isPlainObject(o))e.extend(!0,g,o);else{if(t===n)return g[o];g[o]=t}},internal:function(o,t){if(e.isPlainObject(o))e.extend(!0,b,o);else{if(t===n)return b[o];b[o]=t}},debug:function(){g.debug&&(g.performance?b.performance.log(arguments):(b.debug=Function.prototype.bind.call(console.info,console,g.name+":"),b.debug.apply(console,arguments)))},verbose:function(){g.verbose&&g.debug&&(g.performance?b.performance.log(arguments):(b.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),b.verbose.apply(console,arguments)))},error:function(){b.error=Function.prototype.bind.call(console.error,console,g.name+":"),b.error.apply(console,arguments)},performance:{log:function(e){var o,t,n;g.performance&&(o=(new Date).getTime(),n=a||o,t=o-n,a=o,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:T,"Execution Time":t})),clearTimeout(b.performance.timer),b.performance.timer=setTimeout(b.performance.display,500)},display:function(){var o=g.name+":",t=0;a=!1,clearTimeout(b.performance.timer),e.each(l,function(e,o){t+=o["Execution Time"]}),o+=" "+t+"ms",r&&(o+=" '"+r+"'"),(console.group!==n||console.table!==n)&&l.length>0&&(console.groupCollapsed(o),console.table?console.table(l):e.each(l,function(e,o){console.log(o.Name+": "+o["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(o,t,i){var c,r,a,l=R;return t=t||m,i=T||i,"string"==typeof o&&l!==n&&(o=o.split(/[\. ]/),c=o.length-1,e.each(o,function(t,i){var s=t!=c?i+o[t+1].charAt(0).toUpperCase()+o[t+1].slice(1):o;if(e.isPlainObject(l[s])&&t!=c)l=l[s];else{if(l[s]!==n)return r=l[s],!1;if(!e.isPlainObject(l[i])||t==c)return l[i]!==n?(r=l[i],!1):(b.error(v.method,o),!1);l=l[i]}})),e.isFunction(r)?a=r.apply(i,t):r!==n&&(a=r),e.isArray(s)?s.push(a):s!==n?s=[s,a]:a!==n&&(s=a),r}},d?(R===n&&b.initialize(),b.invoke(u)):(R!==n&&R.invoke("destroy"),b.initialize())}),s!==n?s:this},e.fn.visibility.settings={name:"Visibility",namespace:"visibility",debug:!1,verbose:!1,performance:!0,observeChanges:!0,refreshOnLoad:!0,once:!0,continuous:!1,offset:0,includeMargin:!1,context:o,initialCheck:!0,throttle:!1,type:!1,transition:!1,duration:1e3,onPassed:{},onPassing:!1,onTopVisible:!1,onBottomVisible:!1,onTopPassed:!1,onBottomPassed:!1,onPassingReverse:!1,onTopVisibleReverse:!1,onBottomVisibleReverse:!1,onTopPassedReverse:!1,onBottomPassedReverse:!1,onUpdate:!1,onRefresh:function(){},className:{fixed:"fixed"},error:{method:"The method you called is not defined.",visible:"Element is hidden, you must call refresh after element becomes visible"}}}(jQuery,window,document);