/*!
 * # Semantic UI 1.12.1 - Popup
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,o,n){"use strict";e.fn.popup=function(i){var r,s=e(this),a=e(o),p=s.selector||"",l="ontouchstart"in o.documentElement,u=(new Date).getTime(),c=[],d=arguments[0],f="string"==typeof d,g=[].slice.call(arguments,1);return s.each(function(){var o,s,h,m,b,v=e.isPlainObject(i)?e.extend(!0,{},e.fn.popup.settings,i):e.extend({},e.fn.popup.settings),y=v.selector,w=v.className,P=v.error,T=v.metadata,C=v.namespace,x="."+v.namespace,k="module-"+C,S=e(this),O=e(v.context),E=v.target?e(v.target):S,j=e(t),A=e("body"),R=0,F=!1,D=this,H=S.data(k);b={initialize:function(){b.debug("Initializing",S),b.createID(),b.bind.events(),!b.exists()&&v.preserve&&b.create(),b.instantiate()},instantiate:function(){b.verbose("Storing instance",b),H=b,S.data(k,H)},refresh:function(){v.popup?o=e(v.popup).eq(0):v.inline&&(o=E.next(y.popup).eq(0)),v.popup?(o.addClass(w.loading),s=b.get.offsetParent(),o.removeClass(w.loading),v.movePopup&&b.has.popup()&&b.get.offsetParent(o)[0]!==s[0]&&(b.debug("Moving popup to the same offset parent as activating element"),o.detach().appendTo(s))):s=v.inline?b.get.offsetParent(E):b.has.popup()?b.get.offsetParent(o):A,s.is("html")&&(b.debug("Setting page as offset parent"),s=A)},reposition:function(){b.refresh(),b.set.position()},destroy:function(){b.debug("Destroying previous module"),o&&!v.preserve&&b.removePopup(),clearTimeout(b.hideTimer),clearTimeout(b.showTimer),j.off(h),S.off(x).removeData(k)},event:{start:function(){var t=e.isPlainObject(v.delay)?v.delay.show:v.delay;clearTimeout(b.hideTimer),b.showTimer=setTimeout(function(){!b.is.hidden()||b.is.active()&&b.is.dropdown()||b.show()},t)},end:function(){var t=e.isPlainObject(v.delay)?v.delay.hide:v.delay;clearTimeout(b.showTimer),b.hideTimer=setTimeout(function(){b.is.visible()&&b.hide()},t)},resize:function(){b.is.visible()&&b.set.position()}},create:function(){var t=S.data(T.html)||v.html,n=S.data(T.variation)||v.variation,i=S.data(T.title)||v.title,r=S.data(T.content)||S.attr("title")||v.content;t||r||i?(b.debug("Creating pop-up html"),t||(t=v.templates.popup({title:i,content:r})),o=e("<div/>").addClass(w.popup).addClass(n).data(T.activator,S).html(t),n&&o.addClass(n),v.inline?(b.verbose("Inserting popup element inline",o),o.insertAfter(S)):(b.verbose("Appending popup element to body",o),o.appendTo(O)),b.refresh(),v.hoverable&&b.bind.popup(),v.onCreate.call(o,D)):0!==E.next(y.popup).length?(b.verbose("Pre-existing popup found"),v.inline=!0,v.popup=E.next(y.popup).data(T.activator,S),b.refresh(),v.hoverable&&b.bind.popup()):v.popup?(v.popup.data(T.activator,S),b.verbose("Used popup specified in settings"),b.refresh(),v.hoverable&&b.bind.popup()):b.debug("No content specified skipping display",D)},createID:function(){m=(Math.random().toString(16)+"000000000").substr(2,8),h="."+m,b.verbose("Creating unique id for element",m)},toggle:function(){b.debug("Toggling pop-up"),b.is.hidden()?(b.debug("Popup is hidden, showing pop-up"),b.unbind.close(),b.show()):(b.debug("Popup is visible, hiding pop-up"),b.hide())},show:function(t){t=e.isFunction(t)?t:function(){},b.debug("Showing pop-up",v.transition),b.exists()?v.preserve||v.popup||b.refresh():b.create(),o&&b.set.position()&&(b.save.conditions(),v.exclusive&&b.hideAll(),b.animate.show(t))},hide:function(t){t=e.isFunction(t)?t:function(){},b.remove.visible(),b.unbind.close(),b.is.visible()&&(b.restore.conditions(),b.animate.hide(t))},hideAll:function(){e(y.popup).filter("."+w.visible).each(function(){e(this).data(T.activator).popup("hide")})},hideGracefully:function(t){t&&0===e(t.target).closest(y.popup).length?(b.debug("Click occurred outside popup hiding popup"),b.hide()):b.debug("Click was inside popup, keeping popup open")},exists:function(){return o?v.inline||v.popup?b.has.popup():o.closest(O).length>=1?!0:!1:!1},removePopup:function(){b.debug("Removing popup",o),b.has.popup()&&!v.popup&&(o.remove(),o=n),v.onRemove.call(o,D)},save:{conditions:function(){b.cache={title:S.attr("title")},b.cache.title&&S.removeAttr("title"),b.verbose("Saving original attributes",b.cache.title)}},restore:{conditions:function(){return b.cache&&b.cache.title&&(S.attr("title",b.cache.title),b.verbose("Restoring original attributes",b.cache.title)),!0}},animate:{show:function(t){t=e.isFunction(t)?t:function(){},v.transition&&e.fn.transition!==n&&S.transition("is supported")?(b.set.visible(),o.transition({animation:v.transition+" in",queue:!1,debug:v.debug,verbose:v.verbose,duration:v.duration,onComplete:function(){b.bind.close(),t.call(o,D),v.onVisible.call(o,D)}})):(b.set.visible(),o.stop().fadeIn(v.duration,v.easing,function(){b.bind.close(),t.call(o,D),v.onVisible.call(o,D)})),v.onShow.call(o,D)},hide:function(t){t=e.isFunction(t)?t:function(){},b.debug("Hiding pop-up"),v.transition&&e.fn.transition!==n&&S.transition("is supported")?o.transition({animation:v.transition+" out",queue:!1,duration:v.duration,debug:v.debug,verbose:v.verbose,onComplete:function(){b.reset(),t.call(o,D),v.onHidden.call(o,D)}}):o.stop().fadeOut(v.duration,v.easing,function(){b.reset(),t.call(o,D),v.onHidden.call(o,D)}),v.onHide.call(o,D)}},get:{id:function(){return m},startEvent:function(){return"hover"==v.on?l?"touchstart mouseenter":"mouseenter":"focus"==v.on?"focus":!1},scrollEvent:function(){return l?"touchmove scroll":"scroll"},endEvent:function(){return"hover"==v.on?"mouseleave":"focus"==v.on?"blur":!1},offsetParent:function(t){var o=t!==n?t[0]:S[0],i=o.parentNode,r=e(i);if(i)for(var s="none"===r.css("transform"),a="static"===r.css("position"),p=r.is("html");i&&!p&&a&&s;)i=i.parentNode,r=e(i),s="none"===r.css("transform"),a="static"===r.css("position"),p=r.is("html");return r&&r.length>0?r:e()},offstagePosition:function(n){var i={top:e(t).scrollTop(),bottom:e(t).scrollTop()+e(t).height(),left:0,right:e(t).width()},r={width:o.width(),height:o.height(),offset:o.offset()},s={},a=[];return n=n||!1,r.offset&&n&&(b.verbose("Checking if outside viewable area",r.offset),s={top:r.offset.top<i.top,bottom:r.offset.top+r.height>i.bottom,right:r.offset.left+r.width>i.right,left:r.offset.left<i.left}),e.each(s,function(e,t){t&&a.push(e)}),a.length>0?a.join(" "):!1},positions:function(){return{"top left":!1,"top center":!1,"top right":!1,"bottom left":!1,"bottom center":!1,"bottom right":!1,"left center":!1,"right center":!1}},nextPosition:function(e){var t=e.split(" "),o=t[0],n=t[1],i={top:"bottom",bottom:"top",left:"right",right:"left"},r={left:"center",center:"right",right:"left"},s={"top left":"top center","top center":"top right","top right":"right center","right center":"bottom right","bottom right":"bottom center","bottom center":"bottom left","bottom left":"left center","left center":"top left"},a="top"==o||"bottom"==o,p=!1,l=!1,u=!1;return F||(b.verbose("All available positions available"),F=b.get.positions()),b.debug("Recording last position tried",e),F[e]=!0,"opposite"===v.prefer&&(u=[i[o],n],u=u.join(" "),p=F[u]===!0,b.debug("Trying opposite strategy",u)),"adjacent"===v.prefer&&a&&(u=[o,r[n]],u=u.join(" "),l=F[u]===!0,b.debug("Trying adjacent strategy",u)),(l||p)&&(b.debug("Using backup position",u),u=s[e]),u}},set:{position:function(i,r){var a,p,l,u=(e(t).width(),e(t).height(),E.outerWidth()),c=E.outerHeight(),d=o.outerWidth(),f=o.outerHeight(),g=s.outerWidth(),h=s.outerHeight(),m=v.distanceAway,y=E[0],C=v.inline?parseInt(t.getComputedStyle(y).getPropertyValue("margin-top"),10):0,x=v.inline?parseInt(t.getComputedStyle(y).getPropertyValue(b.is.rtl()?"margin-right":"margin-left"),10):0,k=v.inline||v.popup?E.position():E.offset();switch(i=i||S.data(T.position)||v.position,r=r||S.data(T.offset)||v.offset,R==v.maxSearchDepth&&v.lastResort&&(b.debug("Using last resort position to display",v.lastResort),i=v.lastResort),v.inline&&(b.debug("Adding targets margin to calculation"),"left center"==i||"right center"==i?(r+=C,m+=-x):"top left"==i||"top center"==i||"top right"==i?(r+=x,m-=C):(r+=x,m+=C)),b.debug("Calculating popup positioning",i),a=i,b.is.rtl()&&(a=a.replace(/left|right/g,function(e){return"left"==e?"right":"left"}),b.debug("RTL: Popup positioning updated",a)),a){case"top left":p={top:"auto",bottom:h-k.top+m,left:k.left+r,right:"auto"};break;case"top center":p={bottom:h-k.top+m,left:k.left+u/2-d/2+r,top:"auto",right:"auto"};break;case"top right":p={bottom:h-k.top+m,right:g-k.left-u-r,top:"auto",left:"auto"};break;case"left center":p={top:k.top+c/2-f/2+r,right:g-k.left+m,left:"auto",bottom:"auto"};break;case"right center":p={top:k.top+c/2-f/2+r,left:k.left+u+m,bottom:"auto",right:"auto"};break;case"bottom left":p={top:k.top+c+m,left:k.left+r,bottom:"auto",right:"auto"};break;case"bottom center":p={top:k.top+c+m,left:k.left+u/2-d/2+r,bottom:"auto",right:"auto"};break;case"bottom right":p={top:k.top+c+m,right:g-k.left-u-r,left:"auto",bottom:"auto"}}if(p===n&&b.error(P.invalidPosition,i),b.debug("Calculated popup positioning values",p),o.css(p).removeClass(w.position).addClass(i).addClass(w.loading),l=b.get.offstagePosition(i)){if(b.debug("Popup cant fit into viewport",l),R<v.maxSearchDepth)return R++,i=b.get.nextPosition(i),b.debug("Trying new position",i),o?b.set.position(i):!1;if(!v.lastResort)return b.debug("Popup could not find a position in view",o),b.remove.attempts(),b.remove.loading(),b.reset(),!1}return b.debug("Position is on stage",i),b.remove.attempts(),b.set.fluidWidth(),b.remove.loading(),!0},fluidWidth:function(){v.setFluidWidth&&o.hasClass(w.fluid)&&o.css("width",s.width())},visible:function(){S.addClass(w.visible)}},remove:{loading:function(){o.removeClass(w.loading)},visible:function(){S.removeClass(w.visible)},attempts:function(){b.verbose("Resetting all searched positions"),R=0,F=!1}},bind:{events:function(){b.debug("Binding popup events to module"),"click"==v.on?S.on("click"+x,b.toggle):b.get.startEvent()&&S.on(b.get.startEvent()+x,b.event.start).on(b.get.endEvent()+x,b.event.end),v.target&&b.debug("Target set to element",E),j.on("resize"+h,b.event.resize)},popup:function(){b.verbose("Allowing hover events on popup to prevent closing"),o&&b.has.popup()&&o.on("mouseenter"+x,b.event.start).on("mouseleave"+x,b.event.end)},close:function(){(v.hideOnScroll===!0||"auto"==v.hideOnScroll&&"click"!=v.on)&&(a.one(b.get.scrollEvent()+h,b.hideGracefully),O.one(b.get.scrollEvent()+h,b.hideGracefully)),"click"==v.on&&v.closable&&(b.verbose("Binding popup close event to document"),a.on("click"+h,function(e){b.verbose("Pop-up clickaway intent detected"),b.hideGracefully.call(D,e)}))}},unbind:{close:function(){(v.hideOnScroll===!0||"auto"==v.hideOnScroll&&"click"!=v.on)&&(a.off("scroll"+h,b.hide),O.off("scroll"+h,b.hide)),"click"==v.on&&v.closable&&(b.verbose("Removing close event from document"),a.off("click"+h))}},has:{popup:function(){return o&&o.length>0}},is:{active:function(){return S.hasClass(w.active)},animating:function(){return o&&o.is(":animated")||o.hasClass(w.animating)},visible:function(){return o&&o.is(":visible")},dropdown:function(){return S.hasClass(w.dropdown)},hidden:function(){return!b.is.visible()},rtl:function(){return"rtl"==S.css("direction")}},reset:function(){b.remove.visible(),v.preserve?e.fn.transition!==n&&o.transition("remove transition"):b.removePopup()},setting:function(t,o){if(e.isPlainObject(t))e.extend(!0,v,t);else{if(o===n)return v[t];v[t]=o}},internal:function(t,o){if(e.isPlainObject(t))e.extend(!0,b,t);else{if(o===n)return b[t];b[t]=o}},debug:function(){v.debug&&(v.performance?b.performance.log(arguments):(b.debug=Function.prototype.bind.call(console.info,console,v.name+":"),b.debug.apply(console,arguments)))},verbose:function(){v.verbose&&v.debug&&(v.performance?b.performance.log(arguments):(b.verbose=Function.prototype.bind.call(console.info,console,v.name+":"),b.verbose.apply(console,arguments)))},error:function(){b.error=Function.prototype.bind.call(console.error,console,v.name+":"),b.error.apply(console,arguments)},performance:{log:function(e){var t,o,n;v.performance&&(t=(new Date).getTime(),n=u||t,o=t-n,u=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:D,"Execution Time":o})),clearTimeout(b.performance.timer),b.performance.timer=setTimeout(b.performance.display,100)},display:function(){var t=v.name+":",o=0;u=!1,clearTimeout(b.performance.timer),e.each(c,function(e,t){o+=t["Execution Time"]}),t+=" "+o+"ms",p&&(t+=" '"+p+"'"),(console.group!==n||console.table!==n)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,o,i){var s,a,p,l=H;return o=o||g,i=D||i,"string"==typeof t&&l!==n&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(o,i){var r=o!=s?i+t[o+1].charAt(0).toUpperCase()+t[o+1].slice(1):t;if(e.isPlainObject(l[r])&&o!=s)l=l[r];else{if(l[r]!==n)return a=l[r],!1;if(!e.isPlainObject(l[i])||o==s)return l[i]!==n?(a=l[i],!1):!1;l=l[i]}})),e.isFunction(a)?p=a.apply(i,o):a!==n&&(p=a),e.isArray(r)?r.push(p):r!==n?r=[r,p]:p!==n&&(r=p),a}},f?(H===n&&b.initialize(),b.invoke(d)):(H!==n&&H.invoke("destroy"),b.initialize())}),r!==n?r:this},e.fn.popup.settings={name:"Popup",debug:!1,verbose:!0,performance:!0,namespace:"popup",onCreate:function(){},onRemove:function(){},onShow:function(){},onVisible:function(){},onHide:function(){},onHidden:function(){},variation:"",content:!1,html:!1,title:!1,on:"hover",closable:!0,hideOnScroll:"auto",exclusive:!0,context:"body",position:"top left",prefer:"opposite",lastResort:!1,delay:{show:30,hide:0},setFluidWidth:!0,movePopup:!0,target:!1,popup:!1,inline:!1,preserve:!1,hoverable:!1,duration:200,easing:"easeOutQuint",transition:"scale",distanceAway:0,offset:0,maxSearchDepth:20,error:{invalidPosition:"The position you specified is not a valid position",cannotPlace:"No visible position could be found for the popup",method:"The method you called is not defined."},metadata:{activator:"activator",content:"content",html:"html",offset:"offset",position:"position",title:"title",variation:"variation"},className:{active:"active",animating:"animating",dropdown:"dropdown",fluid:"fluid",loading:"loading",popup:"ui popup",position:"top left center bottom right",visible:"visible"},selector:{popup:".ui.popup"},templates:{escape:function(e){var t=/[&<>"'`]/g,o=/[&<>"'`]/,n={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},i=function(e){return n[e]};return o.test(e)?e.replace(t,i):e},popup:function(t){var o="",i=e.fn.popup.settings.templates.escape;return typeof t!==n&&(typeof t.title!==n&&t.title&&(t.title=i(t.title),o+='<div class="header">'+t.title+"</div>"),typeof t.content!==n&&t.content&&(t.content=i(t.content),o+='<div class="content">'+t.content+"</div>")),o}}},e.extend(e.easing,{easeOutQuad:function(e,t,o,n,i){return-n*(t/=i)*(t-2)+o}})}(jQuery,window,document);