=begin
#
TIG (c) 2005 - 2015
All rights reserved.
#
Loads from Extension and then loads main code.
#
=end
###
module TIG
###
module SectionCutFace
###
### Customizable list of colors...
### Note the surrounding "..." and the ',' after every color except the last one.
###
COLORS=[
"<#{DEFAULT}>", 
"<#{NOFACE}>", 
"Black", 
"White", 
"Red", 
"Orange", 
"Yellow", 
"Green", 
"Blue", 
"Indigo", 
"Violet", 
"Cyan", 
"Magenta", 
"Gray", 
"Brown"
]
###
### Customizable list of the dialog's initial defaults...
###
Color= "Black" ### this 'name' MUST be in COLORS listed above...
Keep = YES ### YES substitute NO - note MUST be in CAPS
Hide = YES ### YES substitute NO - note MUST be in CAPS
Lock = YES ### YES substitute NO - note MUST be in CAPS
Glue = NO ### NO substitute YES or ONDEMAND - note MUST be in CAPS
### its layer IS NOT customizable, 
### but you can edit the 'SCUT' prefix in the .strings file
### Change Inset of the section-cut > default 0.1mm  [NO units] from the 
### SectionPlane - useful if the SCUT isn't showing at SectionPlane [GC issue].
Inset = 0.1
###
### Delete rogue files
sss=File.join(FOLDER, "~Superseded")
if File.exist?(sss)
	Dir.entries(sss).each{|f|
		if f=~/^SectionCutFace_3[-][0-7]/ && File.basename(f).downcase==".rbz"
			File.delete(File.join(sss, f))
		end
	} 
	Dir.delete(sss) if Dir.entries(sss).length==2
end
### Load main code
Sketchup::require(File.join(FOLDER, "SectionCutFace_code"))
###
### Setup Context-menu
unless file_loaded?(__FILE__)
UI.add_context_menu_handler{|menu|
	if TIG::SectionCutFace.ok()
		menu.add_item("#{MENUTXT}"){TIG::SectionCutFace.new()}
	end
	if TIG::SectionCutFace.ondemand()
		menu.add_item("#{MENUTXTOD}"){TIG::SectionCutFace.new(Sketchup.active_model.selection[0], true)}
	end
}
end#unless
file_loaded(__FILE__)
###
end #module SectionCutFace
###
end #module TIG
###
