=begin
#
TIG (c) 2005 - 2015
All rights reserved.
#
Name : SectionCutFace.rb
Type : Context Menu Tool == "Add Section-Cut Face"
Description : Adds a Group of Faces to a Selected Section-Plane
# 
=end
###
require 'sketchup.rb'
require 'extensions.rb'
###
module TIG
###
module SectionCutFace
###
### Setup Extn Constants
VERSION="4.7"
NAME="SectionCutFace"
CREATOR="TIG"
COPYRIGHT="#{NAME} © #{Time.now.year}"
### Setup Dir Constants
if defined?(Encoding)
	PLUGINS=File.dirname(__FILE__).force_encoding("UTF-8") ### v2014 lashup
else
	PLUGINS=File.dirname(__FILE__)
end
FOLDER=File.join(PLUGINS, NAME)
STRINGS=File.join(FOLDER, "Strings")
### Setup translated Constants
### File.exists? should always work as all ASCII in path?
	file=File.join(STRINGS, "SectionCutFace-#{Sketchup.get_locale.upcase}.strings")
	if File.exist?(file)
		lines=IO.readlines(file)
	else
		file=File.join(STRINGS, "#{NAME}-EN-US.strings")
		if File.exist?(file)
			lines=IO.readlines(file)
		else
			lines=[]
		end
	end
	lines.each{|line|
		line.chomp!
		next if line.empty? || line=~/^[#]/
		next unless line=~/[=]/
		eval(line) ### set CONSTANT=string
	}
###
### Extension set up
EXT=SketchupExtension.new(NAME, File.join(FOLDER, "SectionCutFace_loader.rb"))
EXT.name = NAME
EXT.description = DESC
EXT.version = VERSION
EXT.creator = CREATOR
EXT.copyright = COPYRIGHT
Sketchup.register_extension(EXT, true) # show on 1st install
###
end #module SectionCutFace
###
end #module TIG
###
