<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output 
		  method="html" 
		  version="4.0" 
		  encoding="UTF-8" 
		  omit-xml-declaration="yes" 
		  indent="yes"/>
		  
	<xsl:template match="/">
		<html>
			<body>
    		<table border="0" width="100%">
          <xsl:for-each select="Root/OperationGroup">
            <xsl:if test="GroupName">
              <tr>
                <td colspan="2">
                   <h3><xsl:value-of select="GroupName"/></h3>
                </td>
              </tr>
              <tr>
                <td valign="center" colspan="2">
                   <img src="hline_gray"/>
                </td>
              </tr>
              <xsl:for-each select="Operation">
                <tr>
                  <td>
                    <img align="right">
                      <xsl:attribute name="src"><xsl:value-of select="@icon"/></xsl:attribute>
                    </img>
                  </td>
                  <td width="100%">
                    <xsl:value-of select="."/>
                  </td>
                </tr>
              </xsl:for-each>
					  </xsl:if>
          </xsl:for-each>
    		</table>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="/Root">
  
</xsl:stylesheet>
