<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output 
		  method="text" 
		  version="4.0" 
		  encoding="UTF-8" 
		  omit-xml-declaration="yes" 
		  indent="yes"/>
		  
	<xsl:template match="/">
===============================================================================

	QT_TRANSLATE_NOOP("QObject", "Volume") <xsl:value-of select="Root/VolumeInfo/Label"/> <xsl:value-of select="Root/VolumeInfo/Drive"/>
	-----------------------------------------------------------------------
	QT_TRANSLATE_NOOP("QObject", "Volume Size:") <xsl:value-of select="Root/VolumeInfo/VolumeSize"/>
	QT_TRANSLATE_NOOP("QObject", "Cluster size:") <xsl:value-of select="Root/VolumeInfo/ClusterSize"/>
	QT_TRANSLATE_NOOP("QObject", "Free Space:") <xsl:value-of select="Root/VolumeInfo/FreeSpace"/>
	QT_TRANSLATE_NOOP("QObject", "Used Space:") <xsl:value-of select="Root/VolumeInfo/UsedSpace"/>


	QT_TRANSLATE_NOOP("QObject", "Free space fragmentation")
	-----------------------------------------------------------------------
<xsl:choose><xsl:when test="number(Root/VolumeInfo/FreeSpaceInBytes) = 0">
	QT_TRANSLATE_NOOP("QObject", "There is no free space on this volume.")
</xsl:when><xsl:otherwise>
	QT_TRANSLATE_NOOP("QObject", "Total Fragments:") <xsl:value-of select="Root/VolumeInfo/FragFreeSpace"/>
	QT_TRANSLATE_NOOP("QObject", "Fragmentation:") <xsl:value-of select="Root/VolumeInfo/FreeSpaceFragmentation"/>%
</xsl:otherwise></xsl:choose>

	QT_TRANSLATE_NOOP("QObject", "Bad clusters fragmentation")
	-----------------------------------------------------------------------
<xsl:choose><xsl:when test="number(Root/VolumeInfo/BadSpaceInBytes) = 0">
      QT_TRANSLATE_NOOP("QObject", "No bad blocks found.")
</xsl:when><xsl:otherwise>
	QT_TRANSLATE_NOOP("QObject", "Fragments Size:") <xsl:value-of select="Root/VolumeInfo/BadSpace"/>
	QT_TRANSLATE_NOOP("QObject", "Total Fragments:") <xsl:value-of select="Root/VolumeInfo/BadSpaceFragments"/>
</xsl:otherwise></xsl:choose>

	QT_TRANSLATE_NOOP("QObject", "Files fragmentation")
	-----------------------------------------------------------------------
	QT_TRANSLATE_NOOP("QObject", "Total Files:") <xsl:value-of select="Root/FilesInfo/FilesTotal"/>
	QT_TRANSLATE_NOOP("QObject", "Fragmented Files:") <xsl:value-of select="Root/FilesInfo/FilesFragmented"/>


	QT_TRANSLATE_NOOP("QObject", "Folders fragmentation")
	-----------------------------------------------------------------------
	QT_TRANSLATE_NOOP("QObject", "Total Folders:") <xsl:value-of select="Root/FilesInfo/FoldersTotal"/>
	QT_TRANSLATE_NOOP("QObject", "Fragmented Folders:") <xsl:value-of select="Root/FilesInfo/FoldersFragmented"/>

	<xsl:if test="number(Root/MFTInfo/UsedMFTRecords) != 0">
	QT_TRANSLATE_NOOP("QObject", "MFT fragmentation")
	-----------------------------------------------------------------------
	QT_TRANSLATE_NOOP("QObject", "Total MFT Size:") <xsl:value-of select="Root/MFTInfo/MFTSize"/>
	QT_TRANSLATE_NOOP("QObject", "MFT Records in Use:") <xsl:value-of select="Root/MFTInfo/UsedMFTRecords"/>
	QT_TRANSLATE_NOOP("QObject", "MFT Fragments:") <xsl:value-of select="Root/MFTInfo/MFTFragments"/>
	</xsl:if>
===============================================================================
</xsl:template>
</xsl:stylesheet>
